/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Function;
import java.util.function.Supplier;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.ModLoadingStage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.bluspring.kilt.Kilt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u001d2\u00020\u0001:\u0002\u001d\u001eB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\r\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ#\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\u000f\u0010\u0010J/\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\r\"\u0004\b\u0000\u0010\u00112\u0006\u0010\n\u001a\u00020\t2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0012\u00a2\u0006\u0004\b\u000f\u0010\u0013J=\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\r\"\u0004\b\u0000\u0010\u00112\u0006\u0010\n\u001a\u00020\t2\u0018\u0010\u0016\u001a\u0014\u0012\u0004\u0012\u00020\u0015\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\r0\u0014H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0019R\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00150\u001a8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001c\u00a8\u0006\u001f"}, d2={"Lnet/minecraftforge/fml/DeferredWorkQueue;", "", "Lnet/minecraftforge/fml/ModLoadingStage;", "stage", "<init>", "(Lnet/minecraftforge/fml/ModLoadingStage;)V", "", "runTasks", "()V", "Lnet/minecraftforge/fml/ModContainer;", "modInfo", "Ljava/lang/Runnable;", "work", "Ljava/util/concurrent/CompletableFuture;", "Ljava/lang/Void;", "enqueueWork", "(Lnet/minecraftforge/fml/ModContainer;Ljava/lang/Runnable;)Ljava/util/concurrent/CompletableFuture;", "T", "Ljava/util/function/Supplier;", "(Lnet/minecraftforge/fml/ModContainer;Ljava/util/function/Supplier;)Ljava/util/concurrent/CompletableFuture;", "Lkotlin/Function1;", "Lnet/minecraftforge/fml/DeferredWorkQueue$Task;", "futureSupplier", "addTask", "(Lnet/minecraftforge/fml/ModContainer;Lkotlin/jvm/functions/Function1;)Ljava/util/concurrent/CompletableFuture;", "Lnet/minecraftforge/fml/ModLoadingStage;", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "tasks", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Companion", "Task", "Kilt"})
public final class DeferredWorkQueue {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ModLoadingStage stage;
    @NotNull
    private final ConcurrentLinkedQueue<Task> tasks;
    @NotNull
    private static final Map<ModLoadingStage, DeferredWorkQueue> queues = new LinkedHashMap();

    public DeferredWorkQueue(@NotNull ModLoadingStage stage) {
        Intrinsics.checkNotNullParameter((Object)((Object)stage), (String)"stage");
        this.stage = stage;
        this.tasks = new ConcurrentLinkedQueue();
        queues.put(this.stage, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void runTasks() {
        if (this.tasks.isEmpty()) {
            return;
        }
        RuntimeException exception = new RuntimeException();
        Iterator<Task> iterator = this.tasks.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<Task> iterator2 = iterator;
        while (iterator2.hasNext()) {
            Task task = iterator2.next();
            ModLoadingContext.Companion.setKiltActiveModId(task.getOwner().getModId());
            try {
                task.getFuture().exceptionally(new Function(task, exception){
                    final /* synthetic */ Task $task;
                    final /* synthetic */ RuntimeException $exception;
                    {
                        this.$task = $task;
                        this.$exception = $exception;
                    }

                    public final Object apply(Throwable it) {
                        Kilt.Companion.getLogger().error("Mod \"" + this.$task.getOwner().getModId() + "\" encountered an error in a deferred task!");
                        it.printStackTrace();
                        Throwable throwable2 = this.$exception;
                        Intrinsics.checkNotNull((Object)it);
                        ExceptionsKt.addSuppressed((Throwable)throwable2, (Throwable)it);
                        return null;
                    }
                });
                task.getTask().run();
            }
            finally {
                ModLoadingContext.Companion.setKiltActiveModId(null);
            }
        }
        Throwable[] throwableArray = exception.getSuppressed();
        Intrinsics.checkNotNullExpressionValue((Object)throwableArray, (String)"getSuppressed(...)");
        if (!(((Object[])throwableArray).length == 0)) {
            throw exception;
        }
    }

    @NotNull
    public final CompletableFuture<Void> enqueueWork(@NotNull ModContainer modInfo, @NotNull Runnable work) {
        Intrinsics.checkNotNullParameter((Object)modInfo, (String)"modInfo");
        Intrinsics.checkNotNullParameter((Object)work, (String)"work");
        return this.addTask(modInfo, arg_0 -> DeferredWorkQueue.enqueueWork$lambda$0(work, arg_0));
    }

    @NotNull
    public final <T> CompletableFuture<T> enqueueWork(@NotNull ModContainer modInfo, @NotNull Supplier<T> work) {
        Intrinsics.checkNotNullParameter((Object)modInfo, (String)"modInfo");
        Intrinsics.checkNotNullParameter(work, (String)"work");
        return this.addTask(modInfo, arg_0 -> DeferredWorkQueue.enqueueWork$lambda$1(work, arg_0));
    }

    private final <T> CompletableFuture<T> addTask(ModContainer modInfo, Function1<? super Task, ? extends CompletableFuture<T>> futureSupplier) {
        Task task = new Task(modInfo);
        CompletableFuture future = (CompletableFuture)futureSupplier.invoke((Object)task);
        task.setFuture(future);
        this.tasks.add(task);
        return future;
    }

    private static final CompletableFuture enqueueWork$lambda$0(Runnable $work, Task task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        CompletableFuture<Void> completableFuture = CompletableFuture.runAsync($work, arg_0 -> DeferredWorkQueue.enqueueWork$lambda$0$0(task, arg_0));
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"runAsync(...)");
        return completableFuture;
    }

    private static final void enqueueWork$lambda$0$0(Task $task, Runnable it) {
        Intrinsics.checkNotNull((Object)it);
        $task.setTask(it);
    }

    private static final CompletableFuture enqueueWork$lambda$1(Supplier $work, Task task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        CompletableFuture completableFuture = CompletableFuture.supplyAsync($work, arg_0 -> DeferredWorkQueue.enqueueWork$lambda$1$0(task, arg_0));
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"supplyAsync(...)");
        return completableFuture;
    }

    private static final void enqueueWork$lambda$1$0(Task $task, Runnable it) {
        Intrinsics.checkNotNull((Object)it);
        $task.setTask(it);
    }

    @JvmStatic
    @NotNull
    public static final Optional<DeferredWorkQueue> lookup(@NotNull Optional<ModLoadingStage> parallelClass) {
        return Companion.lookup(parallelClass);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J#\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0007\u00a2\u0006\u0004\b\b\u0010\tR \u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00070\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lnet/minecraftforge/fml/DeferredWorkQueue$Companion;", "", "<init>", "()V", "Ljava/util/Optional;", "Lnet/minecraftforge/fml/ModLoadingStage;", "parallelClass", "Lnet/minecraftforge/fml/DeferredWorkQueue;", "lookup", "(Ljava/util/Optional;)Ljava/util/Optional;", "", "queues", "Ljava/util/Map;", "Kilt"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Optional<DeferredWorkQueue> lookup(@NotNull Optional<ModLoadingStage> parallelClass) {
            Intrinsics.checkNotNullParameter(parallelClass, (String)"parallelClass");
            Optional<DeferredWorkQueue> optional = Optional.ofNullable(queues.get(parallelClass.orElse(null)));
            Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(...)");
            return optional;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0082\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\b\u0010\tJ\u001a\u0010\f\u001a\u00020\u000b2\b\u0010\n\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u000f\u001a\u00020\u000eH\u00d6\u0001\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0010\u0010\u0012\u001a\u00020\u0011H\u00d6\u0001\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0014\u001a\u0004\b\u0015\u0010\u0007R\"\u0010\u0017\u001a\u00020\u00168\u0006@\u0006X\u0086.\u00a2\u0006\u0012\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR&\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\u001d8\u0006@\u0006X\u0086.\u00a2\u0006\u0012\n\u0004\b\u001e\u0010\u001f\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#\u00a8\u0006$"}, d2={"Lnet/minecraftforge/fml/DeferredWorkQueue$Task;", "", "Lnet/minecraftforge/fml/ModContainer;", "owner", "<init>", "(Lnet/minecraftforge/fml/ModContainer;)V", "component1", "()Lnet/minecraftforge/fml/ModContainer;", "copy", "(Lnet/minecraftforge/fml/ModContainer;)Lnet/minecraftforge/fml/DeferredWorkQueue$Task;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Lnet/minecraftforge/fml/ModContainer;", "getOwner", "Ljava/lang/Runnable;", "task", "Ljava/lang/Runnable;", "getTask", "()Ljava/lang/Runnable;", "setTask", "(Ljava/lang/Runnable;)V", "Ljava/util/concurrent/CompletableFuture;", "future", "Ljava/util/concurrent/CompletableFuture;", "getFuture", "()Ljava/util/concurrent/CompletableFuture;", "setFuture", "(Ljava/util/concurrent/CompletableFuture;)V", "Kilt"})
    private static final class Task {
        @NotNull
        private final ModContainer owner;
        public Runnable task;
        public CompletableFuture<?> future;

        public Task(@NotNull ModContainer owner) {
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            this.owner = owner;
        }

        @NotNull
        public final ModContainer getOwner() {
            return this.owner;
        }

        @NotNull
        public final Runnable getTask() {
            Runnable runnable = this.task;
            if (runnable != null) {
                return runnable;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"task");
            return null;
        }

        public final void setTask(@NotNull Runnable runnable) {
            Intrinsics.checkNotNullParameter((Object)runnable, (String)"<set-?>");
            this.task = runnable;
        }

        @NotNull
        public final CompletableFuture<?> getFuture() {
            CompletableFuture<?> completableFuture = this.future;
            if (completableFuture != null) {
                return completableFuture;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"future");
            return null;
        }

        public final void setFuture(@NotNull CompletableFuture<?> completableFuture) {
            Intrinsics.checkNotNullParameter(completableFuture, (String)"<set-?>");
            this.future = completableFuture;
        }

        @NotNull
        public final ModContainer component1() {
            return this.owner;
        }

        @NotNull
        public final Task copy(@NotNull ModContainer owner) {
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            return new Task(owner);
        }

        public static /* synthetic */ Task copy$default(Task task, ModContainer modContainer, int n, Object object) {
            if ((n & 1) != 0) {
                modContainer = task.owner;
            }
            return task.copy(modContainer);
        }

        @NotNull
        public String toString() {
            return "Task(owner=" + this.owner + ")";
        }

        public int hashCode() {
            return this.owner.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Task)) {
                return false;
            }
            Task task = (Task)other;
            return Intrinsics.areEqual((Object)this.owner, (Object)task.owner);
        }
    }
}

