/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml;

import java.util.Iterator;
import java.util.Spliterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u0019\u001aB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J+\u0010\n\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ3\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0007\u00a2\u0006\u0004\b\n\u0010\rJ+\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0005\u001a\u00020\u00042\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u000eH\u0007\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001d\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0012\u0010\u0014R&\u0010\u0017\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00160\u00158\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001b"}, d2={"Lnet/minecraftforge/fml/InterModComms;", "", "<init>", "()V", "", "modId", "method", "Ljava/util/function/Supplier;", "thing", "", "sendTo", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/function/Supplier;)Z", "senderModId", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/function/Supplier;)Z", "Ljava/util/function/Predicate;", "methodMatcher", "Ljava/util/stream/Stream;", "Lnet/minecraftforge/fml/InterModComms$IMCMessage;", "getMessages", "(Ljava/lang/String;Ljava/util/function/Predicate;)Ljava/util/stream/Stream;", "(Ljava/lang/String;)Ljava/util/stream/Stream;", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "containerQueues", "Ljava/util/concurrent/ConcurrentHashMap;", "IMCMessage", "QueueFilteringSpliterator", "Kilt"})
public final class InterModComms {
    @NotNull
    public static final InterModComms INSTANCE = new InterModComms();
    @NotNull
    private static final ConcurrentHashMap<String, ConcurrentLinkedQueue<IMCMessage>> containerQueues = new ConcurrentHashMap();

    private InterModComms() {
    }

    @JvmStatic
    public static final boolean sendTo(@NotNull String modId, @NotNull String method, @NotNull Supplier<?> thing) {
        Intrinsics.checkNotNullParameter((Object)modId, (String)"modId");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter(thing, (String)"thing");
        if (!ModList.Companion.get().isLoaded(modId)) {
            return false;
        }
        containerQueues.computeIfAbsent(modId, arg_0 -> InterModComms.sendTo$lambda$1(InterModComms::sendTo$lambda$0, arg_0)).add(new IMCMessage(ModLoadingContext.Companion.get().getActiveNamespace(), modId, method, thing));
        return true;
    }

    @JvmStatic
    public static final boolean sendTo(@NotNull String senderModId, @NotNull String modId, @NotNull String method, @NotNull Supplier<?> thing) {
        Intrinsics.checkNotNullParameter((Object)senderModId, (String)"senderModId");
        Intrinsics.checkNotNullParameter((Object)modId, (String)"modId");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter(thing, (String)"thing");
        if (!ModList.Companion.get().isLoaded(modId)) {
            return false;
        }
        containerQueues.computeIfAbsent(modId, arg_0 -> InterModComms.sendTo$lambda$3(InterModComms::sendTo$lambda$2, arg_0)).add(new IMCMessage(senderModId, modId, method, thing));
        return true;
    }

    @JvmStatic
    @NotNull
    public static final Stream<IMCMessage> getMessages(@NotNull String modId, @NotNull Predicate<String> methodMatcher) {
        Intrinsics.checkNotNullParameter((Object)modId, (String)"modId");
        Intrinsics.checkNotNullParameter(methodMatcher, (String)"methodMatcher");
        ConcurrentLinkedQueue<IMCMessage> concurrentLinkedQueue = containerQueues.get(modId);
        if (concurrentLinkedQueue == null) {
            Stream<IMCMessage> stream = Stream.empty();
            Intrinsics.checkNotNullExpressionValue(stream, (String)"empty(...)");
            return stream;
        }
        ConcurrentLinkedQueue<IMCMessage> queue = concurrentLinkedQueue;
        Stream<IMCMessage> stream = StreamSupport.stream(new QueueFilteringSpliterator(queue, methodMatcher), false);
        Intrinsics.checkNotNullExpressionValue(stream, (String)"stream(...)");
        return stream;
    }

    @JvmStatic
    @NotNull
    public static final Stream<IMCMessage> getMessages(@NotNull String modId) {
        Intrinsics.checkNotNullParameter((Object)modId, (String)"modId");
        return InterModComms.getMessages(modId, InterModComms::getMessages$lambda$0);
    }

    private static final ConcurrentLinkedQueue sendTo$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new ConcurrentLinkedQueue();
    }

    private static final ConcurrentLinkedQueue sendTo$lambda$1(Function1 $tmp0, Object p0) {
        return (ConcurrentLinkedQueue)$tmp0.invoke(p0);
    }

    private static final ConcurrentLinkedQueue sendTo$lambda$2(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new ConcurrentLinkedQueue();
    }

    private static final ConcurrentLinkedQueue sendTo$lambda$3(Function1 $tmp0, Object p0) {
        return (ConcurrentLinkedQueue)$tmp0.invoke(p0);
    }

    private static final boolean getMessages$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\b\u0086\b\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\f\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\f\u0010\u000bJ\u0010\u0010\r\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\r\u0010\u000bJ\u0014\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u0006H\u00c6\u0003\u00a2\u0006\u0004\b\u000e\u0010\u000fJ<\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0004\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u00022\f\b\u0002\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u0006H\u00c6\u0001\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001a\u0010\u0015\u001a\u00020\u00142\b\u0010\u0013\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0010\u0010\u0018\u001a\u00020\u0017H\u00d6\u0001\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0010\u0010\u001a\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b\u001a\u0010\u000bR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001b\u001a\u0004\b\u0003\u0010\u000bR\u0017\u0010\u0004\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u001b\u001a\u0004\b\u0004\u0010\u000bR\u0017\u0010\u0005\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u001b\u001a\u0004\b\u0005\u0010\u000bR\u001b\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\u001c\u001a\u0004\b\u0007\u0010\u000f\u00a8\u0006\u001d"}, d2={"Lnet/minecraftforge/fml/InterModComms$IMCMessage;", "Ljava/lang/Record;", "", "senderModId", "modId", "method", "Ljava/util/function/Supplier;", "messageSupplier", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/function/Supplier;)V", "component1", "()Ljava/lang/String;", "component2", "component3", "component4", "()Ljava/util/function/Supplier;", "copy", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/function/Supplier;)Lnet/minecraftforge/fml/InterModComms$IMCMessage;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "toString", "Ljava/lang/String;", "Ljava/util/function/Supplier;", "Kilt"})
    public static final class IMCMessage
    extends Record {
        @NotNull
        private final String senderModId;
        @NotNull
        private final String modId;
        @NotNull
        private final String method;
        @NotNull
        private final Supplier<?> messageSupplier;

        public IMCMessage(@NotNull String senderModId, @NotNull String modId, @NotNull String method, @NotNull Supplier<?> messageSupplier) {
            Intrinsics.checkNotNullParameter((Object)senderModId, (String)"senderModId");
            Intrinsics.checkNotNullParameter((Object)modId, (String)"modId");
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            Intrinsics.checkNotNullParameter(messageSupplier, (String)"messageSupplier");
            this.senderModId = senderModId;
            this.modId = modId;
            this.method = method;
            this.messageSupplier = messageSupplier;
        }

        @NotNull
        public final String senderModId() {
            return this.senderModId;
        }

        @NotNull
        public final String modId() {
            return this.modId;
        }

        @NotNull
        public final String method() {
            return this.method;
        }

        @NotNull
        public final Supplier<?> messageSupplier() {
            return this.messageSupplier;
        }

        @NotNull
        public final String component1() {
            return this.senderModId;
        }

        @NotNull
        public final String component2() {
            return this.modId;
        }

        @NotNull
        public final String component3() {
            return this.method;
        }

        @NotNull
        public final Supplier<?> component4() {
            return this.messageSupplier;
        }

        @NotNull
        public final IMCMessage copy(@NotNull String senderModId, @NotNull String modId, @NotNull String method, @NotNull Supplier<?> messageSupplier) {
            Intrinsics.checkNotNullParameter((Object)senderModId, (String)"senderModId");
            Intrinsics.checkNotNullParameter((Object)modId, (String)"modId");
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            Intrinsics.checkNotNullParameter(messageSupplier, (String)"messageSupplier");
            return new IMCMessage(senderModId, modId, method, messageSupplier);
        }

        public static /* synthetic */ IMCMessage copy$default(IMCMessage iMCMessage, String string, String string2, String string3, Supplier supplier, int n, Object object) {
            if ((n & 1) != 0) {
                string = iMCMessage.senderModId;
            }
            if ((n & 2) != 0) {
                string2 = iMCMessage.modId;
            }
            if ((n & 4) != 0) {
                string3 = iMCMessage.method;
            }
            if ((n & 8) != 0) {
                supplier = iMCMessage.messageSupplier;
            }
            return iMCMessage.copy(string, string2, string3, supplier);
        }

        @Override
        @NotNull
        public String toString() {
            return "IMCMessage(senderModId=" + this.senderModId + ", modId=" + this.modId + ", method=" + this.method + ", messageSupplier=" + this.messageSupplier + ")";
        }

        @Override
        public int hashCode() {
            int result = this.senderModId.hashCode();
            result = result * 31 + this.modId.hashCode();
            result = result * 31 + this.method.hashCode();
            result = result * 31 + this.messageSupplier.hashCode();
            return result;
        }

        @Override
        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof IMCMessage)) {
                return false;
            }
            IMCMessage iMCMessage = (IMCMessage)other;
            if (!Intrinsics.areEqual((Object)this.senderModId, (Object)iMCMessage.senderModId)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.modId, (Object)iMCMessage.modId)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.method, (Object)iMCMessage.method)) {
                return false;
            }
            return Intrinsics.areEqual(this.messageSupplier, iMCMessage.messageSupplier);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010)\n\u0002\b\u0004\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B#\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u0003\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u001f\u0010\r\u001a\u00020\f2\u000e\u0010\u000b\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00020\nH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u0001H\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000f\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u000f\u0010\u0015\u001a\u00020\u0014H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u00038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010\u0017R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0018R\"\u0010\u001b\u001a\u0010\u0012\f\u0012\n \u001a*\u0004\u0018\u00010\u00020\u00020\u00198\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001c\u00a8\u0006\u001d"}, d2={"Lnet/minecraftforge/fml/InterModComms$QueueFilteringSpliterator;", "Ljava/util/Spliterator;", "Lnet/minecraftforge/fml/InterModComms$IMCMessage;", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "queue", "Ljava/util/function/Predicate;", "", "methodFilter", "<init>", "(Ljava/util/concurrent/ConcurrentLinkedQueue;Ljava/util/function/Predicate;)V", "Ljava/util/function/Consumer;", "p0", "", "tryAdvance", "(Ljava/util/function/Consumer;)Z", "trySplit", "()Ljava/util/Spliterator;", "", "estimateSize", "()J", "", "characteristics", "()I", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Ljava/util/function/Predicate;", "", "kotlin.jvm.PlatformType", "iterator", "Ljava/util/Iterator;", "Kilt"})
    private static final class QueueFilteringSpliterator
    implements Spliterator<IMCMessage> {
        @NotNull
        private final ConcurrentLinkedQueue<IMCMessage> queue;
        @NotNull
        private final Predicate<String> methodFilter;
        @NotNull
        private final Iterator<IMCMessage> iterator;

        public QueueFilteringSpliterator(@NotNull ConcurrentLinkedQueue<IMCMessage> queue, @NotNull Predicate<String> methodFilter) {
            Intrinsics.checkNotNullParameter(queue, (String)"queue");
            Intrinsics.checkNotNullParameter(methodFilter, (String)"methodFilter");
            this.queue = queue;
            this.methodFilter = methodFilter;
            Iterator<IMCMessage> iterator = this.queue.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
            this.iterator = iterator;
        }

        @Override
        public boolean tryAdvance(@NotNull Consumer<? super IMCMessage> p0) {
            Intrinsics.checkNotNullParameter(p0, (String)"p0");
            IMCMessage next = null;
            do {
                if (!this.iterator.hasNext()) {
                    return false;
                }
                Intrinsics.checkNotNullExpressionValue((Object)this.iterator.next(), (String)"next(...)");
            } while (!this.methodFilter.test(next.method()));
            p0.accept(next);
            this.iterator.remove();
            return true;
        }

        @Override
        @Nullable
        public Spliterator<IMCMessage> trySplit() {
            return null;
        }

        @Override
        public long estimateSize() {
            return this.queue.size();
        }

        @Override
        public int characteristics() {
            return 4368;
        }
    }
}

