/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.event.lifecycle;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModLoadingStage;
import net.minecraftforge.fml.event.lifecycle.ModLifecycleEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u001b\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007B\t\b\u0016\u00a2\u0006\u0004\b\u0006\u0010\bJ\u001b\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\r\u0010\u000eJ'\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b\"\u0004\b\u0000\u0010\u000f2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u0010\u00a2\u0006\u0004\b\r\u0010\u0011R\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0012R\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u00138\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lnet/minecraftforge/fml/event/lifecycle/ParallelDispatchEvent;", "Lnet/minecraftforge/fml/event/lifecycle/ModLifecycleEvent;", "Lnet/minecraftforge/fml/ModContainer;", "mod", "Lnet/minecraftforge/fml/ModLoadingStage;", "stage", "<init>", "(Lnet/minecraftforge/fml/ModContainer;Lnet/minecraftforge/fml/ModLoadingStage;)V", "()V", "Ljava/lang/Runnable;", "work", "Ljava/util/concurrent/CompletableFuture;", "Ljava/lang/Void;", "enqueueWork", "(Ljava/lang/Runnable;)Ljava/util/concurrent/CompletableFuture;", "T", "Ljava/util/function/Supplier;", "(Ljava/util/function/Supplier;)Ljava/util/concurrent/CompletableFuture;", "Lnet/minecraftforge/fml/ModLoadingStage;", "Ljava/util/Optional;", "Lnet/minecraftforge/fml/DeferredWorkQueue;", "queue", "Ljava/util/Optional;", "Kilt"})
public class ParallelDispatchEvent
extends ModLifecycleEvent {
    @Nullable
    private final ModLoadingStage stage;
    @NotNull
    private final Optional<DeferredWorkQueue> queue;

    public ParallelDispatchEvent(@Nullable ModContainer mod, @Nullable ModLoadingStage stage) {
        super(mod);
        this.stage = stage;
        Optional<ModLoadingStage> optional = Optional.ofNullable(this.stage);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(...)");
        this.queue = DeferredWorkQueue.Companion.lookup(optional);
    }

    public ParallelDispatchEvent() {
        this(null, null);
    }

    @NotNull
    public final CompletableFuture<Void> enqueueWork(@NotNull Runnable work) {
        Intrinsics.checkNotNullParameter((Object)work, (String)"work");
        ModContainer modContainer = this.getContainer();
        Intrinsics.checkNotNull((Object)modContainer);
        return this.queue.orElseThrow().enqueueWork(modContainer, work);
    }

    @NotNull
    public final <T> CompletableFuture<T> enqueueWork(@NotNull Supplier<T> work) {
        Intrinsics.checkNotNullParameter(work, (String)"work");
        ModContainer modContainer = this.getContainer();
        Intrinsics.checkNotNull((Object)modContainer);
        return this.queue.orElseThrow().enqueueWork(modContainer, work);
    }
}

