/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading;

import java.io.File;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.fabricmc.loader.api.FabricLoader;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0011\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\r\u0010\u0006\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\r\u0010\b\u001a\u00020\u0002\u00a2\u0006\u0004\b\b\u0010\u0007R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\t\u00a8\u0006\u000b"}, d2={"Lnet/minecraftforge/fml/loading/FMLPaths;", "", "Ljava/nio/file/Path;", "path", "<init>", "(Ljava/nio/file/Path;)V", "get", "()Ljava/nio/file/Path;", "relative", "Ljava/nio/file/Path;", "Companion", "Kilt"})
public final class FMLPaths {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Path path;
    private static final Path gameDir = FabricLoader.getInstance().getGameDir().toAbsolutePath();
    @JvmField
    @NotNull
    public static final FMLPaths GAMEDIR;
    @JvmField
    @NotNull
    public static final FMLPaths MODSDIR;
    @JvmField
    @NotNull
    public static final FMLPaths CONFIGDIR;

    private FMLPaths(Path path) {
        this.path = path;
    }

    @NotNull
    public final Path get() {
        return this.path;
    }

    @NotNull
    public final Path relative() {
        Path path = this.path.relativize(gameDir);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"relativize(...)");
        return path;
    }

    @JvmStatic
    @NotNull
    public static final Path getOrCreateGameRelativePath(@NotNull Path path, @NotNull String name) {
        return Companion.getOrCreateGameRelativePath(path, name);
    }

    @JvmStatic
    @NotNull
    public static final Path getOrCreateGameRelativePath(@NotNull Path path) {
        return Companion.getOrCreateGameRelativePath(path);
    }

    static {
        Path path = FabricLoader.getInstance().getGameDir();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getGameDir(...)");
        GAMEDIR = new FMLPaths(path);
        String[] stringArray = new String[]{"mods"};
        Path path2 = Path.of(((Object)gameDir).toString(), stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"of(...)");
        MODSDIR = new FMLPaths(path2);
        Path path3 = FabricLoader.getInstance().getConfigDir();
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"getConfigDir(...)");
        CONFIGDIR = new FMLPaths(path3);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\b\u0010\nR\u001c\u0010\f\u001a\n \u000b*\u0004\u0018\u00010\u00040\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\f\u0010\rR\u0014\u0010\u000f\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0010R\u0014\u0010\u0012\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0010\u00a8\u0006\u0013"}, d2={"Lnet/minecraftforge/fml/loading/FMLPaths$Companion;", "", "<init>", "()V", "Ljava/nio/file/Path;", "path", "", "name", "getOrCreateGameRelativePath", "(Ljava/nio/file/Path;Ljava/lang/String;)Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "gameDir", "Ljava/nio/file/Path;", "Lnet/minecraftforge/fml/loading/FMLPaths;", "GAMEDIR", "Lnet/minecraftforge/fml/loading/FMLPaths;", "MODSDIR", "CONFIGDIR", "Kilt"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Path getOrCreateGameRelativePath(@NotNull Path path, @NotNull String name) {
            File file;
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            File $this$getOrCreateGameRelativePath_u24lambda_u240 = file = new File(GAMEDIR.get().resolve(path).toFile(), name);
            boolean bl = false;
            if (!$this$getOrCreateGameRelativePath_u24lambda_u240.exists()) {
                $this$getOrCreateGameRelativePath_u24lambda_u240.mkdirs();
            }
            Path path2 = file.toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"toPath(...)");
            return path2;
        }

        @JvmStatic
        @NotNull
        public final Path getOrCreateGameRelativePath(@NotNull Path path) {
            File file;
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            File $this$getOrCreateGameRelativePath_u24lambda_u241 = file = GAMEDIR.get().resolve(path).toFile();
            boolean bl = false;
            if (!$this$getOrCreateGameRelativePath_u24lambda_u241.exists()) {
                $this$getOrCreateGameRelativePath_u24lambda_u241.mkdirs();
            }
            Path path2 = file.toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"toPath(...)");
            return path2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

