/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading.moddiscovery;

import cpw.mods.jarhandling.SecureJar;
import java.io.File;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraftforge.fml.loading.moddiscovery.ModFileInfo;
import net.minecraftforge.fml.loading.moddiscovery.ModInfo;
import net.minecraftforge.forgespi.language.IModFileInfo;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.forgespi.language.IModLanguageProvider;
import net.minecraftforge.forgespi.language.ModFileScanData;
import net.minecraftforge.forgespi.locating.IModFile;
import net.minecraftforge.forgespi.locating.IModProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.bluspring.kilt.Kilt;
import xyz.bluspring.kilt.loader.KiltModProvider;
import xyz.bluspring.kilt.loader.mod.ForgeMod;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0015\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ#\u0010\u000e\u001a\u00020\r2\u0012\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n\"\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ!\u0010\u0013\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00120\u00110\u0010H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u000f\u0010\u0016\u001a\u00020\u0015H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u000f\u0010\u0018\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u000f\u0010\u001b\u001a\u00020\u001aH\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0019\u0010 \u001a\u00020\u001f2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001dH\u0016\u00a2\u0006\u0004\b \u0010!J\u0015\u0010#\u001a\b\u0012\u0004\u0012\u00020\"0\u0006H\u0016\u00a2\u0006\u0004\b#\u0010\tJ\u000f\u0010%\u001a\u00020$H\u0016\u00a2\u0006\u0004\b%\u0010&J\u000f\u0010'\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b'\u0010(J\u000f\u0010*\u001a\u00020)H\u0016\u00a2\u0006\u0004\b*\u0010+J\u000f\u0010-\u001a\u00020,H\u0016\u00a2\u0006\u0004\b-\u0010.R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010/\u00a8\u00060"}, d2={"Lnet/minecraftforge/fml/loading/moddiscovery/ModFile;", "Lnet/minecraftforge/forgespi/locating/IModFile;", "Lxyz/bluspring/kilt/loader/mod/ForgeMod;", "kiltMod", "<init>", "(Lxyz/bluspring/kilt/loader/mod/ForgeMod;)V", "", "Lnet/minecraftforge/forgespi/language/IModLanguageProvider;", "getLoaders", "()Ljava/util/List;", "", "", "pathName", "Ljava/nio/file/Path;", "findResource", "([Ljava/lang/String;)Ljava/nio/file/Path;", "Ljava/util/function/Supplier;", "", "", "getSubstitutionMap", "()Ljava/util/function/Supplier;", "Lnet/minecraftforge/forgespi/locating/IModFile$Type;", "getType", "()Lnet/minecraftforge/forgespi/locating/IModFile$Type;", "getFilePath", "()Ljava/nio/file/Path;", "Lcpw/mods/jarhandling/SecureJar;", "getSecureJar", "()Lcpw/mods/jarhandling/SecureJar;", "Lcpw/mods/jarhandling/SecureJar$Status;", "status", "", "setSecurityStatus", "(Lcpw/mods/jarhandling/SecureJar$Status;)V", "Lnet/minecraftforge/forgespi/language/IModInfo;", "getModInfos", "Lnet/minecraftforge/forgespi/language/ModFileScanData;", "getScanResult", "()Lnet/minecraftforge/forgespi/language/ModFileScanData;", "getFileName", "()Ljava/lang/String;", "Lnet/minecraftforge/forgespi/locating/IModProvider;", "getProvider", "()Lnet/minecraftforge/forgespi/locating/IModProvider;", "Lnet/minecraftforge/forgespi/language/IModFileInfo;", "getModFileInfo", "()Lnet/minecraftforge/forgespi/language/IModFileInfo;", "Lxyz/bluspring/kilt/loader/mod/ForgeMod;", "Kilt"})
public final class ModFile
implements IModFile {
    @NotNull
    private final ForgeMod kiltMod;

    public ModFile(@NotNull ForgeMod kiltMod) {
        Intrinsics.checkNotNullParameter((Object)((Object)kiltMod), (String)"kiltMod");
        this.kiltMod = kiltMod;
    }

    @NotNull
    public List<IModLanguageProvider> getLoaders() {
        return new ArrayList();
    }

    @NotNull
    public Path findResource(String ... pathName) {
        Intrinsics.checkNotNullParameter((Object)pathName, (String)"pathName");
        if (pathName.length == 0) {
            throw new IllegalArgumentException("Missing path");
        }
        Path path = this.kiltMod.getSecureJar().get().getPath(ArraysKt.joinToString$default((Object[])pathName, (CharSequence)"/", null, null, (int)0, null, null, (int)62, null), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getPath(...)");
        return path;
    }

    @NotNull
    public Supplier<Map<String, Object>> getSubstitutionMap() {
        return ModFile::getSubstitutionMap$lambda$0;
    }

    @NotNull
    public IModFile.Type getType() {
        return IModFile.Type.MOD;
    }

    @NotNull
    public Path getFilePath() {
        if (this.kiltMod.getModFile() == null) {
            URI uRI = Kilt.class.getProtectionDomain().getCodeSource().getLocation().toURI();
            Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"toURI(...)");
            Path path = Paths.get(uRI);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
            return path;
        }
        Path path = this.kiltMod.getModFile().toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
        return path;
    }

    @NotNull
    public SecureJar getSecureJar() {
        SecureJar secureJar = this.kiltMod.getSecureJar().get();
        Intrinsics.checkNotNullExpressionValue((Object)secureJar, (String)"get(...)");
        return secureJar;
    }

    public void setSecurityStatus(@Nullable SecureJar.Status status) {
    }

    @NotNull
    public List<IModInfo> getModInfos() {
        Object[] objectArray = new IModInfo[]{new ModInfo(this.kiltMod, null, 2, null)};
        return CollectionsKt.mutableListOf((Object[])objectArray);
    }

    @NotNull
    public ModFileScanData getScanResult() {
        return this.kiltMod.getScanData();
    }

    @NotNull
    public String getFileName() {
        Object object = this.kiltMod.getModFile();
        if (object == null || (object = ((File)object).getName()) == null) {
            object = "(unknown)";
        }
        return object;
    }

    @NotNull
    public IModProvider getProvider() {
        return new KiltModProvider();
    }

    @NotNull
    public IModFileInfo getModFileInfo() {
        return new ModFileInfo(this.kiltMod, null, 2, null);
    }

    private static final Map getSubstitutionMap$lambda$0() {
        return new LinkedHashMap();
    }
}

