/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading.progress;

import com.google.common.base.Ascii;
import com.google.common.base.CharMatcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import net.minecraftforge.fml.loading.progress.ProgressMeter;
import net.minecraftforge.fml.loading.progress.StartupMessageManager;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002$%B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0003\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\r\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001b\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00100\u000fH\u0007\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u001b\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00100\u000fH\u0007\u00a2\u0006\u0004\b\u0013\u0010\u0012J\u001b\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00100\u000fH\u0007\u00a2\u0006\u0004\b\u0014\u0010\u0012J\u001f\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\bH\u0007\u00a2\u0006\u0004\b\u0018\u0010\u0019R(\u0010\u001d\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0\u001b0\u001a8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001eR,\u0010#\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u001c0\u001f0\u001b8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\"\u0010\u0003\u001a\u0004\b \u0010!\u00a8\u0006&"}, d2={"Lnet/minecraftforge/fml/loading/progress/StartupMessageManager;", "", "<init>", "()V", "Lnet/minecraftforge/fml/loading/progress/StartupMessageManager$MessageType;", "type", "", "message", "", "maxSize", "", "addMessage", "(Lnet/minecraftforge/fml/loading/progress/StartupMessageManager$MessageType;Ljava/lang/String;I)V", "addModMessage", "(Ljava/lang/String;)V", "Ljava/util/Optional;", "Ljava/util/function/Consumer;", "modLoaderConsumer", "()Ljava/util/Optional;", "locatorConsumer", "mcLoaderConsumer", "barName", "count", "Lnet/minecraftforge/fml/loading/progress/ProgressMeter;", "addProgressBar", "(Ljava/lang/String;I)Lnet/minecraftforge/fml/loading/progress/ProgressMeter;", "Ljava/util/EnumMap;", "", "Lnet/minecraftforge/fml/loading/progress/StartupMessageManager$Message;", "startupMessages", "Ljava/util/EnumMap;", "Lorg/apache/commons/lang3/tuple/Pair;", "getMessages", "()Ljava/util/List;", "getMessages$annotations", "messages", "Message", "MessageType", "Kilt"})
public final class StartupMessageManager {
    @NotNull
    public static final StartupMessageManager INSTANCE = new StartupMessageManager();
    @NotNull
    private static volatile EnumMap<MessageType, List<Message>> startupMessages = new EnumMap(MessageType.class);

    private StartupMessageManager() {
    }

    @NotNull
    public static final List<Pair<Integer, Message>> getMessages() {
        long ts = System.nanoTime();
        Collection<List<Message>> collection = startupMessages.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Sequence sequence = SequencesKt.flattenSequenceOfIterable((Sequence)CollectionsKt.asSequence((Iterable)collection));
        Comparator<Object> comparator = Comparator.comparingLong(arg_0 -> StartupMessageManager._get_messages_$lambda$1(StartupMessageManager::_get_messages_$lambda$0, arg_0)).thenComparing(arg_0 -> StartupMessageManager._get_messages_$lambda$2((Function1)messages.2.INSTANCE, arg_0)).reversed();
        Intrinsics.checkNotNullExpressionValue(comparator, (String)"reversed(...)");
        return SequencesKt.toList((Sequence)SequencesKt.take((Sequence)SequencesKt.map((Sequence)SequencesKt.sortedWith((Sequence)sequence, comparator), arg_0 -> StartupMessageManager._get_messages_$lambda$3(ts, arg_0)), (int)5));
    }

    @JvmStatic
    public static /* synthetic */ void getMessages$annotations() {
    }

    @JvmStatic
    private static final synchronized void addMessage(MessageType type, String message2, int maxSize) {
        EnumMap<MessageType, List<Message>> newMessages = new EnumMap<MessageType, List<Message>>(startupMessages);
        newMessages.compute(type, (arg_0, arg_1) -> StartupMessageManager.addMessage$lambda$1((arg_0, arg_1) -> StartupMessageManager.addMessage$lambda$0(maxSize, message2, type, arg_0, arg_1), arg_0, arg_1));
        startupMessages = newMessages;
    }

    @JvmStatic
    public static final void addModMessage(@NotNull String message2) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        String safeMessage = Ascii.truncate((CharSequence)CharMatcher.ascii().retainFrom((CharSequence)message2), (int)80, (String)"~");
        Intrinsics.checkNotNull((Object)safeMessage);
        StartupMessageManager.addMessage(MessageType.MOD, safeMessage, 20);
    }

    @JvmStatic
    @NotNull
    public static final Optional<Consumer<String>> modLoaderConsumer() {
        Optional<Consumer<String>> optional = Optional.of(StartupMessageManager::modLoaderConsumer$lambda$0);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"of(...)");
        return optional;
    }

    @JvmStatic
    @NotNull
    public static final Optional<Consumer<String>> locatorConsumer() {
        Optional<Consumer<String>> optional = Optional.of(StartupMessageManager::locatorConsumer$lambda$0);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"of(...)");
        return optional;
    }

    @JvmStatic
    @NotNull
    public static final Optional<Consumer<String>> mcLoaderConsumer() {
        Optional<Consumer<String>> optional = Optional.of(StartupMessageManager::mcLoaderConsumer$lambda$0);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"of(...)");
        return optional;
    }

    @JvmStatic
    @NotNull
    public static final ProgressMeter addProgressBar(@NotNull String barName, int count) {
        Intrinsics.checkNotNullParameter((Object)barName, (String)"barName");
        return new ProgressMeter(barName, count, count, null);
    }

    private static final long _get_messages_$lambda$0(Message it) {
        return it.getTimestamp();
    }

    private static final long _get_messages_$lambda$1(Function1 $tmp0, Object p0) {
        return ((Number)$tmp0.invoke(p0)).longValue();
    }

    private static final String _get_messages_$lambda$2(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final Pair _get_messages_$lambda$3(long $ts, Message it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Pair.of((Object)((int)((double)($ts - it.getTimestamp()) / 1000000.0)), (Object)it);
    }

    private static final List addMessage$lambda$0(int $maxSize, String $message, MessageType $type, MessageType messageType, List existing) {
        List newList = new ArrayList();
        if (existing != null) {
            boolean bl = $maxSize < 0 ? newList.addAll(existing) : newList.addAll(existing.subList(0, RangesKt.coerceAtMost((int)existing.size(), (int)$maxSize)));
        }
        newList.add(new Message($message, $type));
        return newList;
    }

    private static final List addMessage$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        return (List)$tmp0.invoke(p0, p1);
    }

    private static final void modLoaderConsumer$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        StartupMessageManager.addMessage(MessageType.ML, it, -1);
    }

    private static final void locatorConsumer$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        StartupMessageManager.addMessage(MessageType.LOC, it, -1);
    }

    private static final void mcLoaderConsumer$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        StartupMessageManager.addMessage(MessageType.MC, it, -1);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0010\u0007\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\b\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u000b\u001a\u0004\b\f\u0010\rR\u0017\u0010\u000f\u001a\u00020\u000e8\u0006\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012R\u001d\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u00138\u0006\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u0019"}, d2={"Lnet/minecraftforge/fml/loading/progress/StartupMessageManager$Message;", "", "", "text", "Lnet/minecraftforge/fml/loading/progress/StartupMessageManager$MessageType;", "type", "<init>", "(Ljava/lang/String;Lnet/minecraftforge/fml/loading/progress/StartupMessageManager$MessageType;)V", "Ljava/lang/String;", "getText", "()Ljava/lang/String;", "Lnet/minecraftforge/fml/loading/progress/StartupMessageManager$MessageType;", "getType", "()Lnet/minecraftforge/fml/loading/progress/StartupMessageManager$MessageType;", "", "timestamp", "J", "getTimestamp", "()J", "", "", "typeColour", "[Ljava/lang/Float;", "getTypeColour", "()[Ljava/lang/Float;", "Kilt"})
    public static final class Message {
        @NotNull
        private final String text;
        @NotNull
        private final MessageType type;
        private final long timestamp;
        @NotNull
        private final Float[] typeColour;

        public Message(@NotNull String text, @NotNull MessageType type) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            this.text = text;
            this.type = type;
            this.timestamp = System.nanoTime();
            this.typeColour = this.type.colour();
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        @NotNull
        public final MessageType getType() {
            return this.type;
        }

        public final long getTimestamp() {
            return this.timestamp;
        }

        @NotNull
        public final Float[] getTypeColour() {
            return this.typeColour;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\b\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B!\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0013\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\b\u00a2\u0006\u0004\b\t\u0010\nR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000f\u00a8\u0006\u0010"}, d2={"Lnet/minecraftforge/fml/loading/progress/StartupMessageManager$MessageType;", "", "", "r", "g", "b", "<init>", "(Ljava/lang/String;IFFF)V", "", "colour", "()[Ljava/lang/Float;", "[Ljava/lang/Float;", "MC", "ML", "LOC", "MOD", "Kilt"})
    public static final class MessageType
    extends Enum<MessageType> {
        @NotNull
        private final Float[] colour;
        public static final /* enum */ MessageType MC = new MessageType(1.0f, 1.0f, 1.0f);
        public static final /* enum */ MessageType ML = new MessageType(0.0f, 0.0f, 0.5f);
        public static final /* enum */ MessageType LOC = new MessageType(0.5f, 0.5f, 0.0f);
        public static final /* enum */ MessageType MOD = new MessageType(0.5f, 0.0f, 0.0f);
        private static final /* synthetic */ MessageType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private MessageType(float r, float g, float b) {
            Float[] floatArray = new Float[]{Float.valueOf(r), Float.valueOf(g), Float.valueOf(b)};
            this.colour = floatArray;
        }

        @NotNull
        public final Float[] colour() {
            return this.colour;
        }

        public static MessageType[] values() {
            return (MessageType[])$VALUES.clone();
        }

        public static MessageType valueOf(String value) {
            return Enum.valueOf(MessageType.class, value);
        }

        @NotNull
        public static EnumEntries<MessageType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = messageTypeArray = new MessageType[]{MessageType.MC, MessageType.ML, MessageType.LOC, MessageType.MOD};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

