/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.items.wrapper;

import java.util.function.IntUnaryOperator;
import net.minecraft.class_1278;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2350;
import net.minecraft.class_2589;
import net.minecraft.class_2609;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SidedInvWrapper
implements IItemHandlerModifiable {
    protected final class_1278 inv;
    @Nullable
    protected final class_2350 side;
    private final IntUnaryOperator slotLimit;
    private final InsertLimit newStackInsertLimit;

    public static LazyOptional<IItemHandlerModifiable>[] create(class_1278 inv, class_2350 ... sides) {
        LazyOptional[] ret = new LazyOptional[sides.length];
        for (int x = 0; x < sides.length; ++x) {
            class_2350 side = sides[x];
            ret[x] = LazyOptional.of(() -> new SidedInvWrapper(inv, side));
        }
        return ret;
    }

    public SidedInvWrapper(class_1278 inv, @Nullable class_2350 side) {
        this.inv = inv;
        this.side = side;
        this.slotLimit = inv instanceof class_2589 ? wrapperSlot -> SidedInvWrapper.getSlot(inv, wrapperSlot, side) < 3 ? 1 : inv.method_5444() : wrapperSlot -> inv.method_5444();
        this.newStackInsertLimit = inv instanceof class_2609 ? (wrapperSlot, invSlot, stack) -> invSlot == 1 && stack.method_31574(class_1802.field_8550) ? 1 : Math.min(stack.method_7914(), this.getSlotLimit(wrapperSlot)) : (wrapperSlot, invSlot, stack) -> Math.min(stack.method_7914(), this.getSlotLimit(wrapperSlot));
    }

    public static int getSlot(class_1278 inv, int slot, @Nullable class_2350 side) {
        int[] slots = inv.method_5494(side);
        if (slot < slots.length) {
            return slots[slot];
        }
        return -1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SidedInvWrapper that = (SidedInvWrapper)o;
        return this.inv.equals(that.inv) && this.side == that.side;
    }

    public int hashCode() {
        int result = this.inv.hashCode();
        result = 31 * result + (this.side == null ? 0 : this.side.hashCode());
        return result;
    }

    @Override
    public int getSlots() {
        return this.inv.method_5494(this.side).length;
    }

    @Override
    @NotNull
    public class_1799 getStackInSlot(int slot) {
        int i = SidedInvWrapper.getSlot(this.inv, slot, this.side);
        return i == -1 ? class_1799.field_8037 : this.inv.method_5438(i);
    }

    @Override
    @NotNull
    public class_1799 insertItem(int slot, @NotNull class_1799 stack, boolean simulate) {
        if (stack.method_7960()) {
            return class_1799.field_8037;
        }
        int slot1 = SidedInvWrapper.getSlot(this.inv, slot, this.side);
        if (slot1 == -1) {
            return stack;
        }
        class_1799 stackInSlot = this.inv.method_5438(slot1);
        if (!stackInSlot.method_7960()) {
            if (stackInSlot.method_7947() >= Math.min(stackInSlot.method_7914(), this.getSlotLimit(slot))) {
                return stack;
            }
            if (!ItemHandlerHelper.canItemStacksStack(stack, stackInSlot)) {
                return stack;
            }
            if (!this.inv.method_5492(slot1, stack, this.side) || !this.inv.method_5437(slot1, stack)) {
                return stack;
            }
            int m = Math.min(stack.method_7914(), this.getSlotLimit(slot)) - stackInSlot.method_7947();
            if (stack.method_7947() <= m) {
                if (!simulate) {
                    class_1799 copy = stack.method_7972();
                    copy.method_7933(stackInSlot.method_7947());
                    this.setInventorySlotContents(slot1, copy);
                }
                return class_1799.field_8037;
            }
            stack = stack.method_7972();
            if (!simulate) {
                class_1799 copy = stack.method_7971(m);
                copy.method_7933(stackInSlot.method_7947());
                this.setInventorySlotContents(slot1, copy);
                return stack;
            }
            stack.method_7934(m);
            return stack;
        }
        if (!this.inv.method_5492(slot1, stack, this.side) || !this.inv.method_5437(slot1, stack)) {
            return stack;
        }
        int m = this.newStackInsertLimit.limitInsert(slot, slot1, stack);
        if (m < stack.method_7947()) {
            stack = stack.method_7972();
            if (!simulate) {
                this.setInventorySlotContents(slot1, stack.method_7971(m));
                return stack;
            }
            stack.method_7934(m);
            return stack;
        }
        if (!simulate) {
            this.setInventorySlotContents(slot1, stack);
        }
        return class_1799.field_8037;
    }

    @Override
    public void setStackInSlot(int slot, @NotNull class_1799 stack) {
        int slot1 = SidedInvWrapper.getSlot(this.inv, slot, this.side);
        if (slot1 != -1) {
            this.setInventorySlotContents(slot1, stack);
        }
    }

    private void setInventorySlotContents(int slot, class_1799 stack) {
        this.inv.method_5431();
        this.inv.method_5447(slot, stack);
    }

    @Override
    @NotNull
    public class_1799 extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return class_1799.field_8037;
        }
        int slot1 = SidedInvWrapper.getSlot(this.inv, slot, this.side);
        if (slot1 == -1) {
            return class_1799.field_8037;
        }
        class_1799 stackInSlot = this.inv.method_5438(slot1);
        if (stackInSlot.method_7960()) {
            return class_1799.field_8037;
        }
        if (!this.inv.method_5493(slot1, stackInSlot, this.side)) {
            return class_1799.field_8037;
        }
        if (simulate) {
            if (stackInSlot.method_7947() < amount) {
                return stackInSlot.method_7972();
            }
            class_1799 copy = stackInSlot.method_7972();
            copy.method_7939(amount);
            return copy;
        }
        int m = Math.min(stackInSlot.method_7947(), amount);
        class_1799 ret = this.inv.method_5434(slot1, m);
        this.inv.method_5431();
        return ret;
    }

    @Override
    public int getSlotLimit(int slot) {
        return this.slotLimit.applyAsInt(slot);
    }

    @Override
    public boolean isItemValid(int slot, @NotNull class_1799 stack) {
        int slot1 = SidedInvWrapper.getSlot(this.inv, slot, this.side);
        return slot1 == -1 ? false : this.inv.method_5437(slot1, stack);
    }

    private static interface InsertLimit {
        public int limitInsert(int var1, int var2, class_1799 var3);
    }
}

