/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.logging;

import cpw.mods.modlauncher.log.TransformingThrowablePatternConverter;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import joptsimple.internal.Strings;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_6396;
import net.minecraftforge.fml.CrashReportCallables;
import net.minecraftforge.fml.ISystemReportExtender;
import net.minecraftforge.fml.LoadingFailedException;
import net.minecraftforge.forgespi.language.IModFileInfo;
import net.minecraftforge.forgespi.language.IModInfo;
import org.apache.logging.log4j.Logger;

public class CrashReportExtender {
    public static void extendSystemReport(class_6396 systemReport) {
        for (ISystemReportExtender call : CrashReportCallables.allCrashCallables()) {
            if (!call.isActive()) continue;
            systemReport.method_37123(call.getLabel(), (Supplier)call);
        }
    }

    public static void addCrashReportHeader(StringBuilder stringbuilder, class_128 crashReport) {
    }

    public static String generateEnhancedStackTrace(Throwable throwable2) {
        return CrashReportExtender.generateEnhancedStackTrace(throwable2, true);
    }

    public static String generateEnhancedStackTrace(StackTraceElement[] stacktrace) {
        Throwable t = new Throwable();
        t.setStackTrace(stacktrace);
        return CrashReportExtender.generateEnhancedStackTrace(t, false);
    }

    public static String generateEnhancedStackTrace(Throwable throwable2, boolean header) {
        String s = TransformingThrowablePatternConverter.generateEnhancedStackTrace(throwable2);
        return header ? s : s.substring(s.indexOf(Strings.LINE_SEPARATOR));
    }

    public static File dumpModLoadingCrashReport(Logger logger, LoadingFailedException error, File topLevelDir) {
        class_128 crashReport = class_128.method_560((Throwable)new Exception("Mod Loading has failed"), (String)"Mod loading error has occurred");
        error.getErrors().forEach(mle -> {
            Throwable cause;
            Optional<IModInfo> modInfo = Optional.ofNullable(mle.getModInfo());
            class_129 category = crashReport.method_562(modInfo.map(iModInfo -> "MOD " + iModInfo.getModId()).orElse("NO MOD INFO AVAILABLE"));
            int depth = 0;
            for (cause = mle.getCause(); cause != null && cause.getCause() != null && cause.getCause() != cause; cause = cause.getCause()) {
                category.method_578("Caused by " + depth++, (Object)(String.valueOf(cause) + CrashReportExtender.generateEnhancedStackTrace(cause.getStackTrace()).replaceAll(Strings.LINE_SEPARATOR + "\t", "\n\t\t")));
            }
            if (cause != null) {
                category.applyStackTrace(cause);
            }
            category.method_577("Mod File", () -> modInfo.map(IModInfo::getOwningFile).map(t -> t.getFile().getFilePath().toUri().getPath()).orElse("NO FILE INFO"));
            category.method_577("Failure message", () -> mle.getCleanMessage().replace("\n", "\n\t\t"));
            category.method_577("Mod Version", () -> modInfo.map(IModInfo::getVersion).map(Object::toString).orElse("NO MOD INFO AVAILABLE"));
            category.method_577("Mod Issue URL", () -> modInfo.map(IModInfo::getOwningFile).map(IModFileInfo.class::cast).flatMap(mfi -> mfi.getConfig().getConfigElement(new String[]{"issueTrackerURL"})).orElse("NOT PROVIDED"));
            category.method_578("Exception message", (Object)Objects.toString(cause, "MISSING EXCEPTION MESSAGE"));
        });
        File file1 = new File(topLevelDir, "crash-reports");
        File file2 = new File(file1, "crash-" + new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date()) + "-fml.txt");
        if (crashReport.method_569(file2)) {
            logger.fatal("Crash report saved to {}", (Object)file2);
        } else {
            logger.fatal("Failed to save crash report");
        }
        System.out.print(crashReport.method_568());
        return file2;
    }
}

