/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.network;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_2960;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.network.NetworkRegistry;
import org.apache.commons.lang3.tuple.Pair;

public class ConnectionData {
    private ImmutableMap<String, Pair<String, String>> modData;
    private ImmutableMap<class_2960, String> channels;

    ConnectionData(Map<String, Pair<String, String>> modData, Map<class_2960, String> channels) {
        this.modData = ImmutableMap.copyOf(modData);
        this.channels = ImmutableMap.copyOf(channels);
    }

    public ImmutableList<String> getModList() {
        return this.modData.keySet().asList();
    }

    public ImmutableMap<String, Pair<String, String>> getModData() {
        return this.modData;
    }

    public ImmutableMap<class_2960, String> getChannels() {
        return this.channels;
    }

    public record ModMismatchData(Map<class_2960, String> mismatchedModData, Map<class_2960, Pair<String, String>> presentModData, boolean mismatchedDataFromServer) {
        public static ModMismatchData channel(Map<class_2960, String> mismatchedChannels, ConnectionData connectionData, boolean mismatchedDataFromServer) {
            Map<class_2960, String> mismatchedChannelData = ModMismatchData.enhanceWithModVersion(mismatchedChannels, connectionData, mismatchedDataFromServer);
            Map<class_2960, Pair<String, String>> presentChannelData = ModMismatchData.getPresentChannelData(mismatchedChannels.keySet(), connectionData, mismatchedDataFromServer);
            return new ModMismatchData(mismatchedChannelData, presentChannelData, mismatchedDataFromServer);
        }

        public static ModMismatchData registry(Multimap<class_2960, class_2960> mismatchedRegistryData, ConnectionData connectionData) {
            List<class_2960> mismatchedRegistryMods = mismatchedRegistryData.values().stream().map(class_2960::method_12836).distinct().map(id -> new class_2960(id, "")).toList();
            Map<class_2960, String> mismatchedRegistryModData = mismatchedRegistryMods.stream().map(id -> ModList.get().getModContainerById(id.method_12836()).map(modContainer -> Pair.of((Object)id, (Object)modContainer.getModInfo().getVersion().toString())).orElse(Pair.of((Object)id, (Object)NetworkRegistry.ABSENT.version()))).collect(Collectors.toMap(Pair::getLeft, Pair::getRight));
            Map<class_2960, Pair<String, String>> presentModData = ModMismatchData.getServerSidePresentModData(mismatchedRegistryModData.keySet(), connectionData);
            return new ModMismatchData(mismatchedRegistryModData, presentModData, false);
        }

        public boolean containsMismatches() {
            return this.mismatchedModData != null && !this.mismatchedModData.isEmpty();
        }

        private static Map<class_2960, String> enhanceWithModVersion(Map<class_2960, String> mismatchedChannels, ConnectionData connectionData, boolean mismatchedDataFromServer) {
            Map<Object, Object> mismatchedModVersions = mismatchedDataFromServer ? (connectionData != null ? connectionData.getModData().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (String)((Pair)e.getValue()).getRight())) : Map.of()) : ModList.get().getMods().stream().map(info -> Pair.of((Object)info.getModId(), (Object)info.getVersion().toString())).collect(Collectors.toMap(Pair::getLeft, Pair::getRight));
            return mismatchedChannels.keySet().stream().map(channel -> Pair.of((Object)channel, (Object)(((String)mismatchedChannels.get(channel)).equals(NetworkRegistry.ABSENT.version()) ? NetworkRegistry.ABSENT.version() : mismatchedModVersions.getOrDefault(channel.method_12836(), NetworkRegistry.ABSENT.version())))).collect(Collectors.toMap(Pair::getLeft, Pair::getRight));
        }

        private static Map<class_2960, Pair<String, String>> getPresentChannelData(Set<class_2960> mismatchedChannelsFilter, ConnectionData connectionData, boolean mismatchedDataFromServer) {
            Object channelData = mismatchedDataFromServer ? NetworkRegistry.buildChannelVersions() : (connectionData != null ? connectionData.getChannels() : Map.of());
            return channelData.keySet().stream().filter(mismatchedChannelsFilter::contains).map(id -> ModMismatchData.getPresentModDataFromChannel(id, connectionData, mismatchedDataFromServer)).collect(Collectors.toMap(Pair::getLeft, Pair::getRight));
        }

        private static Pair<class_2960, Pair<String, String>> getPresentModDataFromChannel(class_2960 channel, ConnectionData connectionData, boolean mismatchedDataFromServer) {
            if (mismatchedDataFromServer) {
                return ModList.get().getModContainerById(channel.method_12836()).map(modContainer -> Pair.of((Object)channel, (Object)Pair.of((Object)modContainer.getModInfo().getDisplayName(), (Object)modContainer.getModInfo().getVersion().toString()))).orElse(Pair.of((Object)channel, (Object)Pair.of((Object)channel.method_12836(), (Object)"")));
            }
            Map modData = connectionData != null ? connectionData.getModData() : Map.of();
            Pair modDataFromChannel = modData.getOrDefault(channel.method_12836(), Pair.of((Object)channel.method_12836(), (Object)""));
            return Pair.of((Object)channel, (Object)(((String)modDataFromChannel.getLeft()).isEmpty() ? Pair.of((Object)channel.method_12836(), (Object)((String)modDataFromChannel.getRight())) : modDataFromChannel));
        }

        private static Map<class_2960, Pair<String, String>> getServerSidePresentModData(Set<class_2960> mismatchedModsFilter, ConnectionData connectionData) {
            Map serverModData = connectionData != null ? connectionData.getModData() : Map.of();
            Set modIdFilter = mismatchedModsFilter.stream().map(class_2960::method_12836).collect(Collectors.toSet());
            return serverModData.entrySet().stream().filter(e -> modIdFilter.contains(e.getKey())).collect(Collectors.toMap(e -> new class_2960((String)e.getKey(), ""), Map.Entry::getValue));
        }
    }
}

