/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.network;

import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.class_1255;
import net.minecraft.class_2535;
import net.minecraft.class_2540;
import net.minecraft.class_2547;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_3738;
import net.minecraftforge.common.util.LogicalSidedProvider;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.ICustomPacket;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkRegistry;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class NetworkEvent
extends Event {
    private final class_2540 payload;
    private final Supplier<Context> source;
    private final int loginIndex;

    public NetworkEvent() {
        this.payload = null;
        this.source = null;
        this.loginIndex = -1;
    }

    private NetworkEvent(ICustomPacket<?> payload, Supplier<Context> source) {
        this.payload = payload.getInternalData();
        this.source = source;
        this.loginIndex = payload.getIndex();
    }

    private NetworkEvent(class_2540 payload, Supplier<Context> source, int loginIndex) {
        this.payload = payload;
        this.source = source;
        this.loginIndex = loginIndex;
    }

    public NetworkEvent(Supplier<Context> source) {
        this.source = source;
        this.payload = null;
        this.loginIndex = -1;
    }

    public class_2540 getPayload() {
        return this.payload;
    }

    public Supplier<Context> getSource() {
        return this.source;
    }

    public int getLoginIndex() {
        return this.loginIndex;
    }

    public static class PacketDispatcher {
        BiConsumer<class_2960, class_2540> packetSink;

        PacketDispatcher(BiConsumer<class_2960, class_2540> packetSink) {
            this.packetSink = packetSink;
        }

        private PacketDispatcher() {
        }

        public void sendPacket(class_2960 resourceLocation, class_2540 buffer) {
            this.packetSink.accept(resourceLocation, buffer);
        }

        static class NetworkManagerDispatcher
        extends PacketDispatcher {
            private final class_2535 manager;
            private final int packetIndex;
            private final BiFunction<Pair<class_2540, Integer>, class_2960, ICustomPacket<?>> customPacketSupplier;

            NetworkManagerDispatcher(class_2535 manager, int packetIndex, BiFunction<Pair<class_2540, Integer>, class_2960, ICustomPacket<?>> customPacketSupplier) {
                this.packetSink = this::dispatchPacket;
                this.manager = manager;
                this.packetIndex = packetIndex;
                this.customPacketSupplier = customPacketSupplier;
            }

            private void dispatchPacket(class_2960 resourceLocation, class_2540 buffer) {
                ICustomPacket<?> packet = this.customPacketSupplier.apply((Pair<class_2540, Integer>)Pair.of((Object)buffer, (Object)this.packetIndex), resourceLocation);
                this.manager.method_10743(packet.getThis());
            }
        }
    }

    public static class Context {
        private final class_2535 networkManager;
        private final NetworkDirection networkDirection;
        private final PacketDispatcher packetDispatcher;
        private boolean packetHandled;

        Context(class_2535 netHandler, NetworkDirection networkDirection, int index) {
            this(netHandler, networkDirection, new PacketDispatcher.NetworkManagerDispatcher(netHandler, index, networkDirection.reply()::buildPacket));
        }

        Context(class_2535 networkManager, NetworkDirection networkDirection, BiConsumer<class_2960, class_2540> packetSink) {
            this(networkManager, networkDirection, new PacketDispatcher(packetSink));
        }

        Context(class_2535 networkManager, NetworkDirection networkDirection, PacketDispatcher dispatcher) {
            this.networkManager = networkManager;
            this.networkDirection = networkDirection;
            this.packetDispatcher = dispatcher;
        }

        public NetworkDirection getDirection() {
            return this.networkDirection;
        }

        public PacketDispatcher getPacketDispatcher() {
            return this.packetDispatcher;
        }

        public <T> Attribute<T> attr(AttributeKey<T> key) {
            return this.networkManager.channel().attr(key);
        }

        public void setPacketHandled(boolean packetHandled) {
            this.packetHandled = packetHandled;
        }

        public boolean getPacketHandled() {
            return this.packetHandled;
        }

        public CompletableFuture<Void> enqueueWork(Runnable runnable) {
            class_1255<? super class_3738> executor = LogicalSidedProvider.WORKQUEUE.get(this.getDirection().getReceptionSide());
            if (!executor.method_18854()) {
                return executor.method_5382(runnable);
            }
            runnable.run();
            return CompletableFuture.completedFuture(null);
        }

        @Nullable
        public class_3222 getSender() {
            class_2547 netHandler = this.networkManager.method_10744();
            if (netHandler instanceof class_3244) {
                class_3244 netHandlerPlayServer = (class_3244)netHandler;
                return netHandlerPlayServer.field_14140;
            }
            return null;
        }

        public class_2535 getNetworkManager() {
            return this.networkManager;
        }
    }

    public static class ChannelRegistrationChangeEvent
    extends NetworkEvent {
        private final RegistrationChangeType changeType;

        ChannelRegistrationChangeEvent(Supplier<Context> source, RegistrationChangeType changeType) {
            super(source);
            this.changeType = changeType;
        }

        public RegistrationChangeType getRegistrationChangeType() {
            return this.changeType;
        }
    }

    public static enum RegistrationChangeType {
        REGISTER,
        UNREGISTER;

    }

    public static class LoginPayloadEvent
    extends NetworkEvent {
        public LoginPayloadEvent() {
        }

        LoginPayloadEvent(class_2540 payload, Supplier<Context> source, int loginIndex) {
            super(payload, source, loginIndex);
        }
    }

    public static class GatherLoginPayloadsEvent
    extends Event {
        private final List<NetworkRegistry.LoginPayload> collected;
        private final boolean isLocal;

        public GatherLoginPayloadsEvent(List<NetworkRegistry.LoginPayload> loginPayloadList, boolean isLocal) {
            this.collected = loginPayloadList;
            this.isLocal = isLocal;
        }

        public void add(class_2540 buffer, class_2960 channelName, String context) {
            this.collected.add(new NetworkRegistry.LoginPayload(buffer, channelName, context));
        }

        public void add(class_2540 buffer, class_2960 channelName, String context, boolean needsResponse) {
            this.collected.add(new NetworkRegistry.LoginPayload(buffer, channelName, context, needsResponse));
        }

        public boolean isLocal() {
            return this.isLocal;
        }
    }

    public static class ClientCustomPayloadLoginEvent
    extends ClientCustomPayloadEvent {
        public ClientCustomPayloadLoginEvent() {
        }

        ClientCustomPayloadLoginEvent(ICustomPacket<?> payload, Supplier<Context> source) {
            super(payload, source);
        }
    }

    public static class ServerCustomPayloadLoginEvent
    extends ServerCustomPayloadEvent {
        public ServerCustomPayloadLoginEvent() {
        }

        ServerCustomPayloadLoginEvent(ICustomPacket<?> payload, Supplier<Context> source) {
            super(payload, source);
        }
    }

    public static class ClientCustomPayloadEvent
    extends NetworkEvent {
        public ClientCustomPayloadEvent() {
        }

        ClientCustomPayloadEvent(ICustomPacket<?> payload, Supplier<Context> source) {
            super(payload, source);
        }
    }

    public static class ServerCustomPayloadEvent
    extends NetworkEvent {
        public ServerCustomPayloadEvent() {
        }

        ServerCustomPayloadEvent(ICustomPacket<?> payload, Supplier<Context> source) {
            super(payload, source);
        }
    }
}

