/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.network.filters;

import com.google.common.collect.ImmutableMap;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.tree.RootCommandNode;
import com.mojang.logging.LogUtils;
import io.netty.channel.ChannelHandler;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import net.minecraft.class_2170;
import net.minecraft.class_2314;
import net.minecraft.class_2316;
import net.minecraft.class_2535;
import net.minecraft.class_2596;
import net.minecraft.class_2641;
import net.minecraft.class_2781;
import net.minecraft.class_2790;
import net.minecraft.class_2960;
import net.minecraft.class_4526;
import net.minecraft.class_4530;
import net.minecraft.class_5321;
import net.minecraft.class_6864;
import net.minecraft.class_7157;
import net.minecraft.class_7225;
import net.minecraft.class_7887;
import net.minecraft.class_7923;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.filters.CommandTreeCleaner;
import net.minecraftforge.network.filters.VanillaPacketFilter;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryManager;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import xyz.bluspring.kilt.injections.data.registries.VanillaRegistriesInjection;

@ChannelHandler.Sharable
public class VanillaConnectionNetworkFilter
extends VanillaPacketFilter {
    private static final Logger LOGGER = LogUtils.getLogger();

    public VanillaConnectionNetworkFilter() {
        super((Map<Class<? extends class_2596<?>>, BiConsumer<class_2596<?>, List<? super class_2596<?>>>>)ImmutableMap.builder().put(VanillaConnectionNetworkFilter.handler(class_2781.class, VanillaConnectionNetworkFilter::filterEntityProperties)).put(VanillaConnectionNetworkFilter.handler(class_2641.class, VanillaConnectionNetworkFilter::filterCommandList)).put(VanillaConnectionNetworkFilter.handler(class_2790.class, VanillaConnectionNetworkFilter::filterCustomTagTypes)).build());
    }

    @Override
    protected boolean isNecessary(class_2535 manager) {
        return NetworkHooks.isVanillaConnection(manager);
    }

    @NotNull
    private static class_2781 filterEntityProperties(class_2781 msg) {
        class_2781 newPacket = new class_2781(msg.method_11937(), Collections.emptyList());
        msg.method_11938().stream().filter(snapshot -> {
            class_2960 key = ForgeRegistries.ATTRIBUTES.getKey(snapshot.method_11940());
            return key != null && key.method_12836().equals("minecraft");
        }).forEach(snapshot -> newPacket.method_11938().add(snapshot));
        return newPacket;
    }

    @NotNull
    private static class_2641 filterCommandList(class_2641 packet) {
        class_7157 commandBuildContext = class_2170.method_46732((class_7225.class_7874)class_7887.method_46817());
        RootCommandNode root = packet.method_11403(commandBuildContext);
        RootCommandNode newRoot = CommandTreeCleaner.cleanArgumentTypes(root, argType -> {
            if (argType instanceof class_4530 || argType instanceof class_4526) {
                return false;
            }
            class_2314 info = class_2316.method_41983((ArgumentType)argType);
            class_2960 id = class_7923.field_41192.method_10221((Object)info);
            return id != null && (id.method_12836().equals("minecraft") || id.method_12836().equals("brigadier"));
        });
        return new class_2641(newRoot);
    }

    private static class_2790 filterCustomTagTypes(class_2790 packet) {
        Map<class_5321, class_6864.class_5748> tags = packet.method_12000().entrySet().stream().filter(e -> VanillaConnectionNetworkFilter.isVanillaRegistry(((class_5321)e.getKey()).method_29177())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        return new class_2790(tags);
    }

    private static boolean isVanillaRegistry(class_2960 location) {
        return RegistryManager.getVanillaRegistryKeys().contains(location) || VanillaRegistriesInjection.DATAPACK_REGISTRY_KEYS.stream().anyMatch(k -> k.method_29177().equals((Object)location));
    }
}

