/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.network.filters;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_2535;
import net.minecraft.class_2539;
import net.minecraft.class_2540;
import net.minecraft.class_2547;
import net.minecraft.class_2596;
import net.minecraft.class_2598;
import net.minecraft.class_2658;
import net.minecraft.class_2960;
import net.minecraftforge.network.ConnectionData;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.event.EventNetworkChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VanillaPacketSplitter {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final class_2960 CHANNEL = new class_2960("forge", "split");
    private static final String VERSION = "1.1";
    private static final int PROTOCOL_MAX = 0x800000;
    private static final int PAYLOAD_TO_CLIENT_MAX = 0x100000;
    private static final int PART_SIZE = 1048570;
    private static final byte STATE_FIRST = 1;
    private static final byte STATE_LAST = 2;
    private static final List<class_2540> receivedBuffers = new ArrayList<class_2540>();

    public static void register() {
        Predicate<String> versionCheck = NetworkRegistry.acceptMissingOr(VERSION);
        EventNetworkChannel channel = NetworkRegistry.newEventChannel(CHANNEL, () -> VERSION, versionCheck, versionCheck);
        channel.addListener(VanillaPacketSplitter::onClientPacket);
    }

    public static void appendPackets(class_2539 protocol, class_2598 direction, class_2596<?> packet, List<? super class_2596<?>> out) {
        if (VanillaPacketSplitter.heuristicIsDefinitelySmallEnough(packet)) {
            out.add(packet);
        } else {
            class_2540 buf = new class_2540(Unpooled.buffer());
            packet.method_11052(buf);
            if (buf.readableBytes() <= 0x800000) {
                buf.release();
                out.add(packet);
            } else {
                int parts = (int)Math.ceil((double)buf.readableBytes() / 1048570.0);
                if (parts == 1) {
                    buf.release();
                    out.add(packet);
                } else {
                    for (int part = 0; part < parts; ++part) {
                        ByteBuf partPrefix;
                        if (part == 0) {
                            partPrefix = Unpooled.buffer((int)5);
                            partPrefix.writeByte(1);
                            new class_2540(partPrefix).method_10804(protocol.method_10781(direction, packet));
                        } else {
                            partPrefix = Unpooled.buffer((int)1);
                            partPrefix.writeByte(part == parts - 1 ? 2 : 0);
                        }
                        int partSize = Math.min(1048570, buf.readableBytes());
                        ByteBuf partBuf = Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{partPrefix, buf.retainedSlice(buf.readerIndex(), partSize)});
                        buf.skipBytes(partSize);
                        out.add((class_2596<?>)new class_2658(CHANNEL, new class_2540(partBuf)));
                    }
                    buf.release();
                }
            }
        }
    }

    private static boolean heuristicIsDefinitelySmallEnough(class_2596<?> packet) {
        return false;
    }

    private static void onClientPacket(NetworkEvent.ServerCustomPayloadEvent event) {
        NetworkEvent.Context ctx = event.getSource().get();
        class_2598 direction = ctx.getDirection() == NetworkDirection.PLAY_TO_CLIENT ? class_2598.field_11942 : class_2598.field_11941;
        class_2539 protocol = class_2539.field_20591;
        ctx.setPacketHandled(true);
        class_2540 buf = event.getPayload();
        byte state = buf.readByte();
        if (state == 1 && !receivedBuffers.isEmpty()) {
            LOGGER.warn("forge:split received out of order - inbound buffer not empty when receiving first");
            receivedBuffers.clear();
        }
        buf.retain();
        receivedBuffers.add(buf);
        if (state == 2) {
            class_2540 full = new class_2540(Unpooled.wrappedBuffer((ByteBuf[])((ByteBuf[])receivedBuffers.toArray(new class_2540[0]))));
            int packetId = full.method_10816();
            class_2596 packet = protocol.method_10783(direction, packetId, full);
            if (packet == null) {
                LOGGER.error("Received invalid packet ID {} in forge:split", (Object)packetId);
            } else {
                receivedBuffers.clear();
                full.release();
                ctx.enqueueWork(() -> VanillaPacketSplitter.genericsFtw(packet, event.getSource().get().getNetworkManager().method_10744()));
            }
        }
    }

    private static <T extends class_2547> void genericsFtw(class_2596<T> pkt, Object listener) {
        pkt.method_11054((class_2547)listener);
    }

    public static RemoteCompatibility getRemoteCompatibility(class_2535 manager) {
        ConnectionData connectionData = NetworkHooks.getConnectionData(manager);
        if (connectionData != null && connectionData.getChannels().containsKey((Object)CHANNEL)) {
            return RemoteCompatibility.PRESENT;
        }
        return RemoteCompatibility.ABSENT;
    }

    public static boolean isRemoteCompatible(class_2535 manager) {
        return VanillaPacketSplitter.getRemoteCompatibility(manager) != RemoteCompatibility.ABSENT;
    }

    public static enum RemoteCompatibility {
        ABSENT,
        PRESENT;

    }
}

