/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.registries;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import io.github.fabricators_of_create.porting_lib.registries.mixin.NetworkedRegistryDataAccessor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.event.registry.DynamicRegistries;
import net.minecraft.class_2378;
import net.minecraft.class_5321;
import net.minecraft.class_7655;
import net.minecraft.class_7782;
import net.minecraftforge.registries.DataPackRegistryEvent;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class DataPackRegistriesHooks {
    private static final Map<class_5321<? extends class_2378<?>>, class_7782.class_7783<?>> NETWORKABLE_REGISTRIES = new LinkedHashMap();
    private static final List<class_7655.class_7657<?>> DATA_PACK_REGISTRIES = new ArrayList(class_7655.field_39968);
    private static final List<class_7655.class_7657<?>> DATA_PACK_REGISTRIES_VIEW = Collections.unmodifiableList(DATA_PACK_REGISTRIES);
    private static final Set<class_5321<? extends class_2378<?>>> SYNCED_CUSTOM_REGISTRIES = new HashSet();
    private static final Set<class_5321<? extends class_2378<?>>> SYNCED_CUSTOM_REGISTRIES_VIEW = Collections.unmodifiableSet(SYNCED_CUSTOM_REGISTRIES);

    private DataPackRegistriesHooks() {
    }

    public static Map<class_5321<? extends class_2378<?>>, class_7782.class_7783<?>> grabNetworkableRegistries(ImmutableMap.Builder<class_5321<? extends class_2378<?>>, class_7782.class_7783<?>> builder) {
        if (!StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE).getCallerClass().equals(class_7782.class)) {
            throw new IllegalCallerException("Attempted to call DataPackRegistriesHooks#grabNetworkableRegistries!");
        }
        NETWORKABLE_REGISTRIES.forEach((arg_0, arg_1) -> builder.put(arg_0, arg_1));
        NETWORKABLE_REGISTRIES.clear();
        NETWORKABLE_REGISTRIES.putAll((Map<class_5321<class_2378<?>>, class_7782.class_7783<?>>)builder.build());
        return ImmutableMap.ofEntries((Map.Entry[])((Map.Entry[])NETWORKABLE_REGISTRIES.entrySet().toArray(Map.Entry[]::new)));
    }

    static <T> void addRegistryCodec(DataPackRegistryEvent.DataPackRegistryData<T> data) {
        class_7655.class_7657<T> loaderData = data.loaderData();
        DATA_PACK_REGISTRIES.add(loaderData);
        Codec dataCodec = loaderData.comp_986();
        if (data.networkCodec() != null) {
            class_7782.class_7783 networked = NetworkedRegistryDataAccessor.createNetworkedRegistryData((class_5321)loaderData.comp_985(), data.networkCodec());
            SYNCED_CUSTOM_REGISTRIES.add(loaderData.comp_985());
            NETWORKABLE_REGISTRIES.put(loaderData.comp_985(), NetworkedRegistryDataAccessor.createNetworkedRegistryData((class_5321)loaderData.comp_985(), data.networkCodec()));
            DynamicRegistries.registerSynced((class_5321)loaderData.comp_985(), (Codec)dataCodec, (Codec)networked.comp_1067(), (DynamicRegistries.SyncOption[])new DynamicRegistries.SyncOption[0]);
        } else {
            DynamicRegistries.register((class_5321)loaderData.comp_985(), (Codec)dataCodec);
        }
    }

    public static List<class_7655.class_7657<?>> getDataPackRegistries() {
        return DATA_PACK_REGISTRIES_VIEW;
    }

    public static Stream<class_7655.class_7657<?>> getDataPackRegistriesWithDimensions() {
        return Stream.concat(DATA_PACK_REGISTRIES_VIEW.stream(), class_7655.field_39969.stream());
    }

    public static Set<class_5321<? extends class_2378<?>>> getSyncedCustomRegistries() {
        return SYNCED_CUSTOM_REGISTRIES_VIEW;
    }
}

