/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.registries;

import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.NewRegistryEvent;
import net.minecraftforge.registries.RegisterEvent;
import net.minecraftforge.registries.RegistryBuilder;
import net.minecraftforge.registries.RegistryManager;
import net.minecraftforge.registries.RegistryObject;
import net.minecraftforge.registries.tags.ITagManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeferredRegister<T> {
    private final class_5321<? extends class_2378<T>> registryKey;
    private final String modid;
    private final boolean optionalRegistry;
    private final Map<RegistryObject<T>, Supplier<? extends T>> entries = new LinkedHashMap<RegistryObject<T>, Supplier<? extends T>>();
    private final Set<RegistryObject<T>> entriesView = Collections.unmodifiableSet(this.entries.keySet());
    @Nullable
    private Supplier<RegistryBuilder<?>> registryFactory;
    @Nullable
    private SetMultimap<class_6862<T>, Supplier<T>> optionalTags;
    private boolean seenRegisterEvent = false;

    public static <B> DeferredRegister<B> create(IForgeRegistry<B> reg, String modid) {
        return new DeferredRegister<B>(reg, modid);
    }

    public static <B> DeferredRegister<B> create(class_5321<? extends class_2378<B>> key, String modid) {
        return new DeferredRegister(key, modid, false);
    }

    public static <B> DeferredRegister<B> createOptional(class_5321<? extends class_2378<B>> key, String modid) {
        return new DeferredRegister(key, modid, true);
    }

    public static <B> DeferredRegister<B> create(class_2960 registryName, String modid) {
        return new DeferredRegister(class_5321.method_29180((class_2960)registryName), modid, false);
    }

    public static <B> DeferredRegister<B> createOptional(class_2960 registryName, String modid) {
        return new DeferredRegister(class_5321.method_29180((class_2960)registryName), modid, true);
    }

    private DeferredRegister(class_5321<? extends class_2378<T>> registryKey, String modid, boolean optionalRegistry) {
        this.registryKey = registryKey;
        this.modid = modid;
        this.optionalRegistry = optionalRegistry;
    }

    private DeferredRegister(IForgeRegistry<T> reg, String modid) {
        this(reg.getRegistryKey(), modid, false);
    }

    public <I extends T> RegistryObject<I> register(String name, Supplier<? extends I> sup) {
        if (this.seenRegisterEvent) {
            throw new IllegalStateException("Cannot register new entries to DeferredRegister after RegisterEvent has been fired.");
        }
        Objects.requireNonNull(name);
        Objects.requireNonNull(sup);
        class_2960 key = new class_2960(this.modid, name);
        if (this.registryKey == null) {
            throw new IllegalStateException("Could not create RegistryObject in DeferredRegister");
        }
        RegistryObject ret = this.optionalRegistry ? RegistryObject.createOptional(key, this.registryKey, this.modid) : RegistryObject.create(key, this.registryKey, this.modid);
        if (this.entries.putIfAbsent(ret, sup) != null) {
            throw new IllegalArgumentException("Duplicate registration " + name);
        }
        return ret;
    }

    public <I extends T> RegistryObject<I> kilt$getValue(String name) {
        if (this.seenRegisterEvent) {
            throw new IllegalStateException("Cannot register new entries to DeferredRegister after RegisterEvent has been fired.");
        }
        Objects.requireNonNull(name);
        class_2960 key = new class_2960(this.modid, name);
        return RegistryObject.create(key, this.registryKey, this.modid);
    }

    public Supplier<IForgeRegistry<T>> makeRegistry(Supplier<RegistryBuilder<T>> sup) {
        return this.makeRegistry(this.registryKey.method_29177(), sup);
    }

    @NotNull
    public class_6862<T> createTagKey(@NotNull String path) {
        Objects.requireNonNull(path);
        return this.createTagKey(new class_2960(this.modid, path));
    }

    @NotNull
    public class_6862<T> createTagKey(@NotNull class_2960 location) {
        if (this.registryKey == null) {
            throw new IllegalStateException("The registry name was not set, cannot create a tag key");
        }
        Objects.requireNonNull(location);
        return class_6862.method_40092(this.registryKey, (class_2960)location);
    }

    @NotNull
    public class_6862<T> createOptionalTagKey(@NotNull String path, @NotNull Set<? extends Supplier<T>> defaults) {
        Objects.requireNonNull(path);
        return this.createOptionalTagKey(new class_2960(this.modid, path), defaults);
    }

    @NotNull
    public class_6862<T> createOptionalTagKey(@NotNull class_2960 location, @NotNull Set<? extends Supplier<T>> defaults) {
        class_6862<T> tagKey = this.createTagKey(location);
        this.addOptionalTagDefaults(tagKey, defaults);
        return tagKey;
    }

    public void addOptionalTagDefaults(@NotNull class_6862<T> name, @NotNull Set<? extends Supplier<T>> defaults) {
        Objects.requireNonNull(defaults);
        if (this.optionalTags == null) {
            this.optionalTags = Multimaps.newSetMultimap(new IdentityHashMap(), HashSet::new);
        }
        this.optionalTags.putAll(name, defaults);
    }

    public void register(IEventBus bus) {
        bus.register((Object)new EventDispatcher(this));
        if (this.registryFactory != null) {
            bus.addListener(this::createRegistry);
        }
    }

    public Collection<RegistryObject<T>> getEntries() {
        return this.entriesView;
    }

    public class_5321<? extends class_2378<T>> getRegistryKey() {
        return this.registryKey;
    }

    @NotNull
    public class_2960 getRegistryName() {
        return Objects.requireNonNull(this.registryKey).method_29177();
    }

    private Supplier<IForgeRegistry<T>> makeRegistry(class_2960 registryName, Supplier<RegistryBuilder<T>> sup) {
        if (registryName == null) {
            throw new IllegalStateException("Cannot create a registry without specifying a registry name");
        }
        if (RegistryManager.ACTIVE.getRegistry(registryName) != null || this.registryFactory != null) {
            throw new IllegalStateException("Cannot create a registry for a type that already exists");
        }
        this.registryFactory = () -> ((RegistryBuilder)sup.get()).setName(registryName);
        return new RegistryHolder(this.registryKey);
    }

    private void onFill(IForgeRegistry<?> registry) {
        if (this.optionalTags == null) {
            return;
        }
        ITagManager<?> tagManager = registry.tags();
        if (tagManager == null) {
            throw new IllegalStateException("The forge registry " + String.valueOf(registry.getRegistryName()) + " does not support tags, but optional tags were registered!");
        }
        Multimaps.asMap(this.optionalTags).forEach(tagManager::addOptionalTagDefaults);
    }

    private void addEntries(RegisterEvent event) {
        if (event.getRegistryKey().equals(this.registryKey)) {
            this.seenRegisterEvent = true;
            for (Map.Entry e : this.entries.entrySet()) {
                event.register(this.registryKey, e.getKey().getId(), () -> ((Supplier)e.getValue()).get());
                e.getKey().updateReference(event);
            }
        }
    }

    private void createRegistry(NewRegistryEvent event) {
        event.create(this.registryFactory.get(), this::onFill);
    }

    public static class EventDispatcher {
        private final DeferredRegister<?> register;

        public EventDispatcher(DeferredRegister<?> register) {
            this.register = register;
        }

        @SubscribeEvent
        public void handleEvent(RegisterEvent event) {
            this.register.addEntries(event);
        }
    }

    private static class RegistryHolder<V>
    implements Supplier<IForgeRegistry<V>> {
        private final class_5321<? extends class_2378<V>> registryKey;
        private IForgeRegistry<V> registry = null;

        private RegistryHolder(class_5321<? extends class_2378<V>> registryKey) {
            this.registryKey = registryKey;
        }

        @Override
        public IForgeRegistry<V> get() {
            if (this.registry == null) {
                this.registry = RegistryManager.ACTIVE.getRegistry(this.registryKey);
            }
            return this.registry;
        }
    }
}

