/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.registries;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Lifecycle;
import io.github.fabricators_of_create.porting_lib.extensions.extensions.ResourceLocationExtensions;
import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import net.minecraft.class_1299;
import net.minecraft.class_1320;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2361;
import net.minecraft.class_2370;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2941;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_4158;
import net.minecraft.class_5135;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_811;
import net.minecraftforge.common.CreativeModeTabRegistry;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.util.LogMessageAdapter;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.StructureModifier;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fml.ModLoader;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.StartupMessageManager;
import net.minecraftforge.fml.util.EnhancedRuntimeException;
import net.minecraftforge.fml.util.thread.EffectiveSide;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryInternal;
import net.minecraftforge.registries.ILockableRegistry;
import net.minecraftforge.registries.IdMappingEvent;
import net.minecraftforge.registries.MissingMappingsEvent;
import net.minecraftforge.registries.NamespacedDefaultedWrapper;
import net.minecraftforge.registries.NamespacedWrapper;
import net.minecraftforge.registries.ObjectHolderRegistry;
import net.minecraftforge.registries.RegisterEvent;
import net.minecraftforge.registries.RegistryBuilder;
import net.minecraftforge.registries.RegistryManager;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import xyz.bluspring.kilt.injections.core.MappedRegistryInjection;
import xyz.bluspring.kilt.injections.entity.SpawnPlacementsInjection;
import xyz.bluspring.kilt.injections.world.item.ItemDisplayContextInjection;
import xyz.bluspring.kilt.injections.world.level.levelgen.DebugLevelSourceInjection;

@ApiStatus.Internal
public class GameData {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Marker REGISTRIES = ForgeRegistry.REGISTRIES;
    private static final int MAX_VARINT = 0x7FFFFFFE;
    private static final class_2960 BLOCK_TO_ITEM = new class_2960("minecraft:blocktoitemmap");
    private static final class_2960 BLOCKSTATE_TO_ID = new class_2960("minecraft:blockstatetoid");
    private static final class_2960 BLOCKSTATE_TO_POINT_OF_INTEREST_TYPE = new class_2960("minecraft:blockstatetopointofinteresttype");
    private static boolean hasInit = false;
    private static final boolean DISABLE_VANILLA_REGISTRIES = Boolean.parseBoolean(System.getProperty("forge.disableVanillaGameData", "false"));
    private static final BiConsumer<class_2960, ForgeRegistry<?>> LOCK_VANILLA = (name, reg) -> reg.slaves.values().stream().filter(o -> o instanceof ILockableRegistry).forEach(o -> ((ILockableRegistry)o).lock());

    public static void init() {
        if (DISABLE_VANILLA_REGISTRIES) {
            LOGGER.warn(REGISTRIES, "DISABLING VANILLA REGISTRY CREATION AS PER SYSTEM VARIABLE SETTING! forge.disableVanillaGameData");
            return;
        }
        if (hasInit) {
            return;
        }
        hasInit = true;
        GameData.makeRegistry(ForgeRegistries.Keys.BLOCKS, "air").addCallback(BlockCallbacks.INSTANCE).legacyName("blocks").intrusiveHolderCallback(class_2248::method_40142).create();
        GameData.makeRegistry(ForgeRegistries.Keys.FLUIDS, "empty").intrusiveHolderCallback(class_3611::method_40178).create();
        GameData.makeRegistry(ForgeRegistries.Keys.ITEMS, "air").addCallback(ItemCallbacks.INSTANCE).legacyName("items").intrusiveHolderCallback(class_1792::method_40131).create();
        GameData.makeRegistry(ForgeRegistries.Keys.MOB_EFFECTS).legacyName("potions").create();
        GameData.makeRegistry(ForgeRegistries.Keys.SOUND_EVENTS).legacyName("soundevents").create();
        GameData.makeRegistry(ForgeRegistries.Keys.POTIONS, "empty").legacyName("potiontypes").create();
        GameData.makeRegistry(ForgeRegistries.Keys.ENCHANTMENTS).legacyName("enchantments").create();
        GameData.makeRegistry(ForgeRegistries.Keys.ENTITY_TYPES, "pig").legacyName("entities").intrusiveHolderCallback(class_1299::method_40124).create();
        GameData.makeRegistry(ForgeRegistries.Keys.BLOCK_ENTITY_TYPES).disableSaving().legacyName("blockentities").create();
        GameData.makeRegistry(ForgeRegistries.Keys.PARTICLE_TYPES).disableSaving().create();
        GameData.makeRegistry(ForgeRegistries.Keys.MENU_TYPES).disableSaving().create();
        GameData.makeRegistry(ForgeRegistries.Keys.PAINTING_VARIANTS, "kebab").create();
        GameData.makeRegistry(ForgeRegistries.Keys.RECIPE_TYPES).disableSaving().disableSync().create();
        GameData.makeRegistry(ForgeRegistries.Keys.RECIPE_SERIALIZERS).disableSaving().create();
        GameData.makeRegistry(ForgeRegistries.Keys.ATTRIBUTES).onValidate(AttributeCallbacks.INSTANCE).disableSaving().disableSync().create();
        GameData.makeRegistry(ForgeRegistries.Keys.STAT_TYPES).create();
        GameData.makeRegistry(ForgeRegistries.Keys.COMMAND_ARGUMENT_TYPES).disableSaving().create();
        GameData.makeRegistry(ForgeRegistries.Keys.VILLAGER_PROFESSIONS, "none").create();
        GameData.makeRegistry(ForgeRegistries.Keys.POI_TYPES).addCallback(PointOfInterestTypeCallbacks.INSTANCE).disableSync().create();
        GameData.makeRegistry(ForgeRegistries.Keys.MEMORY_MODULE_TYPES, "dummy").disableSync().create();
        GameData.makeRegistry(ForgeRegistries.Keys.SENSOR_TYPES, "dummy").disableSaving().disableSync().create();
        GameData.makeRegistry(ForgeRegistries.Keys.SCHEDULES).disableSaving().disableSync().create();
        GameData.makeRegistry(ForgeRegistries.Keys.ACTIVITIES).disableSaving().disableSync().create();
        GameData.makeRegistry(ForgeRegistries.Keys.WORLD_CARVERS).disableSaving().disableSync().create();
        GameData.makeRegistry(ForgeRegistries.Keys.FEATURES).disableSaving().disableSync().create();
        GameData.makeRegistry(ForgeRegistries.Keys.CHUNK_STATUS, "empty").disableSaving().disableSync().create();
        GameData.makeRegistry(ForgeRegistries.Keys.BLOCK_STATE_PROVIDER_TYPES).disableSaving().disableSync().create();
        GameData.makeRegistry(ForgeRegistries.Keys.FOLIAGE_PLACER_TYPES).disableSaving().disableSync().create();
        GameData.makeRegistry(ForgeRegistries.Keys.TREE_DECORATOR_TYPES).disableSaving().disableSync().create();
        GameData.makeRegistry(ForgeRegistries.Keys.BIOMES).disableSync().create();
    }

    static RegistryBuilder<class_2941<?>> getDataSerializersRegistryBuilder() {
        return GameData.makeRegistry(ForgeRegistries.Keys.ENTITY_DATA_SERIALIZERS, 256, 0x7FFFFFFE).disableSaving().disableOverrides();
    }

    static RegistryBuilder<Codec<? extends IGlobalLootModifier>> getGLMSerializersRegistryBuilder() {
        return GameData.makeRegistry(ForgeRegistries.Keys.GLOBAL_LOOT_MODIFIER_SERIALIZERS).disableSaving().disableSync();
    }

    static RegistryBuilder<Codec<? extends BiomeModifier>> getBiomeModifierSerializersRegistryBuilder() {
        return new RegistryBuilder().disableSaving().disableSync();
    }

    static RegistryBuilder<Codec<? extends StructureModifier>> getStructureModifierSerializersRegistryBuilder() {
        return new RegistryBuilder().disableSaving().disableSync();
    }

    static RegistryBuilder<FluidType> getFluidTypeRegistryBuilder() {
        return GameData.makeRegistry(ForgeRegistries.Keys.FLUID_TYPES).disableSaving();
    }

    static <T> RegistryBuilder<T> makeUnsavedAndUnsynced() {
        return RegistryBuilder.of().disableSaving().disableSync();
    }

    static RegistryBuilder<class_811> getItemDisplayContextRegistryBuilder() {
        return new RegistryBuilder().setMaxID(256).disableOverrides().disableSaving().setDefaultKey(new class_2960("minecraft:none")).onAdd(ItemDisplayContextInjection.ADD_CALLBACK);
    }

    private static <T> RegistryBuilder<T> makeRegistry(class_5321<? extends class_2378<T>> key) {
        return new RegistryBuilder().setName(key.method_29177()).setMaxID(0x7FFFFFFE).hasWrapper().kilt$markVanillaRegistry();
    }

    private static <T> RegistryBuilder<T> makeRegistry(class_5321<? extends class_2378<T>> key, int min, int max) {
        return new RegistryBuilder().setName(key.method_29177()).setIDRange(min, max).hasWrapper();
    }

    private static <T> RegistryBuilder<T> makeRegistry(class_5321<? extends class_2378<T>> key, String _default) {
        return new RegistryBuilder().setName(key.method_29177()).setMaxID(0x7FFFFFFE).hasWrapper().setDefaultKey(new class_2960(_default)).kilt$markVanillaRegistry();
    }

    public static <T> class_2370<T> getWrapper(class_5321<? extends class_2378<T>> key, Lifecycle lifecycle) {
        ForgeRegistry reg = RegistryManager.ACTIVE.getRegistry(key);
        if (reg == null) {
            return null;
        }
        class_2370 ret = reg.getSlaveMap(NamespacedWrapper.Factory.ID, NamespacedWrapper.class);
        Validate.notNull((Object)ret, (String)("Attempted to get vanilla wrapper for registry created incorrectly: " + key.toString()), (Object[])new Object[0]);
        return ret;
    }

    public static <T> class_2370<T> getWrapper(class_5321<? extends class_2378<T>> key, Lifecycle lifecycle, String defKey) {
        ForgeRegistry reg = RegistryManager.ACTIVE.getRegistry(key);
        if (reg == null) {
            return null;
        }
        class_2370 ret = reg.getSlaveMap(NamespacedDefaultedWrapper.Factory.ID, NamespacedDefaultedWrapper.class);
        Validate.notNull((Object)ret, (String)("Attempted to get vanilla wrapper for registry created incorrectly: " + key.toString()), (Object[])new Object[0]);
        return ret;
    }

    public static Map<class_2248, class_1792> getBlockItemMap() {
        return RegistryManager.ACTIVE.getRegistry(ForgeRegistries.Keys.ITEMS).getSlaveMap(BLOCK_TO_ITEM, Map.class);
    }

    public static class_2361<class_2680> getBlockStateIDMap() {
        return RegistryManager.ACTIVE.getRegistry(ForgeRegistries.Keys.BLOCKS).getSlaveMap(BLOCKSTATE_TO_ID, class_2361.class);
    }

    public static Map<class_2680, class_4158> getBlockStatePointOfInterestTypeMap() {
        return RegistryManager.ACTIVE.getRegistry(ForgeRegistries.Keys.POI_TYPES).getSlaveMap(BLOCKSTATE_TO_POINT_OF_INTEREST_TYPE, Map.class);
    }

    public static void vanillaSnapshot() {
        LOGGER.debug(REGISTRIES, "Creating vanilla freeze snapshot");
        for (Map.Entry r : RegistryManager.ACTIVE.registries.entrySet()) {
            GameData.loadRegistry((class_2960)r.getKey(), RegistryManager.ACTIVE, RegistryManager.VANILLA, true);
        }
        RegistryManager.VANILLA.registries.forEach((name, reg) -> {
            reg.validateContent((class_2960)name);
            reg.freeze();
        });
        RegistryManager.VANILLA.registries.forEach(LOCK_VANILLA);
        RegistryManager.ACTIVE.registries.forEach(LOCK_VANILLA);
        LOGGER.debug(REGISTRIES, "Vanilla freeze snapshot created");
    }

    public static void unfreezeData() {
        LOGGER.debug(REGISTRIES, "Unfreezing vanilla registries");
        class_7923.field_41167.method_10220().filter(r -> r instanceof class_2370).forEach(r -> ((MappedRegistryInjection)r).unfreeze());
    }

    public static void freezeData() {
        LOGGER.debug(REGISTRIES, "Freezing registries");
        class_7923.field_41167.method_10220().filter(r -> r instanceof class_2370).forEach(r -> ((class_2370)r).method_40276());
        for (Map.Entry r2 : RegistryManager.ACTIVE.registries.entrySet()) {
            GameData.loadRegistry((class_2960)r2.getKey(), RegistryManager.ACTIVE, RegistryManager.FROZEN, true);
        }
        RegistryManager.FROZEN.registries.forEach((name, reg) -> {
            reg.validateContent((class_2960)name);
            reg.freeze();
        });
        RegistryManager.ACTIVE.registries.forEach((name, reg) -> {
            reg.freeze();
            reg.bake();
            reg.dump((class_2960)name);
        });
        GameData.fireRemapEvent((Map<class_2960, Map<class_2960, IdMappingEvent.IdRemapping>>)ImmutableMap.of(), true);
        LOGGER.debug(REGISTRIES, "All registries frozen");
    }

    public static void revertToFrozen() {
        GameData.revertTo(RegistryManager.FROZEN, true);
    }

    public static void revertTo(RegistryManager target, boolean fireEvents) {
        if (target.registries.isEmpty()) {
            LOGGER.warn(REGISTRIES, "Can't revert to {} GameData state without a valid snapshot.", (Object)target.getName());
            return;
        }
        RegistryManager.ACTIVE.registries.forEach((name, reg) -> reg.resetDelegates());
        LOGGER.debug(REGISTRIES, "Reverting to {} data state.", (Object)target.getName());
        for (Map.Entry r : RegistryManager.ACTIVE.registries.entrySet()) {
            GameData.loadRegistry((class_2960)r.getKey(), target, RegistryManager.ACTIVE, true);
        }
        RegistryManager.ACTIVE.registries.forEach((name, reg) -> reg.bake());
        if (fireEvents) {
            GameData.fireRemapEvent((Map<class_2960, Map<class_2960, IdMappingEvent.IdRemapping>>)ImmutableMap.of(), true);
            ObjectHolderRegistry.applyObjectHolders();
        }
        LOGGER.debug(REGISTRIES, "{} state restored.", (Object)target.getName());
    }

    public static void revert(RegistryManager state, class_2960 registry, boolean lock) {
        LOGGER.debug(REGISTRIES, "Reverting {} to {}", (Object)registry, (Object)state.getName());
        GameData.loadRegistry(registry, state, RegistryManager.ACTIVE, lock);
        LOGGER.debug(REGISTRIES, "Reverting complete");
    }

    public static void postRegisterEvents() {
        HashSet<class_2960> keySet = new HashSet<class_2960>(RegistryManager.ACTIVE.registries.keySet());
        keySet.addAll(RegistryManager.getVanillaRegistryKeys());
        LinkedHashSet<class_2960> ordered = new LinkedHashSet<class_2960>(MappedRegistryInjection.getKnownRegistries());
        ordered.retainAll(keySet);
        ordered.addAll(keySet.stream().sorted(ResourceLocationExtensions::compareNamespaced).toList());
        RuntimeException aggregate = new RuntimeException();
        for (class_2960 rootRegistryName : ordered) {
            try {
                class_5321 registryKey = class_5321.method_29180((class_2960)rootRegistryName);
                ForgeRegistry forgeRegistry = RegistryManager.ACTIVE.getRegistry(rootRegistryName);
                class_2378 vanillaRegistry = (class_2378)class_7923.field_41167.method_10223(rootRegistryName);
                RegisterEvent registerEvent = new RegisterEvent(registryKey, forgeRegistry, vanillaRegistry);
                StartupMessageManager.modLoaderConsumer().ifPresent(s -> s.accept("REGISTERING " + String.valueOf(registryKey.method_29177())));
                if (forgeRegistry != null) {
                    forgeRegistry.unfreeze();
                }
                ModLoader.get().postEventWrapContainerInModOrder(registerEvent);
                if (forgeRegistry != null) {
                    forgeRegistry.freeze();
                }
                LOGGER.debug(REGISTRIES, "Applying holder lookups: {}", (Object)registryKey.method_29177());
                ObjectHolderRegistry.applyObjectHolders(arg_0 -> ((class_2960)registryKey.method_29177()).equals(arg_0));
                LOGGER.debug(REGISTRIES, "Holder lookups applied: {}", (Object)registryKey.method_29177());
            }
            catch (Throwable t) {
                aggregate.addSuppressed(t);
            }
        }
        if (aggregate.getSuppressed().length > 0) {
            LOGGER.fatal("Failed to register some entries, see suppressed exceptions for details", (Throwable)aggregate);
            LOGGER.fatal("Detected errors during registry event dispatch, rolling back to VANILLA state");
            GameData.revertTo(RegistryManager.VANILLA, false);
            LOGGER.fatal("Detected errors during registry event dispatch, roll back to VANILLA complete");
            throw aggregate;
        }
        ForgeHooks.modifyAttributes();
        SpawnPlacementsInjection.fireSpawnPlacementEvent();
        CreativeModeTabRegistry.sortTabs();
    }

    private static <T> void loadRegistry(final class_2960 registryName, final RegistryManager from, final RegistryManager to, boolean freeze) {
        ForgeRegistry fromRegistry = from.getRegistry(registryName);
        if (fromRegistry == null) {
            ForgeRegistry toRegistry = to.getRegistry(registryName);
            if (toRegistry == null) {
                throw new EnhancedRuntimeException("Could not find registry to load: " + String.valueOf(registryName)){
                    private static final long serialVersionUID = 1L;

                    @Override
                    protected void printStackTrace(EnhancedRuntimeException.WrappedPrintStream stream) {
                        stream.println("Looking For: " + String.valueOf(registryName));
                        stream.println("Found From:");
                        for (class_2960 name : from.registries.keySet()) {
                            stream.println("  " + String.valueOf(name));
                        }
                        stream.println("Found To:");
                        for (class_2960 name : to.registries.keySet()) {
                            stream.println("  " + String.valueOf(name));
                        }
                    }
                };
            }
        } else {
            ForgeRegistry toRegistry = to.getRegistry(registryName, from);
            toRegistry.sync(registryName, fromRegistry);
            if (freeze) {
                toRegistry.isFrozen = true;
            }
        }
    }

    public static Multimap<class_2960, class_2960> injectSnapshot(Map<class_2960, ForgeRegistry.Snapshot> snapshot, boolean injectFrozenData, boolean isLocalWorld) {
        class_2960[] missingRegs;
        LOGGER.info(REGISTRIES, "Injecting existing registry data into this {} instance", (Object)EffectiveSide.get());
        RegistryManager.ACTIVE.registries.forEach((name, reg) -> reg.validateContent((class_2960)name));
        RegistryManager.ACTIVE.registries.forEach((name, reg) -> reg.dump((class_2960)name));
        RegistryManager.ACTIVE.registries.forEach((name, reg) -> reg.resetDelegates());
        snapshot = snapshot.entrySet().stream().sorted(Map.Entry.comparingByKey()).collect(Collectors.toMap(e -> RegistryManager.ACTIVE.updateLegacyName((class_2960)e.getKey()), Map.Entry::getValue, (k1, k2) -> k1, LinkedHashMap::new));
        if (isLocalWorld && (missingRegs = (class_2960[])snapshot.keySet().stream().filter(name -> !RegistryManager.ACTIVE.registries.containsKey(name)).toArray(class_2960[]::new)).length > 0) {
            String header = "Forge Mod Loader detected missing/unknown registrie(s).\n\nThere are " + missingRegs.length + " missing registries in this save.\nIf you continue the missing registries will get removed.\nThis may cause issues, it is advised that you create a world backup before continuing.\n\n";
            StringBuilder text = new StringBuilder("Missing Registries:\n");
            for (class_2960 s : missingRegs) {
                text.append(s).append("\n");
            }
            LOGGER.warn(REGISTRIES, header);
            LOGGER.warn(REGISTRIES, text.toString());
        }
        RegistryManager STAGING = new RegistryManager();
        HashMap<class_2960, Map<class_2960, IdMappingEvent.IdRemapping>> remaps = new HashMap<class_2960, Map<class_2960, IdMappingEvent.IdRemapping>>();
        LinkedHashMap missing = new LinkedHashMap();
        snapshot.forEach((key, value) -> {
            remaps.put((class_2960)key, new LinkedHashMap());
            missing.put(key, new Object2IntLinkedOpenHashMap());
            GameData.loadPersistentDataToStagingRegistry(RegistryManager.ACTIVE, STAGING, (Map)remaps.get(key), (Object2IntMap<class_2960>)((Object2IntMap)missing.get(key)), key, value);
        });
        int count = missing.values().stream().mapToInt(Map::size).sum();
        if (count > 0) {
            LOGGER.debug(REGISTRIES, "There are {} mappings missing - attempting a mod remap", (Object)count);
            ArrayListMultimap defaulted = ArrayListMultimap.create();
            ArrayListMultimap failed = ArrayListMultimap.create();
            missing.entrySet().stream().filter(e -> !((Object2IntMap)e.getValue()).isEmpty()).forEach(arg_0 -> GameData.lambda$injectSnapshot$28(STAGING, (Multimap)failed, remaps, (Multimap)defaulted, isLocalWorld, arg_0));
            if (!defaulted.isEmpty() && !isLocalWorld) {
                return defaulted;
            }
            if (!defaulted.isEmpty()) {
                String header = "Forge Mod Loader detected missing registry entries.\n\nThere are " + defaulted.size() + " missing entries in this save.\nIf you continue the missing entries will get removed.\nA world backup will be automatically created in your saves directory.\n\n";
                StringBuilder buf = new StringBuilder();
                defaulted.asMap().forEach((name, entries) -> {
                    buf.append("Missing ").append(name).append(":\n");
                    entries.stream().sorted(ResourceLocationExtensions::compareNamespaced).forEach(rl -> buf.append("    ").append(rl).append("\n"));
                    buf.append("\n");
                });
                LOGGER.warn(REGISTRIES, header);
                LOGGER.warn(REGISTRIES, buf.toString());
            }
            if (!defaulted.isEmpty() && isLocalWorld) {
                LOGGER.error(REGISTRIES, "There are unidentified mappings in this world - we are going to attempt to process anyway");
            }
        }
        if (injectFrozenData) {
            RegistryManager.ACTIVE.registries.forEach((name, reg) -> GameData.loadFrozenDataToStagingRegistry(STAGING, name, (Map)remaps.get(name)));
        }
        STAGING.registries.forEach((name, reg) -> reg.validateContent((class_2960)name));
        RegistryManager.ACTIVE.registries.forEach((key, value) -> GameData.loadRegistry(key, STAGING, RegistryManager.ACTIVE, true));
        RegistryManager.ACTIVE.registries.forEach((name, reg) -> {
            reg.bake();
            reg.dump((class_2960)name);
        });
        GameData.fireRemapEvent(remaps, false);
        ObjectHolderRegistry.applyObjectHolders();
        return ArrayListMultimap.create();
    }

    private static void fireRemapEvent(Map<class_2960, Map<class_2960, IdMappingEvent.IdRemapping>> remaps, boolean isFreezing) {
        MinecraftForge.EVENT_BUS.post((Event)new IdMappingEvent(remaps, isFreezing));
    }

    private static <T> void loadPersistentDataToStagingRegistry(RegistryManager pool, RegistryManager to, Map<class_2960, IdMappingEvent.IdRemapping> remaps, Object2IntMap<class_2960> missing, class_2960 name, ForgeRegistry.Snapshot snap) {
        ForgeRegistry active = pool.getRegistry(name);
        if (active == null) {
            return;
        }
        ForgeRegistry _new = to.getRegistry(name, RegistryManager.ACTIVE);
        snap.aliases.forEach(_new::addAlias);
        snap.blocked.forEach(_new::block);
        _new.loadIds(snap.ids, snap.overrides, missing, remaps, active, name);
    }

    private static <T> void processMissing(class_2960 name, RegistryManager STAGING, MissingMappingsEvent e, Object2IntMap<class_2960> missing, Map<class_2960, IdMappingEvent.IdRemapping> remaps, Collection<class_2960> defaulted, Collection<class_2960> failed, boolean injectNetworkDummies) {
        List mappings = e.getAllMappings(class_5321.method_29180((class_2960)name));
        ForgeRegistry active = RegistryManager.ACTIVE.getRegistry(name);
        ForgeRegistry staging = STAGING.getRegistry(name);
        staging.processMissingEvent(name, active, mappings, missing, remaps, defaulted, failed, injectNetworkDummies);
    }

    private static <T> void loadFrozenDataToStagingRegistry(RegistryManager STAGING, class_2960 name, Map<class_2960, IdMappingEvent.IdRemapping> remaps) {
        ForgeRegistry frozen = RegistryManager.FROZEN.getRegistry(name);
        ForgeRegistry newRegistry = STAGING.getRegistry(name, RegistryManager.FROZEN);
        Object2IntLinkedOpenHashMap _new = new Object2IntLinkedOpenHashMap();
        frozen.getKeys().stream().filter(key -> !newRegistry.containsKey((class_2960)key)).forEach(arg_0 -> GameData.lambda$loadFrozenDataToStagingRegistry$36((Object2IntMap)_new, frozen, arg_0));
        newRegistry.loadIds((Object2IntMap<class_2960>)_new, frozen.getOverrideOwners(), (Object2IntMap<class_2960>)new Object2IntLinkedOpenHashMap(), remaps, frozen, name);
    }

    public static class_2960 checkPrefix(String name, boolean warnOverrides) {
        int index = name.lastIndexOf(58);
        String oldPrefix = index == -1 ? "" : name.substring(0, index).toLowerCase(Locale.ROOT);
        name = index == -1 ? name : name.substring(index + 1);
        String prefix = ModLoadingContext.get().getActiveNamespace();
        if (warnOverrides && !oldPrefix.equals(prefix) && !oldPrefix.isEmpty()) {
            LogManager.getLogger().debug("Mod `{}` attempting to register `{}` to the namespace `{}`. This could be intended, but likely means an EventBusSubscriber without a modid.", (Object)prefix, (Object)name, (Object)oldPrefix);
            prefix = oldPrefix;
        }
        return new class_2960(prefix, name);
    }

    private static /* synthetic */ void lambda$loadFrozenDataToStagingRegistry$36(Object2IntMap _new, ForgeRegistry frozen, class_2960 key) {
        _new.put((Object)key, frozen.getID(key));
    }

    private static /* synthetic */ void lambda$injectSnapshot$28(RegistryManager STAGING, Multimap failed, Map remaps, Multimap defaulted, boolean isLocalWorld, Map.Entry m) {
        class_2960 name = (class_2960)m.getKey();
        ForgeRegistry reg = STAGING.getRegistry(name);
        Object2IntMap missingIds = (Object2IntMap)m.getValue();
        MissingMappingsEvent event = reg.getMissingEvent(name, (Object2IntMap<class_2960>)missingIds);
        MinecraftForge.EVENT_BUS.post((Event)event);
        List lst = event.getAllMappings(reg.getRegistryKey()).stream().filter(e -> e.action == MissingMappingsEvent.Action.DEFAULT).sorted(Comparator.comparing(Object::toString)).collect(Collectors.toList());
        if (!lst.isEmpty()) {
            LOGGER.error(REGISTRIES, () -> LogMessageAdapter.adapt(sb -> {
                sb.append("Unidentified mapping from registry ").append(name).append('\n');
                lst.stream().sorted().forEach(map -> sb.append('\t').append(map.key).append(": ").append(map.id).append('\n'));
            }));
        }
        event.getAllMappings(reg.getRegistryKey()).stream().filter(e -> e.action == MissingMappingsEvent.Action.FAIL).forEach(fail -> failed.put((Object)name, (Object)fail.key));
        GameData.processMissing(name, STAGING, event, (Object2IntMap<class_2960>)missingIds, (Map)remaps.get(name), defaulted.get((Object)name), failed.get((Object)name), !isLocalWorld);
    }

    static {
        GameData.init();
    }

    private static class BlockCallbacks
    implements IForgeRegistry.AddCallback<class_2248>,
    IForgeRegistry.ClearCallback<class_2248>,
    IForgeRegistry.BakeCallback<class_2248>,
    IForgeRegistry.CreateCallback<class_2248> {
        static final BlockCallbacks INSTANCE = new BlockCallbacks();

        private BlockCallbacks() {
        }

        @Override
        public void onAdd(IForgeRegistryInternal<class_2248> owner, RegistryManager stage, int id, class_5321<class_2248> key, class_2248 block, @Nullable class_2248 oldBlock) {
            if (oldBlock != null) {
                class_2689 oldContainer = oldBlock.method_9595();
                class_2689 newContainer = block.method_9595();
                if (key.method_29177().method_12836().equals("minecraft") && !oldContainer.method_11659().equals(newContainer.method_11659())) {
                    String oldSequence = oldContainer.method_11659().stream().map(s -> String.format(Locale.ENGLISH, "%s={%s}", s.method_11899(), s.method_11898().stream().map(Object::toString).collect(Collectors.joining(",")))).collect(Collectors.joining(";"));
                    String newSequence = newContainer.method_11659().stream().map(s -> String.format(Locale.ENGLISH, "%s={%s}", s.method_11899(), s.method_11898().stream().map(Object::toString).collect(Collectors.joining(",")))).collect(Collectors.joining(";"));
                    LOGGER.error(REGISTRIES, () -> LogMessageAdapter.adapt(sb -> {
                        sb.append("Registry replacements for vanilla block '").append(key.method_29177()).append("' must not change the number or order of blockstates.\n");
                        sb.append("\tOld: ").append(oldSequence).append('\n');
                        sb.append("\tNew: ").append(newSequence);
                    }));
                    throw new RuntimeException("Invalid vanilla replacement. See log for details.");
                }
            }
        }

        @Override
        public void onClear(IForgeRegistryInternal<class_2248> owner, RegistryManager stage) {
            owner.getSlaveMap(BLOCKSTATE_TO_ID, ClearableObjectIntIdentityMap.class).clear();
        }

        @Override
        public void onCreate(IForgeRegistryInternal<class_2248> owner, RegistryManager stage) {
            ClearableObjectIntIdentityMap<class_2680> idMap = new ClearableObjectIntIdentityMap<class_2680>(){

                public int getId(class_2680 key) {
                    return this.field_11100.containsKey((Object)key) ? this.field_11100.getInt((Object)key) : -1;
                }
            };
            owner.setSlaveMap(BLOCKSTATE_TO_ID, idMap);
            owner.setSlaveMap(BLOCK_TO_ITEM, new HashMap());
        }

        @Override
        public void onBake(IForgeRegistryInternal<class_2248> owner, RegistryManager stage) {
            ClearableObjectIntIdentityMap blockstateMap = owner.getSlaveMap(BLOCKSTATE_TO_ID, ClearableObjectIntIdentityMap.class);
            for (class_2248 block : owner) {
                for (class_2680 state : block.method_9595().method_11662()) {
                    blockstateMap.method_10205(state);
                    state.method_26200();
                }
                block.method_26162();
            }
            DebugLevelSourceInjection.initValidStates();
        }
    }

    private static class ItemCallbacks
    implements IForgeRegistry.AddCallback<class_1792>,
    IForgeRegistry.ClearCallback<class_1792>,
    IForgeRegistry.CreateCallback<class_1792> {
        static final ItemCallbacks INSTANCE = new ItemCallbacks();

        private ItemCallbacks() {
        }

        @Override
        public void onAdd(IForgeRegistryInternal<class_1792> owner, RegistryManager stage, int id, class_5321<class_1792> key, class_1792 item, @Nullable class_1792 oldItem) {
            Map blockToItem;
            if (oldItem instanceof class_1747) {
                blockToItem = owner.getSlaveMap(BLOCK_TO_ITEM, Map.class);
                ((class_1747)oldItem).removeFromBlockToItemMap(blockToItem, item);
            }
            if (item instanceof class_1747) {
                blockToItem = owner.getSlaveMap(BLOCK_TO_ITEM, Map.class);
                ((class_1747)item).method_7713(blockToItem, item);
            }
        }

        @Override
        public void onClear(IForgeRegistryInternal<class_1792> owner, RegistryManager stage) {
            owner.getSlaveMap(BLOCK_TO_ITEM, Map.class).clear();
        }

        @Override
        public void onCreate(IForgeRegistryInternal<class_1792> owner, RegistryManager stage) {
            Map map = stage.getRegistry(ForgeRegistries.Keys.BLOCKS).getSlaveMap(BLOCK_TO_ITEM, Map.class);
            owner.setSlaveMap(BLOCK_TO_ITEM, map);
        }
    }

    private static class AttributeCallbacks
    implements IForgeRegistry.ValidateCallback<class_1320> {
        static final AttributeCallbacks INSTANCE = new AttributeCallbacks();

        private AttributeCallbacks() {
        }

        @Override
        public void onValidate(IForgeRegistryInternal<class_1320> owner, RegistryManager stage, int id, class_2960 key, class_1320 obj) {
            if (stage != RegistryManager.VANILLA) {
                class_5135.method_26872();
            }
        }
    }

    private static class PointOfInterestTypeCallbacks
    implements IForgeRegistry.AddCallback<class_4158>,
    IForgeRegistry.ClearCallback<class_4158>,
    IForgeRegistry.CreateCallback<class_4158> {
        static final PointOfInterestTypeCallbacks INSTANCE = new PointOfInterestTypeCallbacks();

        private PointOfInterestTypeCallbacks() {
        }

        @Override
        public void onAdd(IForgeRegistryInternal<class_4158> owner, RegistryManager stage, int id, class_5321<class_4158> key, class_4158 obj, @Nullable class_4158 oldObj) {
            Map map = owner.getSlaveMap(BLOCKSTATE_TO_POINT_OF_INTEREST_TYPE, Map.class);
            if (oldObj != null) {
                oldObj.comp_815().forEach(map::remove);
            }
            obj.comp_815().forEach(state -> {
                class_4158 oldType = map.put(state, obj);
                if (oldType != null) {
                    throw new IllegalStateException(String.format(Locale.ENGLISH, "Point of interest types %s and %s both list %s in their blockstates, this is not allowed. Blockstates can only have one point of interest type each.", oldType, obj, state));
                }
            });
        }

        @Override
        public void onClear(IForgeRegistryInternal<class_4158> owner, RegistryManager stage) {
            owner.getSlaveMap(BLOCKSTATE_TO_POINT_OF_INTEREST_TYPE, Map.class).clear();
        }

        @Override
        public void onCreate(IForgeRegistryInternal<class_4158> owner, RegistryManager stage) {
            owner.setSlaveMap(BLOCKSTATE_TO_POINT_OF_INTEREST_TYPE, new HashMap());
        }
    }

    private static class ClearableObjectIntIdentityMap<I>
    extends class_2361<I> {
        private ClearableObjectIntIdentityMap() {
        }

        void clear() {
            this.field_11100.clear();
            this.field_11098.clear();
            this.field_11099 = 0;
        }

        void remove(I key) {
            boolean hadId = this.field_11100.containsKey(key);
            int prev = this.field_11100.removeInt(key);
            if (hadId) {
                this.field_11098.set(prev, null);
            }
        }
    }
}

