/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.registries;

import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Lifecycle;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_156;
import net.minecraft.class_2370;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7871;
import net.minecraft.class_7876;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryInternal;
import net.minecraftforge.registries.ILockableRegistry;
import net.minecraftforge.registries.RegistryManager;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import xyz.bluspring.kilt.injections.core.MappedRegistryInjection;

class NamespacedWrapper<T>
extends class_2370<T>
implements ILockableRegistry,
MappedRegistryInjection {
    static final Logger LOGGER = LogUtils.getLogger();
    private final ForgeRegistry<T> delegate;
    @Nullable
    private final Function<T, class_6880.class_6883<T>> intrusiveHolderCallback;
    private final Multimap<class_6862<T>, Supplier<T>> optionalTags = Multimaps.newSetMultimap(new IdentityHashMap(), HashSet::new);
    boolean locked = false;
    Lifecycle registryLifecycle = Lifecycle.stable();
    private boolean frozen = false;
    private List<class_6880.class_6883<T>> holdersSorted;
    private ObjectList<class_6880.class_6883<T>> holdersById = new ObjectArrayList(256);
    private Map<class_2960, class_6880.class_6883<T>> holdersByName = new HashMap<class_2960, class_6880.class_6883<T>>();
    private Map<T, class_6880.class_6883<T>> holders = new IdentityHashMap<T, class_6880.class_6883<T>>();
    private RegistryManager stage;
    private volatile Map<class_6862<T>, class_6885.class_6888<T>> tags = new IdentityHashMap<class_6862<T>, class_6885.class_6888<T>>();

    NamespacedWrapper(ForgeRegistry<T> fowner, Function<T, class_6880.class_6883<T>> intrusiveHolderCallback, RegistryManager stage) {
        super(fowner.getRegistryKey(), Lifecycle.stable(), intrusiveHolderCallback != null);
        this.delegate = fowner;
        this.intrusiveHolderCallback = intrusiveHolderCallback;
        this.stage = stage;
    }

    public class_6880.class_6883<T> method_46744(int id, class_5321<T> key, T value, Lifecycle lifecycle) {
        Validate.notNull(value);
        this.markKnown();
        this.registryLifecycle = this.registryLifecycle.add(lifecycle);
        int realId = this.delegate.add(id, key.method_29177(), value);
        if (realId != id && id != -1) {
            LOGGER.warn("Registered object did not get ID it asked for. Name: {} Expected: {} Got: {}", new Object[]{key, id, realId});
        }
        return this.getHolder(key, value);
    }

    public class_6880.class_6883<T> method_10272(class_5321<T> key, T value, Lifecycle lifecycle) {
        return this.method_46744(-1, key, value, lifecycle);
    }

    @Nullable
    public T method_10223(@Nullable class_2960 name) {
        return this.delegate.getRaw(name);
    }

    public Optional<T> method_17966(@Nullable class_2960 name) {
        return Optional.ofNullable(this.delegate.getRaw(name));
    }

    @Nullable
    public T method_29107(@Nullable class_5321<T> name) {
        return name == null ? null : (T)this.delegate.getRaw(name.method_29177());
    }

    @Nullable
    public class_2960 method_10221(T value) {
        return this.delegate.getKey(value);
    }

    public Optional<class_5321<T>> method_29113(T p_122755_) {
        return this.delegate.getResourceKey(p_122755_);
    }

    public boolean method_10250(class_2960 key) {
        return this.delegate.containsKey(key);
    }

    public boolean method_35842(class_5321<T> key) {
        return this.delegate.getRegistryName().equals((Object)key.method_41185()) && this.method_10250(key.method_29177());
    }

    public int method_10206(@Nullable T value) {
        return this.delegate.getID(value);
    }

    @Nullable
    public T method_10200(int id) {
        return this.delegate.getValue(id);
    }

    public Lifecycle method_31139(T value) {
        return Lifecycle.stable();
    }

    public Lifecycle method_31138() {
        return this.registryLifecycle;
    }

    public Iterator<T> iterator() {
        return this.delegate.iterator();
    }

    public Set<class_2960> method_10235() {
        return this.delegate.getKeys();
    }

    public Set<class_5321<T>> method_42021() {
        return this.delegate.getResourceKeys();
    }

    public Set<Map.Entry<class_5321<T>, T>> method_29722() {
        return this.delegate.getEntries();
    }

    public boolean method_35863() {
        return this.delegate.isEmpty();
    }

    public int method_10204() {
        return this.delegate.size();
    }

    @Override
    @Deprecated
    public void lock() {
        this.locked = true;
    }

    public Optional<class_6880.class_6883<T>> method_40265(int id) {
        return id >= 0 && id < this.holdersById.size() ? Optional.ofNullable((class_6880.class_6883)this.holdersById.get(id)) : Optional.empty();
    }

    public Optional<class_6880.class_6883<T>> method_40264(class_5321<T> key) {
        return Optional.ofNullable(this.holdersByName.get(key.method_29177()));
    }

    @NotNull
    public class_6880<T> method_47983(@NotNull T value) {
        class_6880 holder = (class_6880)this.holders.get(value);
        return holder == null ? class_6880.method_40223(value) : holder;
    }

    Optional<class_6880<T>> getHolder(class_2960 location) {
        return Optional.ofNullable((class_6880)this.holdersByName.get(location));
    }

    Optional<class_6880<T>> getHolder(T value) {
        return Optional.ofNullable((class_6880)this.holders.get(value));
    }

    public class_7871<T> method_46769() {
        this.validateWrite();
        return new class_7871<T>(){

            public Optional<class_6880.class_6883<T>> method_46746(class_5321<T> p_259097_) {
                return Optional.of(this.method_46747(p_259097_));
            }

            public class_6880.class_6883<T> method_46747(class_5321<T> p_259750_) {
                return NamespacedWrapper.this.method_44298(p_259750_);
            }

            public Optional<class_6885.class_6888<T>> method_46733(class_6862<T> p_259486_) {
                return Optional.of(this.method_46735(p_259486_));
            }

            public class_6885.class_6888<T> method_46735(class_6862<T> p_260298_) {
                return NamespacedWrapper.this.method_40260(p_260298_);
            }
        };
    }

    void validateWrite() {
        if (this.frozen) {
            throw new IllegalStateException("Registry is already frozen");
        }
    }

    void validateWrite(class_5321<T> key) {
        if (this.frozen) {
            throw new IllegalStateException("Registry is already frozen (trying to add key " + String.valueOf(key) + ")");
        }
    }

    class_6880.class_6883<T> method_44298(class_5321<T> key) {
        return this.holdersByName.computeIfAbsent(key.method_29177(), k -> {
            if (this.intrusiveHolderCallback != null) {
                throw new IllegalStateException("This registry can't create new holders without value");
            }
            this.validateWrite(key);
            return class_6880.class_6883.method_40234((class_7876)this.method_46770(), (class_5321)key);
        });
    }

    public Optional<class_6880.class_6883<T>> method_10240(class_5819 rand) {
        return class_156.method_40083(this.getSortedHolders(), (class_5819)rand);
    }

    public Stream<class_6880.class_6883<T>> method_40270() {
        return this.getSortedHolders().stream();
    }

    public Stream<Pair<class_6862<T>, class_6885.class_6888<T>>> method_40272() {
        return this.tags.entrySet().stream().map(e -> Pair.of((Object)((class_6862)e.getKey()), (Object)((class_6885.class_6888)e.getValue())));
    }

    public class_6885.class_6888<T> method_40260(class_6862<T> name) {
        class_6885.class_6888<T> named = this.tags.get(name);
        if (named == null) {
            named = this.createTag(name);
            IdentityHashMap<class_6862<T>, class_6885.class_6888<T>> map = new IdentityHashMap<class_6862<T>, class_6885.class_6888<T>>(this.tags);
            map.put(name, named);
            this.tags = map;
        }
        return named;
    }

    void addOptionalTag(class_6862<T> name, @NotNull Set<? extends Supplier<T>> defaults) {
        this.optionalTags.putAll(name, defaults);
    }

    public Stream<class_6862<T>> method_40273() {
        return this.tags.keySet().stream();
    }

    public class_2378<T> method_40276() {
        this.frozen = true;
        List<class_2960> unregistered = this.holdersByName.entrySet().stream().filter(e -> !((class_6880.class_6883)e.getValue()).method_40227()).map(Map.Entry::getKey).sorted().toList();
        if (!unregistered.isEmpty()) {
            throw new IllegalStateException("Unbound values in registry " + String.valueOf(this.method_30517()) + ": " + unregistered.stream().map(class_2960::toString).collect(Collectors.joining(", \n\t")));
        }
        if (this.field_40584 != null && this.field_40584.values().stream().anyMatch(r -> !r.method_40227() && r.getType() == class_6880.class_6883.class_6884.field_36455)) {
            throw new IllegalStateException("Some intrusive holders were not registered: " + String.valueOf(this.field_40584.values()) + " Hint: Did you register all your registry objects? Registry stage: " + this.stage.getName());
        }
        return this;
    }

    public class_6880.class_6883<T> method_40269(T value) {
        if (this.intrusiveHolderCallback == null) {
            throw new IllegalStateException("This registry can't create intrusive holders");
        }
        this.validateWrite();
        return super.method_40269(value);
    }

    public Optional<class_6885.class_6888<T>> method_40266(class_6862<T> name) {
        return Optional.ofNullable(this.tags.get(name));
    }

    public void method_40257(Map<class_6862<T>, List<class_6880<T>>> newTags) {
        IdentityHashMap<class_6880.class_6883, List> holderToTag = new IdentityHashMap<class_6880.class_6883, List>();
        this.holdersByName.values().forEach(v -> holderToTag.put((class_6880.class_6883)v, new ArrayList()));
        newTags.forEach((name, values) -> values.forEach(holder -> this.addTagToHolder(holderToTag, (class_6862<T>)name, (class_6880<T>)holder)));
        HashSet set = new HashSet(Sets.difference(this.tags.keySet(), newTags.keySet()));
        set.removeAll(this.optionalTags.keySet());
        if (!set.isEmpty()) {
            LOGGER.warn("Not all defined tags for registry {} are present in data pack: {}", (Object)this.method_30517(), (Object)set.stream().map(k -> k.comp_327().toString()).sorted().collect(Collectors.joining(", \n\t")));
        }
        IdentityHashMap<class_6862<T>, class_6885.class_6888<T>> tmpTags = new IdentityHashMap<class_6862<T>, class_6885.class_6888<T>>(this.tags);
        newTags.forEach((k, v) -> tmpTags.computeIfAbsent((class_6862<T>)k, this::createTag).method_40250(v));
        Sets.SetView defaultedTags = Sets.difference((Set)this.optionalTags.keySet(), newTags.keySet());
        defaultedTags.forEach(name -> {
            List<class_6880> defaults = this.optionalTags.get(name).stream().map(valueSupplier -> this.getHolder(valueSupplier.get()).orElse(null)).filter(Objects::nonNull).distinct().toList();
            defaults.forEach(holder -> this.addTagToHolder(holderToTag, (class_6862<T>)name, (class_6880<T>)holder));
            tmpTags.computeIfAbsent((class_6862<T>)name, this::createTag).method_40250(defaults);
        });
        holderToTag.forEach(class_6880.class_6883::method_40235);
        this.tags = tmpTags;
        this.delegate.onBindTags(this.tags, (Set<class_6862<T>>)defaultedTags);
    }

    private void addTagToHolder(Map<class_6880.class_6883<T>, List<class_6862<T>>> holderToTag, class_6862<T> name, class_6880<T> holder) {
        if (!holder.method_46745(this.method_46770())) {
            throw new IllegalStateException("Can't create named set " + String.valueOf(name) + " containing value " + String.valueOf(holder) + " from outside registry " + String.valueOf(this));
        }
        if (!(holder instanceof class_6880.class_6883)) {
            throw new IllegalStateException("Found direct holder " + String.valueOf(holder) + " value in tag " + String.valueOf(name));
        }
        holderToTag.get((class_6880.class_6883)holder).add(name);
    }

    public void method_40278() {
        this.tags.values().forEach(t -> t.method_40250(List.of()));
        this.holders.values().forEach(v -> v.method_40235(Set.of()));
    }

    @Override
    public void unfreeze() {
        this.frozen = false;
    }

    boolean isFrozen() {
        return this.frozen;
    }

    boolean isIntrusive() {
        return this.intrusiveHolderCallback != null;
    }

    @Nullable
    class_6880.class_6883<T> onAdded(RegistryManager stage, int id, class_5321<T> key, T newValue, T oldValue) {
        if (!(stage == RegistryManager.ACTIVE || this.intrusiveHolderCallback != null && stage.isStaging())) {
            return null;
        }
        class_6880.class_6883<T> newHolder = this.getHolder(key, newValue);
        this.holdersById.size(Math.max(this.holdersById.size(), id + 1));
        this.holdersById.set(id, newHolder);
        this.holdersByName.put(key.method_29177(), newHolder);
        this.holders.put(newValue, newHolder);
        if (this.field_40584 != null) {
            this.field_40584.remove(newValue);
            newHolder.method_45917(key);
        }
        newHolder.method_45918(newValue);
        this.holdersSorted = null;
        return newHolder;
    }

    private class_6885.class_6888<T> createTag(class_6862<T> name) {
        return class_6885.method_45924((class_7876)this.method_46770(), name);
    }

    private class_6880.class_6883<T> getHolder(class_5321<T> key, T value) {
        if (this.intrusiveHolderCallback != null) {
            return this.intrusiveHolderCallback.apply(value);
        }
        return this.holdersByName.computeIfAbsent(key.method_29177(), k -> class_6880.class_6883.method_40234((class_7876)this.method_46770(), (class_5321)key));
    }

    private List<class_6880.class_6883<T>> getSortedHolders() {
        if (this.holdersSorted == null) {
            this.holdersSorted = this.holdersById.stream().filter(Objects::nonNull).toList();
        }
        return this.holdersSorted;
    }

    public static class Factory<V>
    implements IForgeRegistry.CreateCallback<V>,
    IForgeRegistry.AddCallback<V> {
        public static final class_2960 ID = new class_2960("forge", "registry_defaulted_wrapper");

        @Override
        public void onCreate(IForgeRegistryInternal<V> owner, RegistryManager stage) {
            ForgeRegistry fowner = (ForgeRegistry)owner;
            owner.setSlaveMap(ID, new NamespacedWrapper(fowner, fowner.getBuilder().getIntrusiveHolderCallback(), stage));
        }

        @Override
        public void onAdd(IForgeRegistryInternal<V> owner, RegistryManager stage, int id, class_5321<V> key, V value, V oldValue) {
            owner.getSlaveMap(ID, NamespacedWrapper.class).onAdded(stage, id, key, value, oldValue);
        }
    }
}

