/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.registries;

import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_2370;
import net.minecraft.class_2378;
import net.minecraft.class_7923;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.event.IModBusEvent;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryBuilder;
import net.minecraftforge.registries.RegistryManager;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import xyz.bluspring.kilt.injections.core.MappedRegistryInjection;

public class NewRegistryEvent
extends Event
implements IModBusEvent {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final List<RegistryData<?>> registries = new ArrayList();

    public <V> Supplier<IForgeRegistry<V>> create(RegistryBuilder<V> builder) {
        return this.create(builder, null);
    }

    public <V> Supplier<IForgeRegistry<V>> create(RegistryBuilder<V> builder, @Nullable Consumer<IForgeRegistry<V>> onFill) {
        RegistryHolder registryHolder = new RegistryHolder();
        this.registries.add(new RegistryData<V>(builder, registryHolder, onFill));
        return registryHolder;
    }

    void fill() {
        Object rootRegistry;
        RuntimeException aggregate = new RuntimeException();
        IdentityHashMap builtRegistries = new IdentityHashMap();
        class_2378 class_23782 = class_7923.field_41167;
        if (class_23782 instanceof class_2370) {
            rootRegistry = (class_2370)class_23782;
            ((MappedRegistryInjection)rootRegistry).unfreeze();
        }
        for (RegistryData registryData : this.registries) {
            try {
                this.buildRegistry(builtRegistries, registryData);
            }
            catch (Throwable t) {
                aggregate.addSuppressed(t);
                return;
            }
        }
        class_2378 class_23783 = class_7923.field_41167;
        if (class_23783 instanceof class_2370) {
            rootRegistry = (class_2370)class_23783;
            rootRegistry.method_40276();
        }
        if (aggregate.getSuppressed().length > 0) {
            LOGGER.error(LogUtils.FATAL_MARKER, "Failed to create some forge registries, see suppressed exceptions for details", (Throwable)aggregate);
        }
    }

    private <T> void buildRegistry(Map<RegistryBuilder<?>, IForgeRegistry<?>> builtRegistries, RegistryData<T> data) {
        RegistryBuilder builder = data.builder;
        IForgeRegistry registry = builder.create();
        builtRegistries.put(builder, registry);
        if (builder.getHasWrapper() && !class_7923.field_41167.method_10250(registry.getRegistryName())) {
            RegistryManager.registerToRootRegistry((ForgeRegistry)registry);
        }
        data.registryHolder.registry = registry;
        if (data.onFill != null) {
            data.onFill.accept(registry);
        }
    }

    public String toString() {
        return "RegistryEvent.NewRegistry";
    }

    private static class RegistryHolder<V>
    implements Supplier<IForgeRegistry<V>> {
        IForgeRegistry<V> registry = null;

        private RegistryHolder() {
        }

        @Override
        public IForgeRegistry<V> get() {
            return this.registry;
        }
    }

    private record RegistryData<V>(RegistryBuilder<V> builder, RegistryHolder<V> registryHolder, Consumer<IForgeRegistry<V>> onFill) {
    }
}

