/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.registries;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.serialization.Lifecycle;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_2378;
import net.minecraft.class_2385;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraftforge.fml.ModLoader;
import net.minecraftforge.network.HandshakeMessages;
import net.minecraftforge.registries.DataPackRegistryEvent;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.NamespacedWrapper;
import net.minecraftforge.registries.NewRegistryEvent;
import net.minecraftforge.registries.RegistryBuilder;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import xyz.bluspring.kilt.util.registry.DeferredForgeRegistry;
import xyz.bluspring.kilt.util.registry.VanillaForgeRegistry;

public class RegistryManager {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final RegistryManager ACTIVE = new RegistryManager("ACTIVE");
    public static final RegistryManager VANILLA = new RegistryManager("VANILLA");
    public static final RegistryManager FROZEN = new RegistryManager("FROZEN");
    private static Set<class_2960> vanillaRegistryKeys = Set.of();
    BiMap<class_2960, ForgeRegistry<?>> registries = HashBiMap.create();
    private Set<class_2960> persisted = Sets.newHashSet();
    private Set<class_2960> synced = Sets.newHashSet();
    private Map<class_2960, class_2960> legacyNames = new HashMap<class_2960, class_2960>();
    private final String name;

    RegistryManager() {
        this("STAGING");
    }

    public RegistryManager(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    boolean isStaging() {
        return "STAGING".equals(this.name);
    }

    public <V> ForgeRegistry<V> getRegistry(class_2960 key) {
        return (ForgeRegistry)this.registries.get((Object)key);
    }

    public <V> ForgeRegistry<V> getRegistry(class_5321<? extends class_2378<V>> key) {
        return this.getRegistry(key.method_29177());
    }

    public <V> DeferredForgeRegistry<V> kilt$getDeferredRegistry(class_5321<? extends class_2378<V>> key) {
        return new DeferredForgeRegistry(key.method_29177());
    }

    public <V> class_2960 getName(IForgeRegistry<V> reg) {
        return (class_2960)this.registries.inverse().get(reg);
    }

    public <V> class_2960 updateLegacyName(class_2960 legacyName) {
        class_2960 originalName = legacyName;
        while (this.getRegistry(legacyName) == null) {
            if ((legacyName = this.legacyNames.get(legacyName)) != null) continue;
            return originalName;
        }
        return legacyName;
    }

    public <V> ForgeRegistry<V> getRegistry(class_2960 key, RegistryManager other) {
        if (!this.registries.containsKey((Object)key)) {
            ForgeRegistry<V> ot = other.getRegistry(key);
            if (ot == null) {
                return null;
            }
            this.registries.put((Object)key, ot.copy(this));
            if (other.persisted.contains(key)) {
                this.persisted.add(key);
            }
            if (other.synced.contains(key)) {
                this.synced.add(key);
            }
            other.legacyNames.entrySet().stream().filter(e -> ((class_2960)e.getValue()).equals((Object)key)).forEach(e -> this.addLegacyName((class_2960)e.getKey(), (class_2960)e.getValue()));
        }
        return this.getRegistry(key);
    }

    <V> ForgeRegistry<V> createRegistry(class_2960 name, RegistryBuilder<V> builder) {
        if (this.registries.containsKey((Object)name)) {
            throw new IllegalArgumentException("Attempted to register a registry for " + String.valueOf(name) + " but it already exists");
        }
        ForgeRegistry reg = builder.kilt$isVanillaRegistry() ? new VanillaForgeRegistry<V>(this, name, builder) : new ForgeRegistry<V>(this, name, builder);
        this.registries.put((Object)name, reg);
        if (builder.getSaveToDisc()) {
            this.persisted.add(name);
        }
        if (builder.getSync()) {
            this.synced.add(name);
        }
        for (class_2960 legacyName : builder.getLegacyNames()) {
            this.addLegacyName(legacyName, name);
        }
        return this.getRegistry(name);
    }

    static <V> void registerToRootRegistry(ForgeRegistry<V> forgeReg) {
        RegistryManager.injectForgeRegistry(forgeReg, class_7923.field_41167);
    }

    private static <V> void injectForgeRegistry(ForgeRegistry<V> forgeReg, class_2378<? extends class_2378<?>> rootRegistry) {
        class_2385 registry = (class_2385)rootRegistry;
        NamespacedWrapper<V> wrapper = forgeReg.getWrapper();
        if (wrapper != null) {
            registry.method_10272(forgeReg.getRegistryKey(), wrapper, Lifecycle.experimental());
        }
    }

    public static void postNewRegistryEvent() {
        NewRegistryEvent event = new NewRegistryEvent();
        DataPackRegistryEvent.NewRegistry dataPackEvent = new DataPackRegistryEvent.NewRegistry();
        vanillaRegistryKeys = Set.copyOf(class_7923.field_41167.method_10235());
        ModLoader.get().postEventWrapContainerInModOrder(event);
        ModLoader.get().postEventWrapContainerInModOrder(dataPackEvent);
        event.fill();
        dataPackEvent.process();
    }

    private void addLegacyName(class_2960 legacyName, class_2960 name) {
        if (this.legacyNames.containsKey(legacyName)) {
            throw new IllegalArgumentException("Legacy name conflict for registry " + String.valueOf(name) + ", upgrade path must be linear: " + String.valueOf(legacyName));
        }
        this.legacyNames.put(legacyName, name);
    }

    private void findSuperTypes(Class<?> type, Set<Class<?>> types) {
        if (type == null || type == Object.class) {
            return;
        }
        types.add(type);
        for (Class<?> interfac : type.getInterfaces()) {
            this.findSuperTypes(interfac, types);
        }
        this.findSuperTypes(type.getSuperclass(), types);
    }

    public Map<class_2960, ForgeRegistry.Snapshot> takeSnapshot(boolean savingToDisc) {
        HashMap ret = Maps.newHashMap();
        Set<class_2960> keys = savingToDisc ? this.persisted : this.synced;
        keys.forEach(name -> ret.put(name, this.getRegistry((class_2960)name).makeSnapshot()));
        return ret;
    }

    public void clean() {
        this.persisted.clear();
        this.synced.clear();
        this.registries.clear();
    }

    public static List<Pair<String, HandshakeMessages.S2CRegistry>> generateRegistryPackets(boolean isLocal) {
        return !isLocal ? ACTIVE.takeSnapshot(false).entrySet().stream().map(e -> Pair.of((Object)("Registry " + String.valueOf(e.getKey())), (Object)new HandshakeMessages.S2CRegistry((class_2960)e.getKey(), (ForgeRegistry.Snapshot)e.getValue()))).collect(Collectors.toList()) : Collections.emptyList();
    }

    public static List<class_2960> getRegistryNamesForSyncToClient() {
        return RegistryManager.ACTIVE.registries.keySet().stream().filter(resloc -> RegistryManager.ACTIVE.synced.contains(resloc)).collect(Collectors.toList());
    }

    public static Set<class_2960> getVanillaRegistryKeys() {
        return vanillaRegistryKeys;
    }
}

