/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.registries;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.ObjectHolderRegistry;
import net.minecraftforge.registries.RegisterEvent;
import net.minecraftforge.registries.RegistryManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RegistryObject<T>
implements Supplier<T> {
    @Nullable
    private final class_2960 name;
    @Nullable
    private class_5321<T> key;
    private final boolean optionalRegistry;
    @Nullable
    private T value;
    @Nullable
    private class_6880<T> holder;
    private static final RegistryObject<?> EMPTY = new RegistryObject();

    public static <T, U extends T> RegistryObject<U> create(class_2960 name, IForgeRegistry<T> registry) {
        return new RegistryObject<T>(name, registry);
    }

    public static <T, U extends T> RegistryObject<U> create(class_2960 name, class_5321<? extends class_2378<T>> registryKey, String modid) {
        return new RegistryObject<T>(name, registryKey.method_29177(), modid, false);
    }

    public static <T, U extends T> RegistryObject<U> createOptional(class_2960 name, class_5321<? extends class_2378<T>> registryKey, String modid) {
        return new RegistryObject<T>(name, registryKey.method_29177(), modid, true);
    }

    public static <T, U extends T> RegistryObject<U> create(class_2960 name, class_2960 registryName, String modid) {
        return new RegistryObject<T>(name, registryName, modid, false);
    }

    public static <T, U extends T> RegistryObject<U> createOptional(class_2960 name, class_2960 registryName, String modid) {
        return new RegistryObject<T>(name, registryName, modid, true);
    }

    private static <T> RegistryObject<T> empty() {
        RegistryObject<?> t = EMPTY;
        return t;
    }

    private RegistryObject() {
        this.name = null;
        this.key = null;
        this.optionalRegistry = false;
    }

    private RegistryObject(class_2960 name, IForgeRegistry<?> registry) {
        if (registry == null) {
            throw new IllegalArgumentException("Invalid registry argument, must not be null");
        }
        this.name = name;
        this.key = class_5321.method_29179(registry.getRegistryKey(), (class_2960)name);
        this.optionalRegistry = false;
        ObjectHolderRegistry.addHandler(pred -> {
            if (pred.test(registry.getRegistryName())) {
                this.updateReference(registry);
            }
        });
        this.updateReference(registry);
    }

    private RegistryObject(class_2960 name, final class_2960 registryName, final String modid, boolean optionalRegistry) {
        this.name = name;
        this.key = class_5321.method_29179((class_5321)class_5321.method_29180((class_2960)registryName), (class_2960)name);
        this.optionalRegistry = optionalRegistry;
        final Throwable callerStack = new Throwable("Calling Site from mod: " + modid);
        ObjectHolderRegistry.addHandler(new Consumer<Predicate<class_2960>>(){
            private boolean registryExists = false;
            private boolean invalidRegistry = false;

            @Override
            public void accept(Predicate<class_2960> pred) {
                if (this.invalidRegistry) {
                    return;
                }
                if (!RegistryObject.this.optionalRegistry && !this.registryExists) {
                    if (!RegistryObject.registryExists(registryName)) {
                        this.invalidRegistry = true;
                        throw new IllegalStateException("Unable to find registry with key " + String.valueOf(registryName) + " for mod \"" + modid + "\". Check the 'caused by' to see further stack.", callerStack);
                    }
                    this.registryExists = true;
                }
                if (pred.test(registryName)) {
                    RegistryObject.this.updateReference(registryName);
                }
            }
        });
        this.updateReference(registryName);
    }

    @Override
    @NotNull
    public T get() {
        T ret = this.value;
        Objects.requireNonNull(ret, () -> "Registry Object not present: " + String.valueOf(this.name));
        return ret;
    }

    void updateReference(IForgeRegistry<? extends T> registry) {
        if (this.name == null || this.key == null) {
            return;
        }
        if (registry.containsKey(this.name)) {
            this.value = registry.getValue(this.name);
            this.holder = registry.getHolder((T)this.name).orElse(null);
        } else {
            this.value = null;
            this.holder = null;
        }
    }

    void updateReference(class_2378<? extends T> registry) {
        if (this.name == null || this.key == null) {
            return;
        }
        if (registry.method_10250(this.name)) {
            this.value = registry.method_10223(this.name);
            this.holder = registry.method_40264(this.key).orElse(null);
        } else {
            this.value = null;
            this.holder = null;
        }
    }

    void updateReference(class_2960 registryName) {
        if (this.name == null) {
            return;
        }
        ForgeRegistry forgeRegistry = RegistryManager.ACTIVE.getRegistry(registryName);
        if (forgeRegistry != null) {
            this.updateReference(forgeRegistry);
            return;
        }
        class_2378 vanillaRegistry = (class_2378)class_7923.field_41167.method_10223(registryName);
        if (vanillaRegistry != null) {
            this.updateReference(vanillaRegistry);
            return;
        }
        this.value = null;
        this.holder = null;
    }

    void updateReference(RegisterEvent event) {
        IForgeRegistry forgeRegistry = event.getForgeRegistry();
        if (forgeRegistry != null) {
            this.updateReference(forgeRegistry);
            return;
        }
        class_2378 vanillaRegistry = event.getVanillaRegistry();
        if (vanillaRegistry != null) {
            this.updateReference(vanillaRegistry);
        } else {
            this.value = null;
        }
    }

    private static boolean registryExists(class_2960 registryName) {
        return RegistryManager.ACTIVE.getRegistry(registryName) != null || class_7923.field_41167.method_10250(registryName);
    }

    public class_2960 getId() {
        return this.name;
    }

    @Nullable
    public class_5321<T> getKey() {
        return this.key;
    }

    public Stream<T> stream() {
        return this.isPresent() ? Stream.of(this.get()) : Stream.of(new Object[0]);
    }

    public boolean isPresent() {
        return this.value != null;
    }

    public void ifPresent(Consumer<? super T> consumer) {
        if (this.isPresent()) {
            consumer.accept(this.get());
        }
    }

    public RegistryObject<T> filter(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate);
        if (!this.isPresent()) {
            return this;
        }
        return predicate.test(this.get()) ? this : RegistryObject.empty();
    }

    public <U> Optional<U> map(Function<? super T, ? extends U> mapper) {
        Objects.requireNonNull(mapper);
        if (!this.isPresent()) {
            return Optional.empty();
        }
        return Optional.ofNullable(mapper.apply(this.get()));
    }

    public <U> Optional<U> flatMap(Function<? super T, Optional<U>> mapper) {
        Objects.requireNonNull(mapper);
        if (!this.isPresent()) {
            return Optional.empty();
        }
        return Objects.requireNonNull(mapper.apply(this.get()));
    }

    public <U> Supplier<U> lazyMap(Function<? super T, ? extends U> mapper) {
        Objects.requireNonNull(mapper);
        return () -> this.isPresent() ? mapper.apply((T)this.get()) : null;
    }

    public T orElse(T other) {
        return this.isPresent() ? this.get() : other;
    }

    public T orElseGet(Supplier<? extends T> other) {
        return this.isPresent() ? this.get() : other.get();
    }

    public <X extends Throwable> T orElseThrow(Supplier<? extends X> exceptionSupplier) throws X {
        if (this.isPresent()) {
            return this.get();
        }
        throw (Throwable)exceptionSupplier.get();
    }

    @NotNull
    public Optional<class_6880<T>> getHolder() {
        return Optional.ofNullable(this.holder);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof RegistryObject) {
            return Objects.equals(((RegistryObject)obj).name, this.name);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.name);
    }
}

