/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.registries.holdersets;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.class_2378;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_6898;
import net.minecraft.class_7225;
import net.minecraft.class_7876;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.registries.holdersets.HolderSetType;
import net.minecraftforge.registries.holdersets.ICustomHolderSet;
import org.jetbrains.annotations.Nullable;
import xyz.bluspring.kilt.injections.resources.RegistryOpsInjection;

public class NotHolderSet<T>
implements ICustomHolderSet<T> {
    private final List<Runnable> owners = new ArrayList<Runnable>();
    private final class_7225.class_7226<T> registryLookup;
    private final class_6885<T> value;
    @Nullable
    private List<class_6880<T>> list = null;

    public static <T> Codec<? extends ICustomHolderSet<T>> codec(class_5321<? extends class_2378<T>> registryKey, Codec<class_6880<T>> holderCodec, boolean forceList) {
        return RecordCodecBuilder.create(builder -> builder.group((App)RegistryOpsInjection.retrieveRegistryLookup(registryKey).forGetter(NotHolderSet::registryLookup), (App)class_6898.method_40388((class_5321)registryKey, (Codec)holderCodec, (boolean)forceList).fieldOf("value").forGetter(NotHolderSet::value)).apply((Applicative)builder, NotHolderSet::new));
    }

    public class_7225.class_7226<T> registryLookup() {
        return this.registryLookup;
    }

    public class_6885<T> value() {
        return this.value;
    }

    public NotHolderSet(class_7225.class_7226<T> registryLookup, class_6885<T> value) {
        this.registryLookup = registryLookup;
        this.value = value;
        this.value.addInvalidationListener(this::invalidate);
    }

    @Override
    public HolderSetType type() {
        return ForgeMod.NOT_HOLDER_SET.get();
    }

    @Override
    public void addInvalidationListener(Runnable runnable) {
        this.owners.add(runnable);
    }

    public Iterator<class_6880<T>> iterator() {
        return this.getList().iterator();
    }

    public Stream<class_6880<T>> method_40239() {
        return this.getList().stream();
    }

    public int method_40247() {
        return this.getList().size();
    }

    public Either<class_6862<T>, List<class_6880<T>>> method_40248() {
        return Either.right(this.getList());
    }

    public Optional<class_6880<T>> method_40243(class_5819 random) {
        List<class_6880<T>> list = this.getList();
        int size = list.size();
        return size > 0 ? Optional.of(list.get(random.method_43048(size))) : Optional.empty();
    }

    public class_6880<T> method_40240(int i) {
        return this.getList().get(i);
    }

    public boolean method_40241(class_6880<T> holder) {
        return !this.value.method_40241(holder);
    }

    public boolean method_46768(class_7876<T> holderOwner) {
        return this.registryLookup.method_46767(holderOwner);
    }

    public Optional<class_6862<T>> method_45925() {
        return Optional.empty();
    }

    public String toString() {
        return "NotSet(" + String.valueOf(this.value) + ")";
    }

    private List<class_6880<T>> getList() {
        List<class_6880<T>> thisList = this.list;
        if (thisList == null) {
            List<class_6880<T>> list = this.registryLookup.method_42017().filter(holder -> !this.value.method_40241((class_6880)holder)).map(holder -> holder).toList();
            this.list = list;
            return list;
        }
        return thisList;
    }

    private void invalidate() {
        this.list = null;
        for (Runnable runnable : this.owners) {
            runnable.run();
        }
    }
}

