/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.server;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_6860;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.ForgeI18n;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import xyz.bluspring.kilt.mixin.MinecraftServerAccessor;

public class LanguageHook {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new Gson();
    private static final Pattern PATTERN = Pattern.compile("%(\\d+\\$)?[\\d\\.]*[df]");
    private static List<Map<String, String>> capturedTables = new ArrayList<Map<String, String>>(2);
    private static Map<String, String> modTable;

    public static void captureLanguageMap(Map<String, String> table) {
        capturedTables.add(table);
        if (modTable != null) {
            capturedTables.forEach(t -> t.putAll(modTable));
        }
    }

    private static void loadLocaleData(List<class_3298> allResources) {
        allResources.forEach(res -> {
            try {
                LanguageHook.loadLocaleData(res.method_14482());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
    }

    private static void loadLocaleData(InputStream inputstream) {
        try {
            JsonElement jsonelement = (JsonElement)GSON.fromJson((Reader)new InputStreamReader(inputstream, StandardCharsets.UTF_8), JsonElement.class);
            JsonObject jsonobject = class_3518.method_15295((JsonElement)jsonelement, (String)"strings");
            jsonobject.entrySet().forEach(entry -> {
                String s = PATTERN.matcher(class_3518.method_15287((JsonElement)((JsonElement)entry.getValue()), (String)((String)entry.getKey()))).replaceAll("%$1s");
                modTable.put((String)entry.getKey(), s);
            });
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputstream);
        }
    }

    private static void loadLanguage(String langName, MinecraftServer server) {
        String langFile = String.format(Locale.ROOT, "lang/%s.json", langName);
        class_6860 resourceManager = ((MinecraftServerAccessor)server).getServerResources().comp_352();
        resourceManager.method_14487().forEach(arg_0 -> LanguageHook.lambda$loadLanguage$3(langFile, (class_3300)resourceManager, arg_0));
    }

    public static void loadForgeAndMCLangs() {
        modTable = new HashMap<String, String>(5000);
        InputStream mc = Thread.currentThread().getContextClassLoader().getResourceAsStream("assets/minecraft/lang/en_us.json");
        InputStream forge = Thread.currentThread().getContextClassLoader().getResourceAsStream("assets/forge/lang/en_us.json");
        LanguageHook.loadLocaleData(mc);
        LanguageHook.loadLocaleData(forge);
        capturedTables.forEach(t -> t.putAll(modTable));
        ForgeI18n.loadLanguageData(modTable);
    }

    static void loadLanguagesOnServer(MinecraftServer server) {
        modTable = new HashMap<String, String>(5000);
        for (String lang : Arrays.asList("en_us")) {
            LanguageHook.loadLanguage(lang, server);
        }
        capturedTables.forEach(t -> t.putAll(modTable));
        ForgeI18n.loadLanguageData(modTable);
    }

    private static /* synthetic */ void lambda$loadLanguage$3(String langFile, class_3300 resourceManager, String namespace) {
        try {
            class_2960 langResource = new class_2960(namespace, langFile);
            LanguageHook.loadLocaleData(resourceManager.method_14489(langResource));
        }
        catch (Exception exception) {
            LOGGER.warn("Skipped language file: {}:{}", (Object)namespace, (Object)langFile, (Object)exception);
        }
    }
}

