/*
 * Decompiled with CFR 0.152.
 */
package xyz.bluspring.kilt;

import com.bawnorton.mixinsquared.MixinSquaredBootstrap;
import com.bawnorton.mixinsquared.adjuster.MixinAnnotationAdjusterRegistrar;
import com.bawnorton.mixinsquared.api.MixinAnnotationAdjuster;
import com.bawnorton.mixinsquared.api.MixinCanceller;
import com.bawnorton.mixinsquared.canceller.MixinCancellerRegistrar;
import com.bawnorton.mixinsquared.ext.ExtensionRegistrar;
import com.llamalad7.mixinextras.MixinExtrasBootstrap;
import com.moulberry.mixinconstraints.MixinConstraints;
import com.moulberry.mixinconstraints.mixin.MixinConstraintsBootstrap;
import cpw.mods.niofs.union.KiltUnionFileSystemHelper;
import java.lang.reflect.Field;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;
import kotlin.text.StringsKt;
import net.fabricmc.loader.impl.launch.FabricLauncherBase;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.mixin.transformer.ext.IExtension;
import xyz.bluspring.kilt.Kilt;
import xyz.bluspring.kilt.helpers.mixin.MixinExtensionHelper;
import xyz.bluspring.kilt.loader.mixin.modifier.KiltMixinModifier;

public class KiltMixinPlugin
implements IMixinConfigPlugin {
    private String mixinPackage;

    public void onLoad(String mixinPackage) {
        this.mixinPackage = mixinPackage;
        try {
            KiltUnionFileSystemHelper.directlyLoadIntoClassLoader((ClassLoader)FabricLauncherBase.getLauncher().getTargetClassLoader());
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        MixinExtrasBootstrap.init();
        MixinConstraintsBootstrap.init((String)mixinPackage);
        ExtensionRegistrar.register((IExtension)new KiltMixinModifier());
        MixinSquaredBootstrap.init();
        try {
            Field cancellersField = MixinCancellerRegistrar.class.getDeclaredField("cancellers");
            cancellersField.setAccessible(true);
            Field adjustersField = MixinAnnotationAdjusterRegistrar.class.getDeclaredField("adjusters");
            adjustersField.setAccessible(true);
            Set cancellers = (Set)cancellersField.get(null);
            Set adjusters = (Set)adjustersField.get(null);
            ServiceLoader.load(MixinCanceller.class).forEach(mixinCanceller -> {
                if (cancellers.stream().noneMatch(e -> e.getClass() == mixinCanceller.getClass())) {
                    MixinCancellerRegistrar.register((MixinCanceller)mixinCanceller);
                }
            });
            ServiceLoader.load(MixinAnnotationAdjuster.class).forEach(adjuster -> {
                if (adjusters.stream().noneMatch(e -> e.getClass() == adjuster.getClass())) {
                    MixinAnnotationAdjusterRegistrar.register((MixinAnnotationAdjuster)adjuster);
                }
            });
        }
        catch (Throwable e) {
            throw new RuntimeException("Failed to inject Forge MixinSquared services into MixinSquared Fabric!", e);
        }
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        if (!mixinClassName.startsWith(this.mixinPackage)) {
            return true;
        }
        if (mixinClassName.contains("compat.forge.")) {
            String modId = StringsKt.removePrefix((String)mixinClassName, (CharSequence)"xyz.bluspring.kilt.mixin.compat.forge.").split("\\.")[0];
            return Kilt.Companion.getLoader().hasMod(modId) && MixinConstraints.shouldApplyMixin((String)mixinClassName);
        }
        return MixinConstraints.shouldApplyMixin((String)mixinClassName);
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
        MixinExtensionHelper.preApply(targetClassName, targetClass, mixinClassName, mixinInfo);
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
        MixinExtensionHelper.postApply(targetClassName, targetClass, mixinClassName, mixinInfo);
    }
}

