/*
 * Decompiled with CFR 0.152.
 */
package xyz.bluspring.kilt.forgeinjects.world.entity;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Cancellable;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalBooleanRef;
import com.llamalad7.mixinextras.sugar.ref.LocalDoubleRef;
import com.llamalad7.mixinextras.sugar.ref.LocalFloatRef;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import io.github.fabricators_of_create.porting_lib.entity.extensions.EntityExtensions;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_3218;
import net.minecraft.class_6862;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.extensions.IForgeLivingEntity;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.event.entity.living.LivingSwapItemsEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.event.entity.living.PotionColorCalculationEvent;
import net.minecraftforge.event.entity.living.ShieldBlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.items.wrapper.EntityEquipmentInvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Implements;
import org.spongepowered.asm.mixin.Interface;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import xyz.bluspring.kilt.injections.CapabilityProviderInjection;
import xyz.bluspring.kilt.injections.world.entity.LivingEntityInjection;

@Mixin(value={class_1309.class})
@Implements(value={@Interface(iface=IForgeLivingEntity.class, prefix="kilt$i$")})
public abstract class LivingEntityInject
extends class_1297
implements EntityExtensions,
CapabilityProviderInjection,
LivingEntityInjection {
    @Shadow
    @Final
    private static class_2940<Integer> field_6240;
    @Shadow
    @Final
    private static class_2940<Boolean> field_6214;
    @Shadow
    @Nullable
    protected class_1657 field_6258;
    @Shadow
    @Final
    private Map<class_1291, class_1293> field_6280;
    @Shadow
    private boolean field_6285;
    @Shadow
    protected class_1799 field_6277;
    @Shadow
    protected int field_6222;
    private LazyOptional<?>[] handlers = EntityEquipmentInvWrapper.create((class_1309)this);

    public LivingEntityInject(class_1299<?> entityType, class_1937 level) {
        super(entityType, level);
    }

    @Shadow
    public abstract boolean method_5805();

    @Shadow
    public abstract class_1799 method_5998(class_1268 var1);

    @Shadow
    protected abstract void method_6129(class_1293 var1);

    @Shadow
    public abstract int method_6014();

    @Shadow
    public abstract class_1268 method_6058();

    @WrapWithCondition(method={"checkFallDamage"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerLevel;sendParticles(Lnet/minecraft/core/particles/ParticleOptions;DDDIDDDD)I")})
    private <T extends class_2394> boolean kilt$checkIfShouldSpawnParticles(class_3218 instance, T type, double posX, double posY, double posZ, int particleCount, double xOffset, double yOffset, double zOffset, double speed, @Local(argsOnly=true) class_2680 state, @Local(argsOnly=true) class_2338 pos, @Local int i) {
        return !state.addLandingEffects(instance, pos, state, (class_1309)this, i);
    }

    @WrapOperation(method={"baseTick"}, at={@At(value="FIELD", target="Lnet/minecraft/world/entity/LivingEntity;isInPowderSnow:Z")})
    private boolean kilt$checkIfCanExtinguish(class_1309 instance, Operation<Boolean> original) {
        return (Boolean)original.call(new Object[]{instance}) != false || instance.isInFluidType((fluidType, height) -> instance.canFluidExtinguish(fluidType));
    }

    @WrapOperation(method={"tickEffects"}, at={@At(value="FIELD", target="Lnet/minecraft/world/level/Level;isClientSide:Z", ordinal=0)})
    private boolean kilt$checkIfEffectExpired(class_1937 instance, Operation<Boolean> original, @Local class_1293 effect) {
        return (Boolean)original.call(new Object[]{instance}) != false || MinecraftForge.EVENT_BUS.post((Event)new MobEffectEvent.Expired((class_1309)this, effect));
    }

    @Inject(method={"updateInvisibilityStatus"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;setInvisible(Z)V", ordinal=1)})
    private void kilt$calculateEffectColors(CallbackInfo ci, @Local Collection<class_1293> effects) {
        PotionColorCalculationEvent event = new PotionColorCalculationEvent((class_1309)this, (Integer)this.field_6011.method_12789(field_6240), (Boolean)this.field_6011.method_12789(field_6214), effects);
        MinecraftForge.EVENT_BUS.post((Event)event);
        this.field_6011.method_12778(field_6214, (Object)event.areParticlesHidden());
        this.field_6011.method_12778(field_6240, (Object)event.getColor());
    }

    @ModifyReturnValue(method={"getVisibilityPercent"}, at={@At(value="RETURN")})
    private double kilt$modifyVisibilityMultiplier(double original, @Local(argsOnly=true) class_1297 lookingEntity) {
        return ForgeHooks.getEntityVisibilityMultiplier((class_1309)this, lookingEntity, original);
    }

    @WrapWithCondition(method={"removeAllEffects"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;onEffectRemoved(Lnet/minecraft/world/effect/MobEffectInstance;)V")})
    private boolean kilt$callRemoveEffectEvent(class_1309 instance, class_1293 effectInstance, @Share(value="shouldRemove") LocalBooleanRef shouldCancel) {
        if (MinecraftForge.EVENT_BUS.post((Event)new MobEffectEvent.Remove((class_1309)this, effectInstance))) {
            shouldCancel.set(true);
            return false;
        }
        return true;
    }

    @WrapWithCondition(method={"removeAllEffects"}, at={@At(value="INVOKE", target="Ljava/util/Iterator;remove()V")})
    private boolean kilt$checkIfCancelledAlready(Iterator<?> instance, @Share(value="shouldRemove") LocalBooleanRef shouldCancel) {
        return !shouldCancel.get();
    }

    @WrapOperation(method={"addEffect(Lnet/minecraft/world/effect/MobEffectInstance;Lnet/minecraft/world/entity/Entity;)Z"}, at={@At(value="INVOKE", target="Ljava/util/Map;get(Ljava/lang/Object;)Ljava/lang/Object;")})
    private <K, V> V kilt$callAddEffectEvent(Map<K, V> instance, K o, Operation<V> original, @Local(argsOnly=true) class_1293 newEffect, @Local(argsOnly=true) class_1297 entity) {
        class_1293 oldEffect = (class_1293)original.call(new Object[]{instance, o});
        MinecraftForge.EVENT_BUS.post((Event)new MobEffectEvent.Added((class_1309)this, oldEffect, newEffect, entity));
        return (V)oldEffect;
    }

    @Inject(method={"canBeAffected"}, at={@At(value="HEAD")}, cancellable=true)
    private void kilt$checkIsEffectApplicable(class_1293 effectInstance, CallbackInfoReturnable<Boolean> cir) {
        MobEffectEvent.Applicable event = new MobEffectEvent.Applicable((class_1309)this, effectInstance);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.getResult() != Event.Result.DEFAULT) {
            cir.setReturnValue((Object)(event.getResult() == Event.Result.ALLOW ? 1 : 0));
        }
    }

    @Inject(method={"removeEffect"}, at={@At(value="HEAD")}, cancellable=true)
    private void kilt$checkRemoveEffect(class_1291 effect, CallbackInfoReturnable<Boolean> cir) {
        if (MinecraftForge.EVENT_BUS.post((Event)new MobEffectEvent.Remove((class_1309)this, effect))) {
            cir.setReturnValue((Object)false);
        }
    }

    @ModifyVariable(method={"heal"}, at=@At(value="HEAD"), argsOnly=true)
    private float kilt$callHealEvent(float value) {
        return ForgeEventFactory.onLivingHeal((class_1309)this, value);
    }

    @Inject(method={"heal"}, at={@At(value="HEAD")}, cancellable=true)
    private void kilt$checkIfHealValueIsNegative(float healAmount, CallbackInfo ci) {
        if (healAmount <= 0.0f) {
            ci.cancel();
        }
    }

    @Inject(method={"hurt"}, at={@At(value="HEAD")}, cancellable=true)
    private void kilt$checkLivingAttackEvent(class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        if (!ForgeHooks.onLivingAttack((class_1309)this, source, amount)) {
            cir.setReturnValue((Object)false);
        }
    }

    @WrapOperation(method={"hurt"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;isDamageSourceBlocked(Lnet/minecraft/world/damagesource/DamageSource;)Z")})
    private boolean kilt$checkShieldBlocked(class_1309 instance, class_1282 damageSource, Operation<Boolean> original, @Share(value="event") LocalRef<ShieldBlockEvent> eventRef, @Local(argsOnly=true) float damage) {
        Boolean isBlocked = (Boolean)original.call(new Object[]{instance, damageSource});
        if (isBlocked.booleanValue()) {
            eventRef.set((Object)ForgeHooks.onShieldBlock(instance, damageSource, damage));
            isBlocked = !((ShieldBlockEvent)((Object)eventRef.get())).isCanceled();
        }
        return isBlocked;
    }

    @WrapWithCondition(method={"hurt"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;hurtCurrentlyUsedShield(F)V")})
    private boolean kilt$checkShieldTakesDamage(class_1309 instance, float damageAmount, @Share(value="event") LocalRef<ShieldBlockEvent> eventRef) {
        return ((ShieldBlockEvent)((Object)eventRef.get())).shieldTakesDamage();
    }

    @ModifyExpressionValue(method={"hurt"}, at={@At(value="CONSTANT", args={"intValue=1"})})
    private int kilt$checkIfDamageNegative(int original, @Local(argsOnly=true) float damageAmount) {
        return original == 1 && damageAmount <= 0.0f ? 1 : original;
    }

    @WrapOperation(method={"checkTotemDeathProtection"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;is(Lnet/minecraft/world/item/Item;)Z", ordinal=0)})
    private boolean kilt$checkTotemEvent(class_1799 instance, class_1792 item, Operation<Boolean> original, @Local(argsOnly=true) class_1282 source, @Local class_1268 hand) {
        return (Boolean)original.call(new Object[]{instance, item}) != false && ForgeHooks.onLivingUseTotem((class_1309)this, source, instance, hand);
    }

    @Inject(method={"die"}, at={@At(value="HEAD")}, cancellable=true)
    private void kilt$checkLivingDeath(class_1282 damageSource, CallbackInfo ci) {
        if (ForgeHooks.onLivingDeath((class_1309)this, damageSource)) {
            ci.cancel();
        }
    }

    @WrapOperation(method={"createWitherRose"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/GameRules;getBoolean(Lnet/minecraft/world/level/GameRules$Key;)Z")})
    private boolean kilt$checkCanMobGrief(class_1928 instance, class_1928.class_4313<class_1928.class_4310> key, Operation<Boolean> original, @Local(argsOnly=true, ordinal=1) class_1309 entity) {
        return (Boolean)original.call(new Object[]{instance, key}) != false || ForgeEventFactory.getMobGriefingEvent(this.method_37908(), (class_1297)entity);
    }

    @WrapOperation(method={"createWitherRose"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/state/BlockState;isAir()Z")})
    private boolean kilt$checkIsEmpty(class_2680 instance, Operation<Boolean> original, @Local class_2338 pos) {
        return (Boolean)original.call(new Object[]{instance}) != false || this.method_37908().method_22347(pos);
    }

    @ModifyArg(method={"dropExperience"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/ExperienceOrb;award(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/phys/Vec3;I)V"))
    private int kilt$modifyExperienceReward(int original) {
        return ForgeEventFactory.getExperienceDrop((class_1309)this, this.field_6258, original);
    }

    @Inject(method={"knockback"}, at={@At(value="HEAD")}, cancellable=true)
    private void kilt$modifyKnockback(CallbackInfo ci, @Local(argsOnly=true, ordinal=0) LocalDoubleRef strength, @Local(argsOnly=true, ordinal=1) LocalDoubleRef x, @Local(argsOnly=true, ordinal=2) LocalDoubleRef z) {
        LivingKnockBackEvent event = ForgeHooks.onLivingKnockBack((class_1309)this, (float)strength.get(), x.get(), z.get());
        if (event.isCanceled()) {
            ci.cancel();
        }
        strength.set((double)event.getStrength());
        x.set(event.getRatioX());
        z.set(event.getRatioZ());
    }

    @Inject(method={"causeFallDamage"}, at={@At(value="HEAD")}, cancellable=true)
    private void kilt$checkIfCancelledFallDamage(CallbackInfoReturnable<Boolean> cir, @Local(argsOnly=true, ordinal=0) LocalFloatRef fallDistance, @Local(argsOnly=true, ordinal=1) LocalFloatRef multiplier) {
        float[] values = ForgeHooks.onLivingFall((class_1309)this, fallDistance.get(), multiplier.get());
        if (values == null) {
            cir.setReturnValue((Object)false);
            return;
        }
        fallDistance.set(values[0]);
        multiplier.set(values[1]);
    }

    @Inject(method={"actuallyHurt"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;isInvulnerableTo(Lnet/minecraft/world/damagesource/DamageSource;)Z", shift=At.Shift.AFTER)}, cancellable=true)
    private void kilt$cancelIfNegativeDamage(CallbackInfo ci, @Local(argsOnly=true) class_1282 source, @Local(argsOnly=true) LocalFloatRef damageAmount) {
        damageAmount.set(ForgeHooks.onLivingHurt((class_1309)this, source, damageAmount.get()));
        if (damageAmount.get() <= 0.0f) {
            ci.cancel();
        }
    }

    @Inject(method={"actuallyHurt"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;setAbsorptionAmount(F)V", shift=At.Shift.BY, by=2)})
    private void kilt$callDamageEvent(class_1282 damageSource, float damageAmount, CallbackInfo ci, @Local(argsOnly=true) class_1282 source, @Local(argsOnly=true) LocalFloatRef damageAmountRef) {
        damageAmountRef.set(ForgeHooks.onLivingDamage((class_1309)this, source, damageAmount));
    }

    @Inject(method={"swing(Lnet/minecraft/world/InteractionHand;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void kilt$checkStackSwing(class_1268 hand, CallbackInfo ci) {
        class_1799 stack = this.method_5998(hand);
        if (!stack.method_7960() && stack.onEntitySwing((class_1309)this)) {
            ci.cancel();
        }
    }

    @Inject(method={"swapHandItems"}, at={@At(value="HEAD")}, cancellable=true)
    private void kilt$callSwapHandItemsEvent(CallbackInfo ci, @Share(value="event") LocalRef<LivingSwapItemsEvent.Hands> event) {
        event.set((Object)ForgeHooks.onLivingSwapHandItems((class_1309)this));
        if (((LivingSwapItemsEvent.Hands)((Object)event.get())).isCanceled()) {
            ci.cancel();
        }
    }

    @WrapOperation(method={"swapHandItems"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;setItemSlot(Lnet/minecraft/world/entity/EquipmentSlot;Lnet/minecraft/world/item/ItemStack;)V")})
    private void kilt$changeHandItems(class_1309 instance, class_1304 slot, class_1799 itemStack, Operation<Void> original, @Share(value="event") LocalRef<LivingSwapItemsEvent.Hands> eventRef) {
        LivingSwapItemsEvent.Hands event = (LivingSwapItemsEvent.Hands)((Object)eventRef.get());
        if (slot == class_1304.field_6171 && !event.getItemSwappedToOffHand().equals(itemStack)) {
            itemStack = event.getItemSwappedToOffHand();
        } else if (slot == class_1304.field_6173 && !event.getItemSwappedToMainHand().equals(itemStack)) {
            itemStack = event.getItemSwappedToMainHand();
        }
        original.call(new Object[]{instance, slot, itemStack});
    }

    @Inject(method={"jumpFromGround"}, at={@At(value="TAIL")})
    private void kilt$callJumpEvent(CallbackInfo ci) {
        ForgeHooks.onLivingJump((class_1309)this);
    }

    @WrapOperation(method={"aiStep"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;getFluidHeight(Lnet/minecraft/tags/TagKey;)D", ordinal=1)})
    private double kilt$tryUseFluidTypeHeight(class_1309 instance, class_6862 tagKey, Operation<Double> original) {
        FluidType fluidType = instance.getMaxHeightFluidType();
        if (!fluidType.isAir()) {
            return instance.getFluidTypeHeight(fluidType);
        }
        return (Double)original.call(new Object[]{instance, tagKey});
    }

    @Override
    public boolean curePotionEffects(class_1799 curativeStack) {
        if (this.method_37908().method_8608()) {
            return false;
        }
        boolean ret = false;
        Iterator<class_1293> effects = this.field_6280.values().iterator();
        while (effects.hasNext()) {
            class_1293 effect = effects.next();
            if (!effect.isCurativeItem(curativeStack) || MinecraftForge.EVENT_BUS.post((Event)new MobEffectEvent.Remove((class_1309)this, effect))) continue;
            this.method_6129(effect);
            effects.remove();
            ret = true;
            this.field_6285 = true;
        }
        return ret;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap) {
        return this.getCapability(cap, null);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable class_2350 side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER && this.method_5805()) {
            if (side == null) {
                return this.handlers[2].cast();
            }
            if (side.method_10166().method_10178()) {
                return this.handlers[0].cast();
            }
            if (side.method_10166().method_10179()) {
                return this.handlers[1].cast();
            }
        }
        return this.kilt$getCapabilityWorkaround().getCapability(cap, side);
    }

    @Inject(method={"updateUsingItem"}, at={@At(value="HEAD")})
    private void kilt$onUseTickEvent(class_1799 usingItem, CallbackInfo ci) {
        if (!usingItem.method_7960()) {
            this.field_6222 = ForgeEventFactory.onItemUseTick((class_1309)this, usingItem, this.method_6014());
        }
    }

    @WrapWithCondition(method={"updateUsingItem"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;onUseTick(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/LivingEntity;I)V")})
    private boolean kilt$checkUseTick(class_1799 instance, class_1937 level, class_1309 livingEntity, int count) {
        return this.method_6014() > 0;
    }

    @Inject(method={"startUsingItem"}, at={@At(value="FIELD", target="Lnet/minecraft/world/entity/LivingEntity;useItem:Lnet/minecraft/world/item/ItemStack;")})
    private void kilt$storeLastUsedItem(CallbackInfo ci, @Share(value="lastUsed") LocalRef<class_1799> lastUsed) {
        lastUsed.set((Object)this.field_6277);
    }

    @ModifyExpressionValue(method={"startUsingItem"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;getUseDuration()I")})
    private int kilt$onItemUseEvent(int original, @Local class_1799 itemStack, @Cancellable CallbackInfo ci, @Share(value="lastUsed") LocalRef<class_1799> lastUsed) {
        int duration = ForgeEventFactory.onItemUseStart((class_1309)this, itemStack, original);
        if (duration <= 0) {
            ci.cancel();
            this.field_6277 = (class_1799)lastUsed.get();
        }
        return duration;
    }

    @WrapOperation(method={"completeUsingItem"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;finishUsingItem(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/LivingEntity;)Lnet/minecraft/world/item/ItemStack;")})
    private class_1799 kilt$onItemUseFinishEvent(class_1799 instance, class_1937 level, class_1309 livingEntity, Operation<class_1799> original) {
        class_1799 copy = this.field_6277.method_7972();
        return ForgeEventFactory.onItemUseFinish((class_1309)this, copy, this.method_6014(), (class_1799)original.call(new Object[]{instance, level, livingEntity}));
    }

    @WrapOperation(method={"releaseUsingItem"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;releaseUsing(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/LivingEntity;I)V")})
    private void kilt$onStopUsingItemEvent(class_1799 instance, class_1937 level, class_1309 livingEntity, int timeLeft, Operation<Void> original) {
        if (!ForgeEventFactory.onUseItemStop((class_1309)this, this.field_6277, this.method_6014())) {
            class_1799 copy = (class_1309)this instanceof class_1657 ? this.field_6277.method_7972() : null;
            original.call(new Object[]{instance, level, livingEntity, timeLeft});
            if (copy != null && this.field_6277.method_7960()) {
                ForgeEventFactory.onPlayerDestroyItem((class_1657)this, copy, this.method_6058());
            }
        }
    }

    @Intrinsic
    public class_1309 kilt$i$self() {
        return (class_1309)this;
    }
}

