/*
 * Decompiled with CFR 0.152.
 */
package xyz.bluspring.kilt.helpers.mixin;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.jetbrains.annotations.ApiStatus;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.util.Annotations;
import xyz.bluspring.kilt.helpers.mixin.AbstractOverride;
import xyz.bluspring.kilt.helpers.mixin.AnnotationValueVisitor;
import xyz.bluspring.kilt.helpers.mixin.CreateInitializer;
import xyz.bluspring.kilt.helpers.mixin.CreateStatic;
import xyz.bluspring.kilt.helpers.mixin.Extends;

public final class MixinExtensionHelper {
    private static boolean containsOpcode(InsnList list, int opcode) {
        for (AbstractInsnNode node : list) {
            if (node.getOpcode() != opcode) continue;
            return true;
        }
        return false;
    }

    private static boolean containsThisCall(ClassNode classNode, InsnList list) {
        for (AbstractInsnNode node : list) {
            if (node.getOpcode() != 183 || !(node instanceof MethodInsnNode)) continue;
            MethodInsnNode methodInsnNode = (MethodInsnNode)node;
            if (!methodInsnNode.owner.equals(classNode.name) || !methodInsnNode.name.equals("<init>")) continue;
            return true;
        }
        return false;
    }

    @ApiStatus.Internal
    public static void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
        ClassNode classNode = mixinInfo.getClassNode(0);
        String slashedMixinClassName = mixinClassName.replaceAll("\\.", "/");
        String slashedTargetClassName = targetClassName.replaceAll("\\.", "/");
        AnnotationNode extend = Annotations.getVisible((ClassNode)classNode, Extends.class);
        String oldSuper = targetClass.superName;
        if (extend != null) {
            if (targetClass.superName != null && !targetClass.superName.equals("java/lang/Object")) {
                throw new IllegalStateException(String.format("Class %s should not already have a super class! (tried extend by %s, has %s)", targetClassName, mixinClassName, classNode.superName));
            }
            AnnotationValueVisitor visitor = new AnnotationValueVisitor();
            extend.accept((AnnotationVisitor)visitor);
            String className = ((Type)visitor.values.get("value")).getClassName();
            targetClass.superName = className.replace(".", "/");
            if (targetClass.signature != null) {
                targetClass.signature = targetClass.signature.replaceFirst("java/lang/Object", targetClass.superName);
            }
        }
        for (MethodNode methodNode : classNode.methods) {
            if (Annotations.getVisible((MethodNode)methodNode, CreateInitializer.class) == null) continue;
            MethodNode initializer = new MethodNode(1, "<init>", methodNode.desc, methodNode.signature, methodNode.exceptions != null ? (String[])methodNode.exceptions.toArray(String[]::new) : null);
            initializer.visitCode();
            for (AbstractInsnNode insnNode : methodNode.instructions) {
                if (insnNode instanceof MethodInsnNode) {
                    MethodInsnNode methodInsn = (MethodInsnNode)insnNode;
                    if (insnNode.getOpcode() == 183) {
                        if (methodInsn.owner.equals(slashedMixinClassName)) {
                            initializer.visitMethodInsn(183, slashedTargetClassName, "<init>", methodInsn.desc, false);
                            continue;
                        }
                        String superName = methodInsn.owner.equals(oldSuper) ? targetClass.superName : methodInsn.owner;
                        initializer.visitMethodInsn(183, superName, "<init>", methodInsn.desc, false);
                        continue;
                    }
                    if (methodInsn.owner.equals(slashedMixinClassName)) {
                        methodInsn.owner = slashedTargetClassName;
                    }
                    initializer.instructions.add((AbstractInsnNode)methodInsn);
                    continue;
                }
                if (insnNode instanceof FieldInsnNode) {
                    FieldInsnNode fieldInsn = (FieldInsnNode)insnNode;
                    if (fieldInsn.owner.equals(slashedMixinClassName)) {
                        fieldInsn.owner = slashedTargetClassName;
                    }
                    initializer.instructions.add((AbstractInsnNode)fieldInsn);
                    continue;
                }
                initializer.instructions.add(insnNode);
            }
            initializer.visitEnd();
            initializer.localVariables = methodNode.localVariables;
            methodNode.instructions.clear();
            targetClass.methods.add(initializer);
        }
    }

    @ApiStatus.Internal
    public static void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
        ClassNode classNode = mixinInfo.getClassNode(0);
        String slashedMixinClassName = mixinClassName.replaceAll("\\.", "/");
        String slashedTargetClassName = targetClassName.replaceAll("\\.", "/");
        ArrayList<FieldNode> fieldsToRemove = new ArrayList<FieldNode>();
        ArrayList<MethodNode> methodsToRemove = new ArrayList<MethodNode>();
        AnnotationNode extend = Annotations.getVisible((ClassNode)classNode, Extends.class);
        LinkedList<MethodNode> replacementNodes = new LinkedList<MethodNode>();
        for (FieldNode fieldNode : classNode.fields) {
            if (Annotations.getVisible((FieldNode)fieldNode, CreateStatic.class) == null) continue;
            fieldsToRemove.add(fieldNode);
            targetClass.fields.removeIf(field -> field.name.equals(fieldNode.name) && field.desc.equals(fieldNode.desc));
            targetClass.visitField(9, fieldNode.name, fieldNode.desc, fieldNode.signature, fieldNode.value).visitEnd();
        }
        for (MethodNode methodNode : classNode.methods) {
            ListIterator insn2;
            if (Annotations.getVisible((MethodNode)methodNode, CreateStatic.class) != null) {
                methodsToRemove.add(methodNode);
                targetClass.methods.removeIf(method -> method.name.equals(methodNode.name) && method.desc.equals(methodNode.desc));
                MethodNode method2 = new MethodNode(9, methodNode.name, methodNode.desc, methodNode.signature, methodNode.exceptions != null ? (String[])methodNode.exceptions.toArray(String[]::new) : null);
                method2.visitCode();
                InsnList instructions = new InsnList();
                for (ListIterator insn2 : methodNode.instructions) {
                    if (insn2 instanceof MethodInsnNode) {
                        MethodInsnNode methodInsn = (MethodInsnNode)insn2;
                        if (methodInsn.owner.equals(slashedMixinClassName)) {
                            methodInsn.owner = slashedTargetClassName;
                        }
                        instructions.add((AbstractInsnNode)methodInsn);
                        continue;
                    }
                    if (insn2 instanceof FieldInsnNode) {
                        FieldInsnNode fieldInsn = (FieldInsnNode)insn2;
                        if (fieldInsn.owner.equals(slashedMixinClassName)) {
                            fieldInsn.owner = slashedTargetClassName;
                        }
                        instructions.add((AbstractInsnNode)fieldInsn);
                        continue;
                    }
                    instructions.add((AbstractInsnNode)insn2);
                }
                method2.instructions.add(instructions);
                method2.localVariables.addAll(methodNode.localVariables);
                method2.visitEnd();
                targetClass.methods.add(method2);
                continue;
            }
            if (Annotations.getVisible((MethodNode)methodNode, AbstractOverride.class) == null) continue;
            List<MethodNode> originalMethods = targetClass.methods.stream().filter(a -> a.name.equals(methodNode.name) && a.desc.equals(methodNode.desc)).toList();
            if (originalMethods.isEmpty()) {
                throw new IllegalStateException("Could not find method " + methodNode.name + methodNode.desc + " in class " + targetClass.name);
            }
            MethodNode originalMethod = originalMethods.get(0);
            targetClass.methods.remove(originalMethod);
            MethodNode node = new MethodNode(originalMethod.access & 0xFFFFFBFF, originalMethod.name, originalMethod.desc, originalMethod.signature, methodNode.exceptions != null ? (String[])methodNode.exceptions.toArray(String[]::new) : null);
            node.visitCode();
            insn2 = methodNode.instructions.iterator();
            while (insn2.hasNext()) {
                AbstractInsnNode insnNode = (AbstractInsnNode)insn2.next();
                if (insnNode instanceof MethodInsnNode) {
                    MethodInsnNode methodInsn = (MethodInsnNode)insnNode;
                    if (methodInsn.owner.equals(slashedMixinClassName)) {
                        methodInsn.owner = slashedTargetClassName;
                    }
                    node.instructions.add((AbstractInsnNode)methodInsn);
                    continue;
                }
                if (insnNode instanceof FieldInsnNode) {
                    FieldInsnNode fieldInsn = (FieldInsnNode)insnNode;
                    if (fieldInsn.owner.equals(slashedMixinClassName)) {
                        fieldInsn.owner = slashedTargetClassName;
                    }
                    node.instructions.add((AbstractInsnNode)fieldInsn);
                    continue;
                }
                node.instructions.add(insnNode);
            }
            node.visitEnd();
            node.localVariables = methodNode.localVariables;
            targetClass.methods.add(node);
        }
        for (MethodNode methodNode : targetClass.methods) {
            if (extend == null || !methodNode.name.equals("<init>") || MixinExtensionHelper.containsThisCall(targetClass, methodNode.instructions)) continue;
            methodsToRemove.add(methodNode);
            InsnList instructions = methodNode.instructions;
            InsnList insnList = new InsnList();
            insnList.add(instructions);
            MethodInsnNode insnToRemove = null;
            for (AbstractInsnNode insn : insnList) {
                if (!(insn instanceof MethodInsnNode)) continue;
                MethodInsnNode methodInsnNode = (MethodInsnNode)insn;
                if (insn.getOpcode() != 183 || !methodInsnNode.owner.equals("java/lang/Object")) continue;
                insnList.insert(insn, (AbstractInsnNode)new MethodInsnNode(183, targetClass.superName, "<init>", "()V"));
                insnToRemove = methodInsnNode;
            }
            insnList.remove(insnToRemove);
            MethodNode newNode = new MethodNode(589824, methodNode.access, methodNode.name, methodNode.desc, methodNode.signature, methodNode.exceptions.toArray(new String[0]));
            newNode.instructions = insnList;
            replacementNodes.add(newNode);
        }
        for (FieldNode fieldNode : fieldsToRemove) {
            classNode.fields.remove(fieldNode);
        }
        for (MethodNode methodNode : methodsToRemove) {
            classNode.methods.remove(methodNode);
            targetClass.methods.remove(methodNode);
        }
        targetClass.methods.addAll(replacementNodes);
    }
}

