/*
 * Decompiled with CFR 0.152.
 */
package xyz.bluspring.kilt.injections.client.renderer;

import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.minecraft.class_156;
import net.minecraft.class_1921;
import net.minecraft.class_2248;
import net.minecraft.class_2397;
import net.minecraft.class_2680;
import net.minecraft.class_3611;
import net.minecraft.class_4696;
import net.minecraft.class_6880;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.registries.ForgeRegistries;
import xyz.bluspring.kilt.client.KiltClient;
import xyz.bluspring.kilt.mixin.ItemBlockRenderTypesAccessor;
import xyz.bluspring.kilt.util.DefaultedHashMap;

public interface ItemBlockRenderTypesInjection {
    public static final ChunkRenderTypeSet CUTOUT_MIPPED = ChunkRenderTypeSet.of(class_1921.method_23579());
    public static final ChunkRenderTypeSet SOLID = ChunkRenderTypeSet.of(class_1921.method_23577());
    public static final Map<class_6880.class_6883<class_2248>, ChunkRenderTypeSet> BLOCK_RENDER_TYPES = (Map)class_156.method_654(new DefaultedHashMap(class_4696.field_21469.size(), 0.5f), it -> {
        it.setDefaultValue(SOLID);
        class_4696.field_21469.forEach((key, value) -> it.put(ForgeRegistries.BLOCKS.getDelegateOrThrow((class_2248)key), ChunkRenderTypeSet.of(value)));
    });
    public static final Map<class_6880.class_6883<class_3611>, class_1921> FLUID_RENDER_TYPES = (Map)class_156.method_654(new DefaultedHashMap(class_4696.field_21471.size(), 0.5f), it -> {
        it.setDefaultValue(class_1921.method_23577());
        class_4696.field_21471.forEach((key, value) -> it.put(ForgeRegistries.FLUIDS.getDelegateOrThrow((class_3611)key), value));
    });

    public static ChunkRenderTypeSet getRenderLayers(class_2680 state) {
        if (state.method_26204() instanceof class_2397) {
            return ItemBlockRenderTypesAccessor.isRenderCutout() ? CUTOUT_MIPPED : SOLID;
        }
        class_6880.class_6883<class_2248> delegate = ForgeRegistries.BLOCKS.getDelegateOrThrow(state.method_26204());
        if (!BLOCK_RENDER_TYPES.containsKey(delegate)) {
            BLOCK_RENDER_TYPES.put(delegate, ChunkRenderTypeSet.of(class_4696.method_23679((class_2680)state)));
        }
        return BLOCK_RENDER_TYPES.get(delegate);
    }

    public static void setRenderLayer(class_2248 block, class_1921 type) {
        ItemBlockRenderTypesInjection.setRenderLayer(block, ChunkRenderTypeSet.of(type));
    }

    public static void setRenderLayer(class_2248 block, Predicate<class_1921> predicate) {
        ItemBlockRenderTypesInjection.setRenderLayer(block, ChunkRenderTypeSet.of(class_1921.method_22720().stream().filter(predicate).collect(Collectors.toList())));
    }

    public static void setRenderLayer(class_2248 block, ChunkRenderTypeSet layers) {
        ItemBlockRenderTypesInjection.checkClientLoading();
        BlockRenderLayerMap.INSTANCE.putBlock(block, layers.asList().get(0));
        BLOCK_RENDER_TYPES.put(ForgeRegistries.BLOCKS.getDelegateOrThrow(block), layers);
    }

    public static void setRenderLayer(class_3611 fluid, class_1921 type) {
        ItemBlockRenderTypesInjection.checkClientLoading();
        BlockRenderLayerMap.INSTANCE.putFluid(fluid, type);
        FLUID_RENDER_TYPES.put(ForgeRegistries.FLUIDS.getDelegateOrThrow(fluid), type);
    }

    public static void checkClientLoading() {
        Preconditions.checkState((boolean)KiltClient.Companion.getHasInitialized(), (Object)"Render layers can only be set during client loading!");
    }
}

