/*
 * Decompiled with CFR 0.152.
 */
package xyz.bluspring.kilt.loader.remap.fixers;

import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.signature.SignatureReader;
import org.objectweb.asm.signature.SignatureVisitor;
import org.objectweb.asm.signature.SignatureWriter;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;
import xyz.bluspring.kilt.loader.remap.KiltRemapper;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bR,\u0010\f\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0004\u0012\u00020\u000b0\t8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lxyz/bluspring/kilt/loader/remap/fixers/ConditionalInterfaceInjectionFixer;", "", "<init>", "()V", "Lorg/objectweb/asm/tree/ClassNode;", "classNode", "", "fixClass", "(Lorg/objectweb/asm/tree/ClassNode;)V", "", "Lkotlin/Pair;", "", "forgeMethodLookup", "Ljava/util/Map;", "Kilt"})
public final class ConditionalInterfaceInjectionFixer {
    @NotNull
    public static final ConditionalInterfaceInjectionFixer INSTANCE = new ConditionalInterfaceInjectionFixer();
    @NotNull
    private static final Map<Pair<String, String>, String> forgeMethodLookup = MapsKt.mapOf((Pair)TuplesKt.to((Object)TuplesKt.to((Object)"getLightEmission", (Object)KiltRemapper.remapDescriptor$default(KiltRemapper.INSTANCE, "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/core/BlockPos;)I", false, false, 6, null)), (Object)"io/github/fabricators_of_create/porting_lib/block/LightEmissiveBlock"));

    private ConditionalInterfaceInjectionFixer() {
    }

    public final void fixClass(@NotNull ClassNode classNode) {
        Intrinsics.checkNotNullParameter((Object)classNode, (String)"classNode");
        for (MethodNode method : classNode.methods) {
            String className;
            if (!forgeMethodLookup.containsKey(TuplesKt.to((Object)method.name, (Object)method.desc))) continue;
            Intrinsics.checkNotNull((Object)forgeMethodLookup.get(TuplesKt.to((Object)method.name, (Object)method.desc)));
            List list = classNode.interfaces;
            if (list != null) {
                list.add(className);
            }
            if (classNode.signature == null) continue;
            SignatureReader reader = new SignatureReader(classNode.signature);
            SignatureWriter writer = new SignatureWriter();
            reader.accept((SignatureVisitor)writer);
            writer.visitClassType(className);
            classNode.signature = writer.toString();
        }
    }
}

