/*
 * Decompiled with CFR 0.152.
 */
package xyz.bluspring.kilt.mixin.compat.forgeconfigapiport;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import fuzs.forgeconfigapiport.impl.core.CommonAbstractions;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraftforge.common.ForgeConfigSpec;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={ForgeConfigSpec.Builder.class}, remap=false)
public abstract class ForgeConfigSpecMixin {
    @Unique
    private static final Joiner LINE_JOINER = Joiner.on((String)"\n");
    @Unique
    private static final Joiner DOT_JOINER = Joiner.on((String)".");
    @Unique
    private static final Splitter DOT_SPLITTER = Splitter.on((String)".");

    @Shadow
    public abstract <T> ForgeConfigSpec.ConfigValue<List<? extends T>> defineListAllowEmpty(List<String> var1, Supplier<List<? extends T>> var2, Predicate<Object> var3);

    public <T> ForgeConfigSpec.ConfigValue<List<? extends T>> defineListAllowEmpty(String path, List<? extends T> defaultValue, Predicate<Object> elementValidator) {
        return this.defineListAllowEmpty(ForgeConfigSpecMixin.split(path), defaultValue, elementValidator);
    }

    public <T> ForgeConfigSpec.ConfigValue<List<? extends T>> defineListAllowEmpty(String path, Supplier<List<? extends T>> defaultSupplier, Predicate<Object> elementValidator) {
        return this.defineListAllowEmpty(ForgeConfigSpecMixin.split(path), defaultSupplier, elementValidator);
    }

    public <T> ForgeConfigSpec.ConfigValue<List<? extends T>> defineListAllowEmpty(List<String> path, List<? extends T> defaultValue, Predicate<Object> elementValidator) {
        return this.defineListAllowEmpty(path, () -> defaultValue, elementValidator);
    }

    @Unique
    private static List<String> split(String path) {
        return Lists.newArrayList((Iterable)DOT_SPLITTER.split((CharSequence)path));
    }

    @Mixin(value={ForgeConfigSpec.ConfigValue.class}, remap=false)
    public static class ConfigValueMixin {
        @Redirect(method={"get"}, at=@At(value="INVOKE", target="Lfuzs/forgeconfigapiport/impl/core/CommonAbstractions;isDevelopmentEnvironment()Z"))
        private boolean kilt$disableDevEnvCrash(CommonAbstractions instance) {
            return false;
        }
    }
}

