/*
 * Decompiled with CFR 0.152.
 */
package xyz.bluspring.kilt.transform.nightconfig;

import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.ConfigFormat;
import com.electronwill.nightconfig.core.file.FileNotFoundAction;
import com.electronwill.nightconfig.core.io.ConfigParser;
import com.electronwill.nightconfig.core.io.ParsingException;
import com.electronwill.nightconfig.core.io.ParsingMode;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.lenni0451.classtransform.annotations.CInline;
import net.lenni0451.classtransform.annotations.CLocalVariable;
import net.lenni0451.classtransform.annotations.CShadow;
import net.lenni0451.classtransform.annotations.CTransformer;
import net.lenni0451.classtransform.annotations.injection.CWrapCatch;
import xyz.bluspring.kilt.util.KiltLoggers;

@CTransformer(value={ConfigParser.class})
public interface ConfigParserTransform<C extends Config> {
    @CShadow
    public ConfigFormat<C> getFormat();

    @CShadow
    public C parse(InputStream var1, Charset var2);

    @CShadow
    public void parse(InputStream var1, Config var2, ParsingMode var3, Charset var4);

    @CInline
    @CWrapCatch(value={"parse(Ljava/nio/file/Path;Lcom/electronwill/nightconfig/core/file/FileNotFoundAction;Ljava/nio/charset/Charset;)Lcom/electronwill/nightconfig/core/Config;"}, target="Lcom/electronwill/nightconfig/core/io/ConfigParser;parse(Ljava/io/InputStream;Ljava/nio/charset/Charset;)Lcom/electronwill/nightconfig/core/Config;")
    private C kilt$nightconfigfixes$catchAndRecreateConfig(ParsingException exception, @CLocalVariable(index=1) Path file, @CLocalVariable(index=2) FileNotFoundAction nefAction, @CLocalVariable(index=3) Charset charset) {
        block8: {
            try {
                C config;
                Files.delete(file);
                if (!nefAction.run(file, this.getFormat())) break block8;
                try (InputStream input = Files.newInputStream(file, new OpenOption[0]);){
                    config = this.parse(input, charset);
                }
                KiltLoggers.NIGHT_CONFIG_FIXES.warn("Configuration file {} could not be parsed. Correcting.", (Object)file.toAbsolutePath());
                return config;
            }
            catch (Throwable t) {
                exception.addSuppressed(t);
            }
        }
        throw exception;
    }

    @CInline
    @CWrapCatch(value={"parse(Ljava/nio/file/Path;Lcom/electronwill/nightconfig/core/Config;Lcom/electronwill/nightconfig/core/io/ParsingMode;Lcom/electronwill/nightconfig/core/file/FileNotFoundAction;Ljava/nio/charset/Charset;)V"}, target="Lcom/electronwill/nightconfig/core/io/ConfigParser;parse(Ljava/io/InputStream;Lcom/electronwill/nightconfig/core/Config;Lcom/electronwill/nightconfig/core/io/ParsingMode;Ljava/nio/charset/Charset;)V")
    private void kilt$nightconfigfixes$catchAndRecreateConfig(ParsingException exception, @CLocalVariable(index=1) Path file, @CLocalVariable(index=2) Config destination, @CLocalVariable(index=3) ParsingMode parsingMode, @CLocalVariable(index=4) FileNotFoundAction nefAction, @CLocalVariable(index=5) Charset charset) {
        block8: {
            try {
                Files.delete(file);
                if (!nefAction.run(file, this.getFormat())) break block8;
                try (InputStream input = Files.newInputStream(file, new OpenOption[0]);){
                    this.parse(input, destination, parsingMode, charset);
                }
                KiltLoggers.NIGHT_CONFIG_FIXES.warn("Configuration file {} could not be parsed. Correcting.", (Object)file.toAbsolutePath());
                return;
            }
            catch (Throwable t) {
                exception.addSuppressed(t);
            }
        }
        throw exception;
    }
}

