/*
 * Decompiled with CFR 0.152.
 */
package com.nocticraft.woostorelink;

import com.google.gson.Gson;
import com.nocticraft.woostorelink.commands.WSLCommand;
import com.nocticraft.woostorelink.delivery.DeliveryService;
import com.nocticraft.woostorelink.utils.AchievementManager;
import com.nocticraft.woostorelink.utils.Delivery;
import com.nocticraft.woostorelink.utils.DeliveryFetcher;
import com.nocticraft.woostorelink.utils.LanguageLoader;
import com.nocticraft.woostorelink.utils.LinkManager;
import com.nocticraft.woostorelink.utils.StartupDisplay;
import com.nocticraft.woostorelink.utils.menu.MenuRegistry;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class WooStoreLink
extends JavaPlugin
implements Listener {
    private LanguageLoader lang;
    private String currentLangCode = "en";
    private DeliveryFetcher fetcher;
    private final Set<Integer> recentlyDelivered = new HashSet<Integer>();
    private final LinkManager linkManager = new LinkManager(this);
    private AchievementManager achievementManager;
    private DeliveryService deliveryService;
    private final Gson gson = new Gson();

    public LinkManager getLinkManager() {
        return this.linkManager;
    }

    public AchievementManager getAchievementManager() {
        return this.achievementManager;
    }

    public DeliveryService getDeliveryService() {
        return this.deliveryService;
    }

    public Gson getGson() {
        return this.gson;
    }

    public void onEnable() {
        this.saveDefaultConfig();
        this.loadLanguage();
        this.cleanOldLogs();
        this.fetcher = new DeliveryFetcher(this);
        this.getLogger().info("Loaded language: " + this.currentLangCode + " | Example: " + this.lang.get("plugin-enabled"));
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getCommand("wsl").setExecutor((CommandExecutor)new WSLCommand(this));
        StartupDisplay.show(this, this.lang);
        int minutes = this.getConfig().getInt("check-interval-minutes", 1);
        long ticks = (long)minutes * 60L * 20L;
        Bukkit.getScheduler().runTaskTimer((Plugin)this, () -> {
            this.logDelivery("[Auto] " + this.lang.getOrDefault("auto-check", "Checking pending deliveries for online players..."));
            for (Player player : Bukkit.getOnlinePlayers()) {
                this.processPendingDeliveries(player);
            }
        }, 20L, ticks);
        this.achievementManager = new AchievementManager(this, this.lang);
        this.getServer().getPluginManager().registerEvents((Listener)new MenuRegistry(), (Plugin)this);
        this.deliveryService = new DeliveryService(this);
    }

    public void loadLanguage() {
        this.currentLangCode = this.getConfig().getString("language", "en");
        this.lang = new LanguageLoader(this);
        this.lang.load(this.currentLangCode);
    }

    public void onDisable() {
        Bukkit.getConsoleSender().sendMessage("\u00a7c\u2716 WooStoreLink has been disabled.");
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        this.processPendingDeliveries(event.getPlayer());
        if (this.deliveryService != null) {
            this.deliveryService.tryDeliverPlayer(event.getPlayer());
        }
    }

    public void processPendingDeliveries(Player player) {
        List<Delivery> deliveries = this.fetcher.fetchDeliveries(player.getName());
        if (deliveries.isEmpty()) {
            return;
        }
        ConfigurationSection products = this.getConfig().getConfigurationSection("products");
        if (products == null) {
            this.logDelivery("[Warn] " + this.lang.getOrDefault("products-section-missing", "Section 'products' not found in config.yml."));
            if (player.isOp()) {
                player.sendMessage("\u00a7c" + this.lang.getOrDefault("products-section-missing", "Section 'products' not found in config.yml."));
            }
            return;
        }
        HashSet<Integer> idsToMark = new HashSet<Integer>();
        int deliveredTotal = 0;
        int queuedTotal = 0;
        List toProcess = deliveries.stream().filter(d -> !this.recentlyDelivered.contains(d.getId())).collect(Collectors.toList());
        for (Delivery d2 : toProcess) {
            String productName = d2.getItem().toLowerCase();
            if (!products.contains(productName)) {
                this.logDelivery("[Error] " + this.lang.getOrDefault("product-not-configured", "Product not configured:") + " " + productName);
                if (!player.isOp()) continue;
                player.sendMessage("\u00a7c" + this.lang.getOrDefault("product-not-configured-player", "Product") + " \u00a7e" + productName + "\u00a7c " + this.lang.getOrDefault("product-not-configured-player-2", "is not configured on this server."));
                continue;
            }
            ConfigurationSection productConfig = products.getConfigurationSection(productName);
            if (productConfig == null) continue;
            try {
                int amount = d2.getAmount();
                int deliveredCountThisDelivery = 0;
                int queuedCountThisDelivery = 0;
                if (productConfig.contains("type")) {
                    String type = productConfig.getString("type");
                    String value = productConfig.getString("value");
                    if ("item".equalsIgnoreCase(type)) {
                        Material mat = Material.matchMaterial((String)value);
                        if (mat == null) {
                            this.logDelivery("[Error] Unknown material: " + value);
                        } else {
                            ItemStack is = new ItemStack(mat, amount);
                            if (this.getDeliveryService().tryDeliverNow(player, is)) {
                                ++deliveredCountThisDelivery;
                            } else {
                                ++queuedCountThisDelivery;
                            }
                        }
                    } else if ("command".equalsIgnoreCase(type)) {
                        String command = value.replace("{player}", player.getName());
                        Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)command);
                    } else {
                        this.logDelivery("[Warn] Unknown product type: " + type + " (product: " + productName + ")");
                    }
                } else {
                    if (productConfig.contains("items")) {
                        List items = productConfig.getStringList("items");
                        for (String entryLine : items) {
                            String[] split = entryLine.split(" ");
                            String item = split[0];
                            int amt = split.length > 1 ? Integer.parseInt(split[1]) : 1;
                            Material mat = Material.matchMaterial((String)item);
                            if (mat == null) {
                                this.logDelivery("[Error] Unknown material: " + item);
                                continue;
                            }
                            ItemStack is = new ItemStack(mat, amt * amount);
                            if (this.getDeliveryService().tryDeliverNow(player, is)) {
                                ++deliveredCountThisDelivery;
                                continue;
                            }
                            ++queuedCountThisDelivery;
                        }
                    }
                    if (productConfig.contains("commands")) {
                        List commands = productConfig.getStringList("commands");
                        for (String cmd : commands) {
                            Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)cmd.replace("{player}", player.getName()));
                        }
                    }
                }
                if (this.achievementManager != null && this.achievementManager.isEnabled()) {
                    this.achievementManager.addPurchaseAndCheck(player);
                }
                idsToMark.add(d2.getId());
                this.recentlyDelivered.add(d2.getId());
                if (deliveredCountThisDelivery > 0) {
                    this.logDelivery("[OK] Delivered now to " + player.getName() + ": " + productName + " \u00d7" + deliveredCountThisDelivery);
                }
                if (queuedCountThisDelivery > 0) {
                    this.logDelivery("[QUEUE] Queued for " + player.getName() + ": " + productName + " \u00d7" + queuedCountThisDelivery + " (inventory full)");
                }
                deliveredTotal += deliveredCountThisDelivery;
                if (deliveredCountThisDelivery == 0 && queuedCountThisDelivery == 0 && productConfig.contains("type") && "command".equalsIgnoreCase(productConfig.getString("type"))) {
                    ++deliveredTotal;
                }
                queuedTotal += queuedCountThisDelivery;
            }
            catch (Exception e) {
                this.logDelivery("[Error] Delivering to " + player.getName() + ": " + e.getMessage());
            }
        }
        if (!idsToMark.isEmpty()) {
            this.fetcher.markAsDelivered(new ArrayList<Integer>(idsToMark));
        }
        Bukkit.getScheduler().runTaskLater((Plugin)this, () -> idsToMark.forEach(this.recentlyDelivered::remove), 200L);
        if (deliveredTotal > 0) {
            player.sendMessage(this.color(this.lang.getOrDefault("player-delivered-count", "You received %count% item(s) from the store.").replace("%count%", String.valueOf(deliveredTotal))));
        }
        if (queuedTotal > 0) {
            player.sendMessage(this.color(this.lang.getOrDefault("player-queued-count", "%count% item(s) were queued. Free up space, or open /wsl menu \u2192 Deliveries to claim.").replace("%count%", String.valueOf(queuedTotal))));
        }
        if (deliveredTotal > 0 || queuedTotal > 0) {
            this.linkManager.setLastSync(player.getName(), System.currentTimeMillis() / 1000L);
        }
    }

    public void logDelivery(String message) {
        String date = new SimpleDateFormat("yyyy-MM-dd").format(new Date());
        File logsDir = new File(this.getDataFolder(), "transaction-logs");
        File logFile = new File(logsDir, date + ".log");
        try {
            if (!logsDir.exists()) {
                logsDir.mkdirs();
            }
            if (!logFile.exists()) {
                logFile.createNewFile();
            }
            try (FileWriter fw = new FileWriter(logFile, true);){
                String time = new SimpleDateFormat("HH:mm:ss").format(new Date());
                fw.write("[" + time + "] " + message + "\n");
            }
        }
        catch (IOException e) {
            this.getLogger().warning("[Error] " + this.lang.getOrDefault("log-error", "Failed to write delivery log:") + " " + e.getMessage());
        }
    }

    public void cleanOldLogs() {
        int days = this.getConfig().getInt("log-retention-days", 30);
        File logsDir = new File(this.getDataFolder(), "transaction-logs");
        if (!logsDir.exists()) {
            return;
        }
        File[] files = logsDir.listFiles();
        if (files == null) {
            return;
        }
        long now = System.currentTimeMillis();
        long cutoff = now - (long)days * 24L * 60L * 60L * 1000L;
        for (File file : files) {
            if (!file.isFile() || !file.getName().endsWith(".log") || file.lastModified() >= cutoff || !file.delete()) continue;
            this.getLogger().info("[GC] " + this.lang.getOrDefault("log-deleted", "Old log removed:") + " " + file.getName());
        }
    }

    public LanguageLoader getLang() {
        return this.lang;
    }

    private String color(String s) {
        return s.replace("&", "\u00a7");
    }
}

