/*
 * Decompiled with CFR 0.152.
 */
package com.nocticraft.woostorelink.commands;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.nocticraft.woostorelink.WooStoreLink;
import com.nocticraft.woostorelink.delivery.DeliveriesMenu;
import com.nocticraft.woostorelink.utils.LanguageLoader;
import com.nocticraft.woostorelink.utils.menu.AchievementsMenu;
import com.nocticraft.woostorelink.utils.menu.HelpMenu;
import com.nocticraft.woostorelink.utils.menu.ProfileMenu;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class WSLCommand
implements CommandExecutor {
    private final WooStoreLink plugin;

    public WSLCommand(WooStoreLink plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 0 || args[0].equalsIgnoreCase("menu")) {
            if (!(sender instanceof Player)) {
                sender.sendMessage("\u00a7cOnly players.");
                return true;
            }
            Player p = (Player)sender;
            new ProfileMenu(this.plugin, p).open();
            return true;
        }
        if (args[0].equalsIgnoreCase("help")) {
            if (!(sender instanceof Player)) {
                this.sendHelp(sender);
                return true;
            }
            Player p = (Player)sender;
            new HelpMenu(this.plugin, p).open();
            return true;
        }
        if (args[0].equalsIgnoreCase("deliveries")) {
            if (!(sender instanceof Player)) {
                sender.sendMessage("\u00a7cOnly players.");
                return true;
            }
            Player p = (Player)sender;
            new DeliveriesMenu(this.plugin, p, this.plugin.getDeliveryService().getQueue(p.getUniqueId())).open();
            return true;
        }
        if (args[0].equalsIgnoreCase("achievements") && sender instanceof Player) {
            Player p = (Player)sender;
            new AchievementsMenu(this.plugin, p).open();
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "reload": {
                if (!sender.hasPermission("woostorelink.reload")) {
                    sender.sendMessage("\u00a7cYou do not have permission to use this command.");
                    return true;
                }
                this.plugin.reloadConfig();
                this.plugin.loadLanguage();
                sender.sendMessage("\u00a7a\u2714 Configuration and language reloaded.");
                break;
            }
            case "check": {
                if (!(sender instanceof Player) || !sender.hasPermission("woostorelink.check")) {
                    sender.sendMessage("\u00a7cYou do not have permission or must be a player.");
                    return true;
                }
                this.plugin.processPendingDeliveries((Player)sender);
                sender.sendMessage("\u00a7a\u2714 Checked your pending deliveries.");
                break;
            }
            case "checkplayer": {
                if (!sender.hasPermission("woostorelink.check.others")) {
                    sender.sendMessage("\u00a7cYou do not have permission to use this command.");
                    return true;
                }
                if (args.length < 2) {
                    sender.sendMessage("\u00a7cUsage: /wsl checkplayer <player>");
                    break;
                }
                Player target = Bukkit.getPlayerExact((String)args[1]);
                if (target != null) {
                    this.plugin.processPendingDeliveries(target);
                    sender.sendMessage("\u00a7a\u2714 Checked deliveries for " + target.getName());
                    break;
                }
                sender.sendMessage("\u00a7cPlayer not found.");
                break;
            }
            case "status": {
                if (!sender.hasPermission("woostorelink.status")) {
                    sender.sendMessage("\u00a7cYou do not have permission to use this command.");
                    return true;
                }
                String tokenCfg = this.plugin.getConfig().getString("api-token");
                String domain = this.plugin.getConfig().getString("api-domain");
                boolean configured = tokenCfg != null && !tokenCfg.isEmpty() && domain != null && !domain.isEmpty();
                sender.sendMessage("\u00a7eREST API: " + (configured ? "\u00a7aConfigured \u2714" : "\u00a7cMissing config \u2718"));
                if (sender instanceof Player) {
                    Player player = (Player)sender;
                    String name = player.getName();
                    long lastSync = this.plugin.getLinkManager().getLastSync(name);
                    long nextSync = lastSync + 3600L;
                    sender.sendMessage("\u00a77Last Sync: \u00a7f" + (lastSync == 0L ? "Never" : this.formatTime(lastSync)));
                    sender.sendMessage("\u00a77Next Check: \u00a7f" + (lastSync == 0L ? "N/A" : this.formatTime(nextSync)));
                    if (player.isOp()) {
                        String token = this.plugin.getConfig().getString("api-token");
                        sender.sendMessage("\u00a77Token: \u00a7f" + (token != null ? token : "Not set"));
                    }
                }
                return true;
            }
            case "wp-link": {
                if (!(sender instanceof Player)) {
                    sender.sendMessage("\u00a7cOnly players can use this command.");
                    return true;
                }
                if (!sender.hasPermission("woostorelink.wp-link")) {
                    sender.sendMessage("\u00a7cYou do not have permission to use this command.");
                    return true;
                }
                if (args.length < 2) {
                    sender.sendMessage("\u00a7cUsage: /wsl wp-link <your-email>");
                    return true;
                }
                this.requestLink((Player)sender, args[1]);
                return true;
            }
            case "wp-verify": {
                if (!(sender instanceof Player)) {
                    sender.sendMessage("\u00a7cOnly players can use this command.");
                    return true;
                }
                if (!sender.hasPermission("woostorelink.wp-verify")) {
                    sender.sendMessage("\u00a7cYou do not have permission to use this command.");
                    return true;
                }
                if (args.length < 2) {
                    sender.sendMessage("\u00a7cUsage: /wsl wp-verify <code>");
                    return true;
                }
                this.verifyCode((Player)sender, args[1]);
                return true;
            }
            case "achievements": 
            case "achievement": 
            case "ach": {
                this.handleAchievements(sender, args);
                return true;
            }
            default: {
                sender.sendMessage("\u00a7cUnknown subcommand. Type \u00a7e/wsl help \u00a7cfor help.");
            }
        }
        return true;
    }

    private void sendHelp(CommandSender sender) {
    }

    private String extractApiErrorReason(String body) {
        if (body == null || body.isBlank()) {
            return "Unknown error";
        }
        try {
            JsonElement el = JsonParser.parseString((String)body);
            if (el.isJsonObject()) {
                JsonObject obj = el.getAsJsonObject();
                if (obj.has("error") && !obj.get("error").isJsonNull()) {
                    return obj.get("error").getAsString();
                }
                if (obj.has("message") && !obj.get("message").isJsonNull()) {
                    return obj.get("message").getAsString();
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return body;
    }

    private void requestLink(Player player, String rawEmail) {
        LanguageLoader lang = this.plugin.getLang();
        String email = rawEmail == null ? "" : rawEmail.trim().toLowerCase();
        String domain = this.plugin.getConfig().getString("api-domain");
        String token = this.plugin.getConfig().getString("api-token");
        if (domain == null || domain.isEmpty() || token == null || token.isEmpty()) {
            player.sendMessage(this.color(lang.getOrDefault("link-error", "&c\u2716 Failed: %reason%").replace("%reason%", "Missing api-domain/api-token in config.yml")));
            this.plugin.getLogger().warning("[wp-link] Missing api-domain/api-token in config.yml");
            return;
        }
        this.plugin.getLinkManager().setPendingEmail(player.getName(), email);
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            block32: {
                HttpURLConnection conn = null;
                try {
                    String responseBody;
                    String apiUrl = domain + "/wp-json/storelinkformc/v1/request-link";
                    String payload = "email=" + URLEncoder.encode(email, StandardCharsets.UTF_8.name()) + "&player=" + URLEncoder.encode(player.getName(), StandardCharsets.UTF_8.name()) + "&token=" + URLEncoder.encode(token, StandardCharsets.UTF_8.name());
                    this.plugin.getLogger().info("[wp-link] POST " + apiUrl);
                    this.plugin.getLogger().info("[wp-link] Payload: " + payload);
                    conn = (HttpURLConnection)new URL(apiUrl).openConnection();
                    conn.setRequestMethod("POST");
                    conn.setDoOutput(true);
                    conn.setConnectTimeout(10000);
                    conn.setReadTimeout(15000);
                    conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
                    conn.setRequestProperty("Accept", "application/json");
                    conn.setRequestProperty("User-Agent", "WooStoreLink/0.8.0 (Minecraft)");
                    conn.setRequestProperty("X-StoreLink-Token", token);
                    try (OutputStream os = conn.getOutputStream();){
                        os.write(payload.getBytes(StandardCharsets.UTF_8));
                    }
                    int responseCode = conn.getResponseCode();
                    try (InputStream is = responseCode >= 200 && responseCode < 300 ? conn.getInputStream() : conn.getErrorStream();){
                        responseBody = is == null ? "" : new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
                    }
                    this.plugin.getLogger().info("[wp-link] HTTP " + responseCode + ": " + responseBody);
                    if (responseCode != 200) {
                        String reason = this.extractApiErrorReason(responseBody);
                        player.sendMessage(this.color(lang.getOrDefault("link-error", "&c\u2716 Failed: %reason%").replace("%reason%", reason)));
                        return;
                    }
                    boolean success = true;
                    String message = "Verification code sent.";
                    try {
                        JsonElement el = JsonParser.parseString((String)responseBody);
                        if (el.isJsonObject()) {
                            JsonObject obj = el.getAsJsonObject();
                            if (obj.has("success")) {
                                success = obj.get("success").getAsBoolean();
                            }
                            if (obj.has("message") && !obj.get("message").isJsonNull()) {
                                message = obj.get("message").getAsString();
                            }
                        }
                    }
                    catch (Throwable el) {
                        // empty catch block
                    }
                    if (!success) {
                        String reason = this.extractApiErrorReason(responseBody);
                        player.sendMessage(this.color(lang.getOrDefault("link-error", "&c\u2716 Failed: %reason%").replace("%reason%", reason)));
                        return;
                    }
                    player.sendMessage(this.color(lang.getOrDefault("link-started", "&a\u2714 Verification code sent to your email.")));
                    boolean debugShow = this.plugin.getConfig().getBoolean("linking.debug-show-code", false);
                    if (!debugShow || !player.isOp()) break block32;
                    try {
                        JsonElement el = JsonParser.parseString((String)responseBody);
                        if (el.isJsonObject() && el.getAsJsonObject().has("code")) {
                            String code = el.getAsJsonObject().get("code").getAsString();
                            player.sendMessage(this.color("&7[debug] Verification code: &e" + code));
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                catch (Exception e) {
                    this.plugin.getLogger().warning("[wp-link] Exception: " + e.getClass().getSimpleName() + ": " + e.getMessage());
                    e.printStackTrace();
                    player.sendMessage(this.color(lang.getOrDefault("link-error", "&c\u2716 Failed: %reason%").replace("%reason%", e.getMessage() != null ? e.getMessage() : "unknown error")));
                }
                finally {
                    if (conn != null) {
                        conn.disconnect();
                    }
                }
            }
        });
    }

    private void verifyCode(Player player, String code) {
        LanguageLoader lang = this.plugin.getLang();
        String email = this.plugin.getLinkManager().getPendingEmail(player.getName());
        if (email == null) {
            player.sendMessage(this.color(lang.getOrDefault("link-error", "&c\u2716 Failed: %reason%").replace("%reason%", "You must link an email first using /wsl wp-link <email>")));
            return;
        }
        String domain = this.plugin.getConfig().getString("api-domain");
        String token = this.plugin.getConfig().getString("api-token");
        if (domain == null || domain.isEmpty() || token == null || token.isEmpty()) {
            player.sendMessage(this.color(lang.getOrDefault("verify-error", "&c\u2716 Failed: %reason%").replace("%reason%", "Missing api-domain/api-token in config.yml")));
            this.plugin.getLogger().warning("[wp-verify] Missing api-domain/api-token in config.yml");
            return;
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            HttpURLConnection conn = null;
            try {
                String responseBody;
                String apiUrl = domain + "/wp-json/storelinkformc/v1/verify-link";
                String payload = "email=" + URLEncoder.encode(email, "UTF-8") + "&code=" + URLEncoder.encode(code, "UTF-8") + "&token=" + URLEncoder.encode(token, "UTF-8");
                this.plugin.getLogger().info("[wp-verify] POST " + apiUrl + " email=" + email + " player=" + player.getName());
                conn = (HttpURLConnection)new URL(apiUrl).openConnection();
                conn.setRequestMethod("POST");
                conn.setDoOutput(true);
                conn.setConnectTimeout(10000);
                conn.setReadTimeout(15000);
                conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                try (OutputStream os = conn.getOutputStream();){
                    os.write(payload.getBytes(StandardCharsets.UTF_8));
                }
                int responseCode = conn.getResponseCode();
                try (InputStream is = responseCode >= 200 && responseCode < 300 ? conn.getInputStream() : conn.getErrorStream();){
                    responseBody = is != null ? new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n")) : "";
                }
                if (responseCode == 200) {
                    this.plugin.getLinkManager().clear(player.getName());
                    this.plugin.getLinkManager().setLinked(player.getName(), true);
                    player.sendMessage(this.color(lang.getOrDefault("verify-success", "&a\u2714 Your account has been linked!")));
                    this.plugin.getLogger().info("[wp-verify] 200 OK: " + responseBody);
                } else {
                    String reason = this.extractApiErrorReason(responseBody);
                    player.sendMessage(this.color(lang.getOrDefault("verify-error", "&c\u2716 Failed: %reason%").replace("%reason%", reason)));
                    this.plugin.getLogger().warning("[wp-verify] HTTP " + responseCode + ": " + responseBody);
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("[wp-verify] Exception: " + e.getClass().getSimpleName() + ": " + e.getMessage());
                e.printStackTrace();
                player.sendMessage(this.color(lang.getOrDefault("verify-error", "&c\u2716 Failed: %reason%").replace("%reason%", e.getMessage() != null ? e.getMessage() : "unknown error")));
            }
            finally {
                if (conn != null) {
                    conn.disconnect();
                }
            }
        });
    }

    private String formatTime(long unix) {
        Instant instant = Instant.ofEpochSecond(unix);
        ZonedDateTime zdt = instant.atZone(ZoneId.systemDefault());
        return DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").format(zdt);
    }

    private void handleAchievements(CommandSender sender, String[] args) {
    }

    private String color(String s) {
        return s.replace("&", "\u00a7");
    }
}

