/*
 * Decompiled with CFR 0.152.
 */
package com.nocticraft.woostorelink.delivery;

import com.nocticraft.woostorelink.WooStoreLink;
import com.nocticraft.woostorelink.utils.menu.ItemBuilder;
import com.nocticraft.woostorelink.utils.menu.Menu;
import com.nocticraft.woostorelink.utils.menu.ProfileMenu;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class DeliveriesMenu
extends Menu {
    private final WooStoreLink plugin;
    private final List<ItemStack> data;
    private int page = 0;

    public DeliveriesMenu(WooStoreLink plugin, Player viewer, List<ItemStack> data) {
        super(viewer);
        this.plugin = plugin;
        this.data = data;
        this.rows = 6;
        this.refreshData();
    }

    @Override
    public String title() {
        return this.color(this.plugin.getLang().getOrDefault("menu-deliveries-title", "&6Pending deliveries"));
    }

    @Override
    public void draw() {
        this.refreshData();
        this.inv.clear();
        String backName = this.color(this.plugin.getLang().getOrDefault("menu-back", "&6Back"));
        String backLore = this.color(this.plugin.getLang().getOrDefault("menu-back-lore", "&7Return to Profile"));
        String exitName = this.color(this.plugin.getLang().getOrDefault("menu-exit", "&cExit"));
        String exitLore = this.color(this.plugin.getLang().getOrDefault("menu-exit-lore", "&7Close"));
        this.inv.setItem(0, ItemBuilder.icon(Material.ARROW, backName, List.of(backLore)));
        this.inv.setItem(8, ItemBuilder.icon(Material.BARRIER, exitName, List.of(exitLore)));
        int start = this.page * 28;
        for (int i = 0; i < 28 && start + i < this.data.size(); ++i) {
            ItemStack icon = this.data.get(start + i).clone();
            ItemMeta meta = icon.getItemMeta();
            String lore = this.plugin.getLang().getOrDefault("deliveries-click-to-claim", "&e&oClick to claim");
            meta.setLore(List.of(this.color(lore)));
            icon.setItemMeta(meta);
            this.inv.setItem(this.slotForIndex(i), icon);
        }
        String prev = this.color(this.plugin.getLang().getOrDefault("menu-prev", "&6Prev"));
        String next = this.color(this.plugin.getLang().getOrDefault("menu-next", "&6Next"));
        this.inv.setItem(45, ItemBuilder.icon(Material.ARROW, prev, List.of()));
        this.inv.setItem(53, ItemBuilder.icon(Material.ARROW, next, List.of()));
    }

    private int slotForIndex(int i) {
        int row = i / 7;
        int col = i % 7;
        return (row + 1) * 9 + (col + 1);
    }

    @Override
    public void onClick(InventoryClickEvent e) {
        e.setCancelled(true);
        if (e.getSlot() == 0) {
            new ProfileMenu(this.plugin, this.viewer).open();
            return;
        }
        if (e.getSlot() == 8) {
            this.viewer.closeInventory();
            return;
        }
        if (e.getSlot() == 45 && this.page > 0) {
            --this.page;
            this.refreshData();
            this.draw();
            return;
        }
        if (e.getSlot() == 53 && (this.page + 1) * 28 < this.data.size()) {
            ++this.page;
            this.refreshData();
            this.draw();
            return;
        }
        int row = e.getSlot() / 9 - 1;
        int col = e.getSlot() % 9 - 1;
        if (row < 0 || row > 3 || col < 0 || col > 6) {
            return;
        }
        int index = this.page * 28 + (row * 7 + col);
        if (index < 0 || index >= this.data.size()) {
            return;
        }
        if (this.plugin.getDeliveryService().claimFromQueue(this.viewer, index)) {
            this.refreshData();
            this.draw();
        }
    }

    private void refreshData() {
        this.data.clear();
        this.data.addAll(this.plugin.getDeliveryService().getQueue(this.viewer.getUniqueId()));
        int maxPage = (int)Math.ceil((double)Math.max(1, this.data.size()) / 28.0) - 1;
        if (this.page > maxPage) {
            this.page = Math.max(0, maxPage);
        }
    }
}

