/*
 * Decompiled with CFR 0.152.
 */
package com.nocticraft.woostorelink.delivery;

import com.nocticraft.woostorelink.WooStoreLink;
import com.nocticraft.woostorelink.utils.LanguageLoader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.io.BukkitObjectInputStream;
import org.bukkit.util.io.BukkitObjectOutputStream;

public class DeliveryService {
    private final WooStoreLink plugin;
    private final Map<UUID, List<ItemStack>> queue = new HashMap<UUID, List<ItemStack>>();
    private final File store;

    public DeliveryService(WooStoreLink plugin) {
        this.plugin = plugin;
        this.store = new File(plugin.getDataFolder(), "pending_deliveries.dat");
        this.load();
        Bukkit.getScheduler().runTaskTimer((Plugin)plugin, this::tryDeliverAllOnline, 200L, 400L);
    }

    public int countPending(UUID id) {
        return this.queue.getOrDefault(id, List.of()).size();
    }

    public List<ItemStack> getQueue(UUID id) {
        return new ArrayList<ItemStack>(this.queue.getOrDefault(id, List.of()));
    }

    public boolean tryDeliverNow(Player p, ItemStack item) {
        if (this.hasSpace(p)) {
            p.getInventory().addItem(new ItemStack[]{item});
            return true;
        }
        this.enqueue(p.getUniqueId(), item);
        LanguageLoader lang = this.plugin.getLang();
        p.sendMessage(this.color(lang.getOrDefault("queue-added-1", "&eYour inventory is full. &7The item has been added to your delivery queue.")));
        p.sendMessage(this.color(lang.getOrDefault("queue-added-2", "&7Please free up space or open &e/wsl menu &7\u2192 Deliveries to claim it.")));
        return false;
    }

    public boolean claimFromQueue(Player p, int index) {
        List<ItemStack> list = this.queue.get(p.getUniqueId());
        if (list == null || index < 0 || index >= list.size()) {
            return false;
        }
        ItemStack is = list.get(index);
        if (this.hasSpace(p)) {
            p.getInventory().addItem(new ItemStack[]{is});
            list.remove(index);
            if (list.isEmpty()) {
                this.queue.remove(p.getUniqueId());
            }
            this.save();
            String itemName = is.getType().name().toLowerCase().replace("_", " ");
            LanguageLoader lang = this.plugin.getLang();
            p.sendMessage(this.color(lang.getOrDefault("queue-claim-success", "&a\u2705 You have successfully claimed your queued delivery: &e%item%&a.").replace("%item%", itemName)));
            return true;
        }
        LanguageLoader lang = this.plugin.getLang();
        p.sendMessage(this.color(lang.getOrDefault("queue-claim-full", "&eYour inventory is still full. &7Free up space, then try again from &e/wsl menu &7\u2192 Deliveries.")));
        return false;
    }

    public void tryDeliverPlayer(Player p) {
        List<ItemStack> list = this.queue.get(p.getUniqueId());
        if (list == null || list.isEmpty()) {
            return;
        }
        Iterator<ItemStack> it = list.iterator();
        while (it.hasNext()) {
            ItemStack is = it.next();
            if (!this.hasSpace(p)) break;
            p.getInventory().addItem(new ItemStack[]{is});
            it.remove();
        }
        if (list.isEmpty()) {
            this.queue.remove(p.getUniqueId());
        }
        this.save();
    }

    private boolean hasSpace(Player p) {
        return p.getInventory().firstEmpty() != -1;
    }

    private void enqueue(UUID id, ItemStack is) {
        this.queue.computeIfAbsent(id, k -> new ArrayList()).add(is);
        this.save();
    }

    private void tryDeliverAllOnline() {
        for (Player p : Bukkit.getOnlinePlayers()) {
            this.tryDeliverPlayer(p);
        }
    }

    private String color(String s) {
        return s.replace("&", "\u00a7");
    }

    private void save() {
        try {
            this.store.getParentFile().mkdirs();
            try (BukkitObjectOutputStream oos = new BukkitObjectOutputStream((OutputStream)new FileOutputStream(this.store));){
                oos.writeInt(this.queue.size());
                for (Map.Entry<UUID, List<ItemStack>> e : this.queue.entrySet()) {
                    oos.writeObject(e.getKey());
                    oos.writeInt(e.getValue().size());
                    for (ItemStack is : e.getValue()) {
                        oos.writeObject(is);
                    }
                }
            }
        }
        catch (IOException ex) {
            this.plugin.getLogger().warning("Failed to save deliveries: " + ex.getMessage());
        }
    }

    private void load() {
        if (!this.store.exists()) {
            return;
        }
        try (BukkitObjectInputStream ois = new BukkitObjectInputStream((InputStream)new FileInputStream(this.store));){
            int size = ois.readInt();
            for (int i = 0; i < size; ++i) {
                UUID id = (UUID)ois.readObject();
                int n = ois.readInt();
                ArrayList<ItemStack> list = new ArrayList<ItemStack>();
                for (int j = 0; j < n; ++j) {
                    list.add((ItemStack)ois.readObject());
                }
                this.queue.put(id, list);
            }
        }
        catch (Exception ex) {
            this.plugin.getLogger().warning("Failed to load deliveries: " + ex.getMessage());
        }
    }
}

