/*
 * Decompiled with CFR 0.152.
 */
package com.nocticraft.woostorelink.delivery;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Base64;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.io.BukkitObjectInputStream;
import org.bukkit.util.io.BukkitObjectOutputStream;

public record QueuedDelivery(String itemB64, String reason) {
    public static QueuedDelivery fromItem(ItemStack item, String reason) {
        return new QueuedDelivery(QueuedDelivery.serialize(item), reason);
    }

    public ItemStack toItem() {
        return QueuedDelivery.deserialize(this.itemB64);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static String serialize(ItemStack item) {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            String string;
            try (BukkitObjectOutputStream oos = new BukkitObjectOutputStream((OutputStream)baos);){
                oos.writeObject((Object)item);
                string = Base64.getEncoder().encodeToString(baos.toByteArray());
            }
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static ItemStack deserialize(String b64) {
        try (ByteArrayInputStream bais = new ByteArrayInputStream(Base64.getDecoder().decode(b64));){
            ItemStack itemStack;
            try (BukkitObjectInputStream ois = new BukkitObjectInputStream((InputStream)bais);){
                itemStack = (ItemStack)ois.readObject();
            }
            return itemStack;
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

