/*
 * Decompiled with CFR 0.152.
 */
package com.nocticraft.woostorelink.utils;

import com.nocticraft.woostorelink.WooStoreLink;
import com.nocticraft.woostorelink.utils.Achievement;
import com.nocticraft.woostorelink.utils.LanguageLoader;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class AchievementManager {
    private final WooStoreLink plugin;
    private final LanguageLoader lang;
    private boolean enabled;
    private String counterName;
    private final Map<String, Achievement> achievements = new LinkedHashMap<String, Achievement>();
    private File dataFile;
    private FileConfiguration data;

    public AchievementManager(WooStoreLink plugin, LanguageLoader lang) {
        this.plugin = plugin;
        this.lang = lang;
        this.loadConfig();
        this.loadData();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void addPurchaseAndCheck(Player player) {
        if (!this.enabled) {
            return;
        }
        UUID uuid = player.getUniqueId();
        int purchases = this.getPurchases(uuid) + 1;
        this.setPurchases(uuid, purchases);
        this.checkAndGrant(player, purchases);
        this.saveDataAsync();
    }

    public List<Achievement> getAll() {
        return new ArrayList<Achievement>(this.achievements.values());
    }

    public boolean isUnlocked(UUID uuid, String id) {
        return this.getUnlocked(uuid).contains(id.toLowerCase(Locale.ROOT));
    }

    public int getPurchases(UUID uuid) {
        return this.data.getInt("players." + uuid + ".purchases", 0);
    }

    public Set<String> getUnlocked(UUID uuid) {
        List raw = this.data.getStringList("players." + uuid + ".unlocked");
        return new HashSet<String>(raw.stream().map(s -> s.toLowerCase(Locale.ROOT)).collect(Collectors.toSet()));
    }

    public String getCounterName() {
        return this.lang.get("achievements-counter-name").replace("%counter%", this.counterName);
    }

    public void reload() {
        this.loadConfig();
        this.loadData();
    }

    private void loadConfig() {
        FileConfiguration cfg = this.plugin.getConfig();
        this.enabled = cfg.getBoolean("achievements.enabled", false);
        this.counterName = cfg.getString("achievements.counter-name", "Purchases");
        this.achievements.clear();
        ConfigurationSection root = cfg.getConfigurationSection("achievements");
        if (root == null) {
            return;
        }
        List list = root.getMapList("list");
        if (list == null) {
            return;
        }
        for (Map m : list) {
            if (m == null) continue;
            String idObj = m.containsKey("id") ? m.get("id") : "undefined";
            String id = String.valueOf(idObj).toLowerCase(Locale.ROOT);
            int count = AchievementManager.toInt(m.get("count"), 1);
            String titleObj = m.containsKey("title") ? m.get("title") : id;
            String title = String.valueOf(titleObj);
            String descObj = m.containsKey("description") ? m.get("description") : "";
            String description = String.valueOf(descObj);
            boolean broadcast = AchievementManager.toBool(m.get("broadcast"), false);
            List<String> itemRewards = Collections.emptyList();
            List<String> commandRewards = Collections.emptyList();
            Object rewardsObj = m.get("rewards");
            if (rewardsObj instanceof Map) {
                Map rm = (Map)rewardsObj;
                itemRewards = AchievementManager.toStringList(rm.get("items"));
                commandRewards = AchievementManager.toStringList(rm.get("commands"));
            }
            this.achievements.put(id, new Achievement(id, count, title, description, broadcast, itemRewards, commandRewards));
        }
    }

    private static int toInt(Object o, int def) {
        if (o instanceof Number) {
            Number n = (Number)o;
            return n.intValue();
        }
        try {
            return Integer.parseInt(String.valueOf(o));
        }
        catch (Exception ignored) {
            return def;
        }
    }

    private static boolean toBool(Object o, boolean def) {
        if (o instanceof Boolean) {
            Boolean b = (Boolean)o;
            return b;
        }
        if (o == null) {
            return def;
        }
        return Boolean.parseBoolean(String.valueOf(o));
    }

    private static List<String> toStringList(Object o) {
        if (o instanceof List) {
            List l = (List)o;
            return l.stream().map(String::valueOf).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private void loadData() {
        File folder = new File(this.plugin.getDataFolder(), "data");
        if (!folder.exists()) {
            folder.mkdirs();
        }
        this.dataFile = new File(folder, "players.yml");
        if (!this.dataFile.exists()) {
            try {
                this.dataFile.createNewFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.data = YamlConfiguration.loadConfiguration((File)this.dataFile);
    }

    private void saveDataAsync() {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try {
                this.data.save(this.dataFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }

    private void setPurchases(UUID uuid, int value) {
        this.data.set("players." + uuid + ".purchases", (Object)value);
    }

    private void addUnlocked(UUID uuid, String id) {
        List list = this.data.getStringList("players." + uuid + ".unlocked");
        if (!list.contains(id)) {
            list.add(id);
            this.data.set("players." + uuid + ".unlocked", (Object)list);
        }
    }

    private void checkAndGrant(Player player, int purchases) {
        UUID uuid = player.getUniqueId();
        Set<String> unlocked = this.getUnlocked(uuid);
        for (Achievement a : this.achievements.values()) {
            if (unlocked.contains(a.getId()) || purchases < a.getCount()) continue;
            this.grant(player, a);
            this.addUnlocked(uuid, a.getId());
        }
    }

    private void grant(Player player, Achievement a) {
        String warn;
        String counter = this.getCounterName();
        String msg = this.lang.get("achievement-unlocked-self").replace("%title%", a.getTitle()).replace("%count%", String.valueOf(a.getCount())).replace("%counter%", counter);
        player.sendMessage(AchievementManager.color(msg));
        if (a.isBroadcast()) {
            String br = this.lang.get("achievement-unlocked-broadcast").replace("%player%", player.getName()).replace("%title%", a.getTitle()).replace("%count%", String.valueOf(a.getCount())).replace("%counter%", counter);
            Bukkit.broadcastMessage((String)AchievementManager.color(br));
        }
        for (String def : a.getItemRewards()) {
            try {
                int amount;
                String[] parts = def.split("\\s+");
                Material mat = Material.matchMaterial((String)parts[0]);
                int n = amount = parts.length >= 2 ? Integer.parseInt(parts[1]) : 1;
                if (mat == null) continue;
                ItemStack item = new ItemStack(mat, amount);
                HashMap overflow = player.getInventory().addItem(new ItemStack[]{item});
                if (overflow.isEmpty()) continue;
                overflow.values().forEach(i -> player.getWorld().dropItemNaturally(player.getLocation(), i));
            }
            catch (Exception ex) {
                this.plugin.getLogger().warning("[WSL] Failed to give item reward '" + def + "' for achievement " + a.getId());
                warn = this.lang.get("achievement-reward-failed").replace("%id%", a.getId());
                player.sendMessage(AchievementManager.color(warn));
            }
        }
        for (String cmd : a.getCommandRewards()) {
            try {
                Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)cmd.replace("{player}", player.getName()));
            }
            catch (Exception ex) {
                this.plugin.getLogger().warning("[WSL] Failed to execute command reward '" + cmd + "' for achievement " + a.getId());
                warn = this.lang.get("achievement-reward-failed").replace("%id%", a.getId());
                player.sendMessage(AchievementManager.color(warn));
            }
        }
    }

    private static String color(String s) {
        return s.replace("&", "\u00a7");
    }
}

