/*
 * Decompiled with CFR 0.152.
 */
package com.nocticraft.woostorelink.utils;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import com.nocticraft.woostorelink.utils.Delivery;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class DeliveryFetcher {
    private final JavaPlugin plugin;
    private final Gson gson = new Gson();
    private final String baseUrl;
    private final String token;

    public DeliveryFetcher(JavaPlugin plugin) {
        String domain;
        this.plugin = plugin;
        FileConfiguration config = plugin.getConfig();
        this.baseUrl = domain = config.getString("api-domain", "").replaceAll("/+$", "");
        this.token = config.getString("api-token", "");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Delivery> fetchDeliveries(String playerName) {
        try {
            String fullUrl = this.baseUrl + "/wp-json/storelinkformc/v1/pending?token=" + URLEncoder.encode(this.token, "UTF-8") + "&player=" + URLEncoder.encode(playerName, "UTF-8");
            HttpURLConnection conn = (HttpURLConnection)new URL(fullUrl).openConnection();
            conn.setRequestMethod("GET");
            conn.setConnectTimeout(5000);
            conn.setReadTimeout(5000);
            int code = conn.getResponseCode();
            if (code != 200) {
                this.plugin.getLogger().warning("[REST] Failed to fetch deliveries. HTTP " + code);
                this.printErrorStream(conn);
                return List.of();
            }
            try (InputStreamReader reader = new InputStreamReader(conn.getInputStream());){
                JsonObject json = (JsonObject)this.gson.fromJson((Reader)reader, JsonObject.class);
                Type listType = new TypeToken<List<Delivery>>(){}.getType();
                List list = (List)this.gson.fromJson(json.get("deliveries"), listType);
                return list;
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("[REST] Error fetching deliveries: " + e.getMessage());
        }
        return List.of();
    }

    public void markAsDelivered(List<Integer> deliveryIds) {
        if (deliveryIds.isEmpty()) {
            return;
        }
        for (int deliveryId : deliveryIds) {
            try {
                String endpoint = this.baseUrl + "/wp-json/storelinkformc/v1/mark-delivered";
                HttpURLConnection conn = (HttpURLConnection)new URL(endpoint).openConnection();
                conn.setRequestMethod("POST");
                conn.setDoOutput(true);
                conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                String params = "token=" + URLEncoder.encode(this.token, "UTF-8") + "&id=" + URLEncoder.encode(String.valueOf(deliveryId), "UTF-8");
                try (OutputStream os = conn.getOutputStream();){
                    os.write(params.getBytes(StandardCharsets.UTF_8));
                }
                int code = conn.getResponseCode();
                if (code == 200) {
                    this.plugin.getLogger().info("[REST] Marked delivery " + deliveryId + " as delivered.");
                    continue;
                }
                this.plugin.getLogger().warning("[REST] Failed to mark delivery " + deliveryId + " (HTTP " + code + ")");
                this.printErrorStream(conn);
            }
            catch (Exception e) {
                this.plugin.getLogger().severe("[REST] Error marking delivery " + deliveryId + ": " + e.getMessage());
            }
        }
    }

    private void printErrorStream(HttpURLConnection conn) {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getErrorStream()));){
            String line;
            while ((line = reader.readLine()) != null) {
                this.plugin.getLogger().warning("[REST Error] " + line);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

