/*
 * Decompiled with CFR 0.152.
 */
package com.nocticraft.woostorelink.utils;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class LanguageLoader {
    private final JavaPlugin plugin;
    private final Map<String, String> messages = new HashMap<String, String>();
    private String activeLanguage = "en";

    public LanguageLoader(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    public void load(String langCode) {
        this.messages.clear();
        this.activeLanguage = langCode;
        String filename = "messages_" + langCode + ".yml";
        File langFolder = new File(this.plugin.getDataFolder(), "lang");
        File langFile = new File(langFolder, filename);
        if (!langFolder.exists()) {
            langFolder.mkdirs();
        }
        if (!langFile.exists()) {
            String resourcePath = "lang/" + filename;
            if (this.plugin.getResource(resourcePath) != null) {
                this.plugin.saveResource(resourcePath, false);
                this.plugin.getLogger().info("\u2705 Language file copied: " + resourcePath);
            } else {
                this.plugin.getLogger().warning("\u26a0 Language file not found in JAR: " + resourcePath + ". Falling back to English.");
                this.load("en");
                return;
            }
        }
        try {
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)langFile);
            ConfigurationSection section = config.getConfigurationSection("messages");
            if (section == null) {
                this.plugin.getLogger().warning("\u26a0 'messages:' section not found in " + filename);
                return;
            }
            for (String key : section.getKeys(true)) {
                this.messages.put(key, section.getString(key));
            }
            this.plugin.getLogger().info("\ud83c\udf10 Loaded language: " + langCode + " | Example: " + this.getOrDefault("plugin-enabled", "[Missing key]"));
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("\u274c Failed to load language file: " + e.getMessage());
        }
    }

    public String get(String key) {
        return this.messages.getOrDefault(key, "\u00a7c[Missing lang: " + key + "]");
    }

    public String getOrDefault(String key, String fallback) {
        return this.messages.getOrDefault(key, fallback);
    }

    public String getActiveLanguage() {
        return this.activeLanguage;
    }
}

