/*
 * Decompiled with CFR 0.152.
 */
package com.nocticraft.woostorelink.utils;

import com.nocticraft.woostorelink.WooStoreLink;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.configuration.file.YamlConfiguration;

public class LinkManager {
    private final Map<String, String> pendingEmail = new HashMap<String, String>();
    private final Map<String, Long> lastSync = new HashMap<String, Long>();
    private final Map<String, Boolean> linked = new HashMap<String, Boolean>();
    private final WooStoreLink plugin;
    private final File store;

    public LinkManager(WooStoreLink plugin) {
        this.plugin = plugin;
        this.store = new File(plugin.getDataFolder(), "link-state.yml");
        this.load();
    }

    public void setPendingEmail(String name, String email) {
        this.pendingEmail.put(name.toLowerCase(), email);
    }

    public String getPendingEmail(String name) {
        return this.pendingEmail.get(name.toLowerCase());
    }

    public void clear(String name) {
        this.pendingEmail.remove(name.toLowerCase());
    }

    public void setLastSync(String name, long epochSec) {
        this.lastSync.put(name.toLowerCase(), epochSec);
    }

    public long getLastSync(String name) {
        return this.lastSync.getOrDefault(name.toLowerCase(), 0L);
    }

    public boolean isLinked(String name) {
        return this.linked.getOrDefault(name.toLowerCase(), false);
    }

    public void setLinked(String name, boolean value) {
        this.linked.put(name.toLowerCase(), value);
        this.save();
    }

    private void save() {
        try {
            this.store.getParentFile().mkdirs();
            YamlConfiguration yml = new YamlConfiguration();
            for (Map.Entry<String, Boolean> e : this.linked.entrySet()) {
                yml.set("linked." + e.getKey(), (Object)e.getValue());
            }
            yml.save(this.store);
        }
        catch (IOException ex) {
            this.plugin.getLogger().warning("Failed to save link-state.yml: " + ex.getMessage());
        }
    }

    private void load() {
        if (!this.store.exists()) {
            return;
        }
        try {
            YamlConfiguration yml = YamlConfiguration.loadConfiguration((File)this.store);
            if (yml.isConfigurationSection("linked")) {
                for (String key : yml.getConfigurationSection("linked").getKeys(false)) {
                    this.linked.put(key.toLowerCase(), yml.getBoolean("linked." + key));
                }
            }
        }
        catch (Exception ex) {
            this.plugin.getLogger().warning("Failed to load link-state.yml: " + ex.getMessage());
        }
    }
}

