/*
 * Decompiled with CFR 0.152.
 */
package com.nocticraft.woostorelink.utils.menu;

import com.nocticraft.woostorelink.WooStoreLink;
import com.nocticraft.woostorelink.utils.Achievement;
import com.nocticraft.woostorelink.utils.menu.ItemBuilder;
import com.nocticraft.woostorelink.utils.menu.Menu;
import com.nocticraft.woostorelink.utils.menu.ProfileMenu;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class AchievementsMenu
extends Menu {
    private final WooStoreLink plugin;
    private int page = 0;
    private List<Achievement> all;

    public AchievementsMenu(WooStoreLink plugin, Player viewer) {
        super(viewer);
        this.plugin = plugin;
        this.rows = 6;
        this.all = plugin.getAchievementManager() != null ? plugin.getAchievementManager().getAll() : List.of();
    }

    @Override
    public String title() {
        return "\u00a76Achievements";
    }

    @Override
    public void draw() {
        this.inv.clear();
        this.inv.setItem(0, ItemBuilder.icon(Material.ARROW, "\u00a76Back", List.of("\u00a77Return to Profile")));
        this.inv.setItem(8, ItemBuilder.icon(Material.BARRIER, "\u00a7cExit", List.of("\u00a77Close")));
        int start = this.page * 28;
        int purchases = 0;
        try {
            purchases = this.plugin.getAchievementManager().getPurchases(this.viewer.getUniqueId());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        for (int i = 0; i < 28 && start + i < this.all.size(); ++i) {
            Achievement a = this.all.get(start + i);
            boolean unlocked = this.plugin.getAchievementManager().isUnlocked(this.viewer.getUniqueId(), a.getId());
            int need = Math.max(0, a.getCount() - purchases);
            String bar = this.progressBar(Math.min(purchases, a.getCount()), a.getCount());
            ItemStack icon = new ItemStack(unlocked ? Material.EMERALD : Material.REDSTONE);
            this.inv.setItem(this.slotForIndex(i), ItemBuilder.icon(icon.getType(), (unlocked ? "\u00a7a" : "\u00a7c") + a.getTitle(), List.of("\u00a77Requirement: \u00a7f" + a.getCount() + " " + this.plugin.getAchievementManager().getCounterName(), "\u00a77Progress: \u00a7f" + purchases + "/" + a.getCount() + " " + bar, unlocked ? "\u00a7aUnlocked!" : "\u00a7cMissing: \u00a7f" + need)));
        }
        this.inv.setItem(45, ItemBuilder.icon(Material.ARROW, "\u00a76Prev", List.of()));
        this.inv.setItem(53, ItemBuilder.icon(Material.ARROW, "\u00a76Next", List.of()));
    }

    private String progressBar(int done, int all) {
        int width = 12;
        int fill = all == 0 ? 0 : (int)Math.round((double)done * 1.0 / (double)all * (double)width);
        StringBuilder sb = new StringBuilder("\u00a77[");
        for (int i = 0; i < width; ++i) {
            sb.append(i < fill ? "\u00a7a\u25ae" : "\u00a78\u25af");
        }
        sb.append("\u00a77]");
        return sb.toString();
    }

    private int slotForIndex(int i) {
        int row = i / 7;
        int col = i % 7;
        return (row + 1) * 9 + (col + 1);
    }

    @Override
    public void onClick(InventoryClickEvent e) {
        super.onClick(e);
        if (e.getSlot() == 0) {
            new ProfileMenu(this.plugin, this.viewer).open();
            return;
        }
        if (e.getSlot() == 8) {
            this.viewer.closeInventory();
            return;
        }
        if (e.getSlot() == 45 && this.page > 0) {
            --this.page;
            this.draw();
            return;
        }
        if (e.getSlot() == 53 && (this.page + 1) * 28 < this.all.size()) {
            ++this.page;
            this.draw();
            return;
        }
    }
}

