/*
 * Decompiled with CFR 0.152.
 */
package com.nocticraft.woostorelink.utils.menu;

import com.nocticraft.woostorelink.WooStoreLink;
import com.nocticraft.woostorelink.utils.Achievement;
import com.nocticraft.woostorelink.utils.AchievementManager;
import com.nocticraft.woostorelink.utils.menu.HelpMenu;
import com.nocticraft.woostorelink.utils.menu.ItemBuilder;
import com.nocticraft.woostorelink.utils.menu.Menu;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class ProfileMenu
extends Menu {
    private final WooStoreLink plugin;

    public ProfileMenu(WooStoreLink plugin, Player viewer) {
        super(viewer);
        this.plugin = plugin;
        this.rows = 1;
    }

    @Override
    public String title() {
        return "\u00a76\u00a7lProfile \u00a77\u2022 \u00a7f" + this.viewer.getName();
    }

    @Override
    public void draw() {
        this.inv.clear();
        ItemStack head = new ItemStack(Material.PLAYER_HEAD);
        SkullMeta sm = (SkullMeta)head.getItemMeta();
        sm.setOwningPlayer(Bukkit.getOfflinePlayer((UUID)this.viewer.getUniqueId()));
        sm.setDisplayName("\u00a7e\u00a7l" + this.viewer.getName());
        sm.setLore(List.of("\u00a77UUID: \u00a7f" + this.viewer.getUniqueId()));
        head.setItemMeta((ItemMeta)sm);
        this.inv.setItem(0, head);
        boolean linkingEnabled = this.plugin.getConfig().getBoolean("linking.enabled", true);
        boolean isLinked = this.plugin.getLinkManager() != null && this.plugin.getLinkManager().isLinked(this.viewer.getName());
        long lastSync = this.plugin.getLinkManager() != null ? this.plugin.getLinkManager().getLastSync(this.viewer.getName()) : 0L;
        boolean isLinkedApprox = lastSync > 0L;
        this.inv.setItem(2, ItemBuilder.icon(isLinked ? Material.LIME_DYE : Material.RED_DYE, this.color(this.plugin.getLang().getOrDefault("menu-profile-linking-name", "&6Linking")), List.of(this.color(this.plugin.getLang().getOrDefault("menu-profile-linking-lore-1", "&7Server: %server%").replace("%server%", this.plugin.getConfig().getBoolean("linking.enabled", true) ? this.plugin.getLang().getOrDefault("menu-profile-linking-lore-server-enabled", "&aenabled") : this.plugin.getLang().getOrDefault("menu-profile-linking-lore-server-disabled", "&cdisabled"))), this.color(this.plugin.getLang().getOrDefault("menu-profile-linking-lore-2", "&7Your status: %status%").replace("%status%", isLinked ? this.plugin.getLang().getOrDefault("menu-profile-linking-status-linked", "&alinked") : this.plugin.getLang().getOrDefault("menu-profile-linking-status-notlinked", "&cnot linked"))), this.color(this.plugin.getLang().getOrDefault("menu-profile-linking-lore-3", "&e&oClick for instructions")))));
        int pending = this.plugin.getDeliveryService() != null ? this.plugin.getDeliveryService().countPending(this.viewer.getUniqueId()) : 0;
        this.inv.setItem(4, ItemBuilder.icon(pending > 0 ? Material.CHEST_MINECART : Material.CHEST, "\u00a76Deliveries", List.of("\u00a77Pending: \u00a7f" + pending, "\u00a7e\u00a7oClick to open")));
        int unlocked = 0;
        int total = 0;
        try {
            if (this.plugin.getAchievementManager() != null) {
                AchievementManager am = this.plugin.getAchievementManager();
                List<Achievement> all = am.getAll();
                total = all.size();
                UUID id = this.viewer.getUniqueId();
                for (Achievement a : all) {
                    if (!am.isUnlocked(id, a.getId())) continue;
                    ++unlocked;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.inv.setItem(6, ItemBuilder.icon(Material.NETHER_STAR, "\u00a76Achievements", List.of("\u00a77Unlocked: \u00a7f" + unlocked + "/" + total, "\u00a7e\u00a7oClick to open")));
        this.inv.setItem(7, ItemBuilder.icon(Material.BOOK, "\u00a76Help", List.of("\u00a77View all commands and info")));
        this.inv.setItem(8, ItemBuilder.icon(Material.BARRIER, "\u00a7cExit", List.of("\u00a77Close this menu")));
    }

    @Override
    public void onClick(InventoryClickEvent e) {
        super.onClick(e);
        switch (e.getSlot()) {
            case 2: {
                this.viewer.performCommand("wsl wp-link");
                break;
            }
            case 4: {
                this.viewer.performCommand("wsl deliveries");
                break;
            }
            case 6: {
                this.viewer.performCommand("wsl achievements");
                break;
            }
            case 7: {
                new HelpMenu(this.plugin, this.viewer).open();
                break;
            }
            case 8: {
                this.viewer.closeInventory();
                break;
            }
        }
    }
}

