/*
 * Decompiled with CFR 0.152.
 */
package net.xstopho.resource_backpacks;

import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerEntityEvents;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.xstopho.resource_backpacks.BackpackConstants;
import net.xstopho.resource_backpacks.modifier.EntityModifier;
import net.xstopho.resource_backpacks.network.payloads.EnderChestRequestPayload;
import net.xstopho.resource_backpacks.network.payloads.EnderChestResponsePayload;
import net.xstopho.resource_backpacks.network.payloads.OpenBackpackPayload;
import net.xstopho.resource_backpacks.network.payloads.SyncCreativeSlotPayload;
import net.xstopho.resource_backpacks.network.payloads.SyncEntityBackpackPayload;

public class ResourceBackpacks
implements ModInitializer {
    public void onInitialize() {
        BackpackConstants.commonInit();
        this.registerServerPayloads();
        ServerEntityEvents.ENTITY_LOAD.register((entity, world) -> EntityModifier.modifyEntities(entity));
    }

    private void registerServerPayloads() {
        PayloadTypeRegistry.playC2S().register(OpenBackpackPayload.TYPE, OpenBackpackPayload.CODEC);
        ServerPlayNetworking.registerGlobalReceiver(OpenBackpackPayload.TYPE, (payload, context) -> OpenBackpackPayload.handle(payload, context.player()));
        PayloadTypeRegistry.playC2S().register(EnderChestRequestPayload.TYPE, EnderChestRequestPayload.CODEC);
        ServerPlayNetworking.registerGlobalReceiver(EnderChestRequestPayload.TYPE, (payload, context) -> EnderChestRequestPayload.handle(payload, context.player()));
        PayloadTypeRegistry.playC2S().register(SyncCreativeSlotPayload.TYPE, SyncCreativeSlotPayload.CODEC);
        ServerPlayNetworking.registerGlobalReceiver(SyncCreativeSlotPayload.TYPE, (payload, context) -> SyncCreativeSlotPayload.handle(payload, context.player()));
        PayloadTypeRegistry.playS2C().register(EnderChestResponsePayload.TYPE, EnderChestResponsePayload.CODEC);
        PayloadTypeRegistry.playS2C().register(SyncEntityBackpackPayload.TYPE, SyncEntityBackpackPayload.CODEC);
    }
}

