/*
 * Decompiled with CFR 0.152.
 */
package net.xstopho.resource_backpacks.backpack;

import java.util.List;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_3908;
import net.minecraft.class_5632;
import net.minecraft.class_747;
import net.minecraft.class_9288;
import net.minecraft.class_9334;
import net.xstopho.resource_backpacks.backpack.tooltip.CompactClientTooltipComponent;
import net.xstopho.resource_backpacks.backpack.tooltip.InventoryClientTooltipComponent;
import net.xstopho.resource_backpacks.backpack.util.BackpackInventory;
import net.xstopho.resource_backpacks.backpack.util.BackpackLevel;
import net.xstopho.resource_backpacks.client.screen.BackpackMenu;
import net.xstopho.resource_backpacks.client.util.BackpackClientUtils;
import net.xstopho.resource_backpacks.config.common.BackpackConfig;
import net.xstopho.resource_backpacks.registries.KeyMappingRegistry;

public class BackpackItem
extends class_1747 {
    private final BackpackLevel backpackLevel;

    public BackpackItem(class_2248 block, BackpackLevel backpackLevel, class_1792.class_1793 properties) {
        super(block, properties.method_57349(class_9334.field_49622, (Object)class_9288.field_49334));
        this.backpackLevel = backpackLevel;
    }

    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 usedHand) {
        class_1799 stack = player.method_5998(usedHand);
        if (!level.field_9236 && BackpackConfig.openFromInventory) {
            player.method_17355(this.getMenuProvider(stack));
        }
        return class_1271.method_22427((Object)stack);
    }

    public class_1269 method_7884(class_1838 context) {
        class_1657 player = context.method_8036();
        if (player != null && (player.method_18276() || !BackpackConfig.openFromInventory)) {
            super.method_7884(context);
        }
        return class_1269.field_5811;
    }

    public class_3908 getMenuProvider(class_1799 stack) {
        BackpackInventory backpackInventory = new BackpackInventory(stack, this.backpackLevel);
        return switch (this.backpackLevel) {
            default -> throw new MatchException(null, null);
            case BackpackLevel.LEATHER -> new class_747((i, inventory, player) -> BackpackMenu.leatherMenu(i, inventory, (class_1263)backpackInventory, false), this.method_7848());
            case BackpackLevel.COPPER -> new class_747((i, inventory, player) -> BackpackMenu.copperMenu(i, inventory, (class_1263)backpackInventory, false), this.method_7848());
            case BackpackLevel.GOLD -> new class_747((i, inventory, player) -> BackpackMenu.goldMenu(i, inventory, (class_1263)backpackInventory, false), this.method_7848());
            case BackpackLevel.IRON -> new class_747((i, inventory, player) -> BackpackMenu.ironMenu(i, inventory, (class_1263)backpackInventory, false), this.method_7848());
            case BackpackLevel.DIAMOND -> new class_747((i, inventory, player) -> BackpackMenu.diamondMenu(i, inventory, (class_1263)backpackInventory, false), this.method_7848());
            case BackpackLevel.NETHERITE -> new class_747((i, inventory, player) -> BackpackMenu.netheriteMenu(i, inventory, (class_1263)backpackInventory, false), this.method_7848());
            case BackpackLevel.END -> new class_747((i, inventory, player) -> BackpackMenu.endMenu(i, inventory, (class_1263)player.method_7274(), false), this.method_7848());
        };
    }

    public BackpackLevel getBackpackLevel() {
        return this.backpackLevel;
    }

    public boolean method_31568() {
        return false;
    }

    public Optional<class_5632> method_32346(class_1799 stack) {
        class_9288 content = (class_9288)stack.method_57824(class_9334.field_49622);
        Optional<class_5632> tooltipComponent = Optional.empty();
        if (this.enableCompactPreview()) {
            tooltipComponent = Optional.of(new CompactClientTooltipComponent.CompactTooltipComponent(content, this.backpackLevel));
        } else if (this.enableInventoryPreview()) {
            tooltipComponent = Optional.of(new InventoryClientTooltipComponent.InventoryTooltipComponent(content, this.backpackLevel));
        }
        return tooltipComponent;
    }

    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 tooltipFlag) {
        if (!this.enableCompactPreview() && !this.enableInventoryPreview()) {
            if (!KeyMappingRegistry.SHOW_COMPACT_PREVIEW.method_1415()) {
                tooltip.add((class_2561)KeyMappingRegistry.SHOW_COMPACT_PREVIEW.method_16007().method_27661().method_27692(class_124.field_1065).method_10852((class_2561)class_2561.method_43470((String)": ")).method_10852((class_2561)class_2561.method_43471((String)"tooltip.resource_backpacks.info.compact_preview").method_27692(class_124.field_1068)));
            }
            if (!KeyMappingRegistry.SHOW_INVENTORY_PREVIEW.method_1415()) {
                tooltip.add((class_2561)KeyMappingRegistry.SHOW_INVENTORY_PREVIEW.method_16007().method_27661().method_27692(class_124.field_1065).method_10852((class_2561)class_2561.method_43470((String)": ")).method_10852((class_2561)class_2561.method_43471((String)"tooltip.resource_backpacks.info.inventory_preview").method_27692(class_124.field_1068)));
            }
        }
        super.method_7851(stack, context, tooltip, tooltipFlag);
    }

    private boolean enableCompactPreview() {
        return BackpackClientUtils.hasKeyDown(KeyMappingRegistry.SHOW_COMPACT_PREVIEW);
    }

    private boolean enableInventoryPreview() {
        return BackpackClientUtils.hasKeyDown(KeyMappingRegistry.SHOW_INVENTORY_PREVIEW);
    }
}

