/*
 * Decompiled with CFR 0.152.
 */
package net.xstopho.resource_backpacks.client.screen;

import java.util.Objects;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_3917;
import net.xstopho.resource_backpacks.backpack.BackpackItem;
import net.xstopho.resource_backpacks.backpack.util.BackpackLevel;
import net.xstopho.resource_backpacks.config.common.BackpackConfig;
import net.xstopho.resource_backpacks.registries.MenuTypeRegistry;
import org.jetbrains.annotations.NotNull;

public class BackpackMenu
extends class_1703 {
    private final class_1263 backpackInventory;
    private final BackpackLevel backpackLevel;
    private final boolean externalBackpack;

    private BackpackMenu(class_3917<?> menuType, int containerId, class_1661 playerInventory, BackpackLevel backpackLevel, boolean externalBackpack) {
        this(menuType, containerId, playerInventory, (class_1263)new class_1277(backpackLevel.getSize()), backpackLevel, externalBackpack);
    }

    public static BackpackMenu leatherMenu(int containerId, class_1661 playerInventory) {
        return new BackpackMenu((class_3917)MenuTypeRegistry.LEATHER_MENU.get(), containerId, playerInventory, BackpackLevel.LEATHER, false);
    }

    public static BackpackMenu leatherMenu(int containerId, class_1661 playerInventory, class_1263 backpackInventory, boolean externalBackpack) {
        return new BackpackMenu((class_3917)MenuTypeRegistry.LEATHER_MENU.get(), containerId, playerInventory, backpackInventory, BackpackLevel.LEATHER, externalBackpack);
    }

    public static BackpackMenu copperMenu(int containerId, class_1661 playerInventory) {
        return new BackpackMenu((class_3917)MenuTypeRegistry.COPPER_MENU.get(), containerId, playerInventory, BackpackLevel.COPPER, false);
    }

    public static BackpackMenu copperMenu(int containerId, class_1661 playerInventory, class_1263 backpackInventory, boolean externalBackpack) {
        return new BackpackMenu((class_3917)MenuTypeRegistry.COPPER_MENU.get(), containerId, playerInventory, backpackInventory, BackpackLevel.COPPER, externalBackpack);
    }

    public static BackpackMenu goldMenu(int containerId, class_1661 playerInventory) {
        return new BackpackMenu((class_3917)MenuTypeRegistry.GOLD_MENU.get(), containerId, playerInventory, BackpackLevel.GOLD, false);
    }

    public static BackpackMenu goldMenu(int containerId, class_1661 playerInventory, class_1263 backpackInventory, boolean externalBackpack) {
        return new BackpackMenu((class_3917)MenuTypeRegistry.GOLD_MENU.get(), containerId, playerInventory, backpackInventory, BackpackLevel.GOLD, externalBackpack);
    }

    public static BackpackMenu ironMenu(int containerId, class_1661 playerInventory) {
        return new BackpackMenu((class_3917)MenuTypeRegistry.IRON_MENU.get(), containerId, playerInventory, BackpackLevel.IRON, false);
    }

    public static BackpackMenu ironMenu(int containerId, class_1661 playerInventory, class_1263 backpackInventory, boolean externalBackpack) {
        return new BackpackMenu((class_3917)MenuTypeRegistry.IRON_MENU.get(), containerId, playerInventory, backpackInventory, BackpackLevel.IRON, externalBackpack);
    }

    public static BackpackMenu diamondMenu(int containerId, class_1661 playerInventory) {
        return new BackpackMenu((class_3917)MenuTypeRegistry.DIAMOND_MENU.get(), containerId, playerInventory, BackpackLevel.DIAMOND, false);
    }

    public static BackpackMenu diamondMenu(int containerId, class_1661 playerInventory, class_1263 backpackInventory, boolean externalBackpack) {
        return new BackpackMenu((class_3917)MenuTypeRegistry.DIAMOND_MENU.get(), containerId, playerInventory, backpackInventory, BackpackLevel.DIAMOND, externalBackpack);
    }

    public static BackpackMenu netheriteMenu(int containerId, class_1661 playerInventory) {
        return new BackpackMenu((class_3917)MenuTypeRegistry.NETHERITE_MENU.get(), containerId, playerInventory, BackpackLevel.NETHERITE, false);
    }

    public static BackpackMenu netheriteMenu(int containerId, class_1661 playerInventory, class_1263 backpackInventory, boolean externalBackpack) {
        return new BackpackMenu((class_3917)MenuTypeRegistry.NETHERITE_MENU.get(), containerId, playerInventory, backpackInventory, BackpackLevel.NETHERITE, externalBackpack);
    }

    public static BackpackMenu endMenu(int containerId, class_1661 playerInventory) {
        return new BackpackMenu((class_3917)MenuTypeRegistry.END_MENU.get(), containerId, playerInventory, BackpackLevel.END, false);
    }

    public static BackpackMenu endMenu(int containerId, class_1661 playerInventory, class_1263 backpackInventory, boolean externalBackpack) {
        return new BackpackMenu((class_3917)MenuTypeRegistry.END_MENU.get(), containerId, playerInventory, backpackInventory, BackpackLevel.END, externalBackpack);
    }

    public BackpackMenu(class_3917<?> menuType, int containerId, class_1661 playerInventory, class_1263 backpackInventory, BackpackLevel backpackLevel, boolean externalBackpack) {
        super(menuType, containerId);
        this.backpackInventory = backpackInventory;
        this.externalBackpack = externalBackpack;
        this.backpackLevel = backpackLevel;
        backpackInventory.method_5435(playerInventory.field_7546);
        this.addBackpackSlots();
        int xPos = (backpackLevel.getColumns() - 9) * 18 / 2;
        this.addStandardInventorySlots((class_1263)playerInventory, xPos + 8, backpackLevel.getRows() * 18 + 30);
    }

    private void addBackpackSlots() {
        int rows = this.backpackLevel.getRows();
        int columns = this.backpackLevel.getColumns();
        for (int row = 0; row < rows; ++row) {
            for (int column = 0; column < columns; ++column) {
                this.method_7621(new BackpackInventorySlot(this.backpackInventory, column + row * columns, 8 + column * 18, 18 + row * 18, this.externalBackpack));
            }
        }
    }

    protected void addStandardInventorySlots(@NotNull class_1263 playerInventory, int xPos, int yPos) {
        this.addInventoryExtendedSlots(playerInventory, xPos, yPos);
        this.addInventoryHotbarSlots(playerInventory, xPos, yPos + 58);
    }

    protected void addInventoryHotbarSlots(@NotNull class_1263 playerInventory, int xPos, int yPos) {
        for (int i = 0; i < 9; ++i) {
            this.method_7621(new BackpackInventorySlot(playerInventory, i, xPos + i * 18, yPos, this.externalBackpack));
        }
    }

    protected void addInventoryExtendedSlots(@NotNull class_1263 playerInventory, int xPos, int yPos) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.method_7621(new BackpackInventorySlot(playerInventory, j + (i + 1) * 9, xPos + j * 18, yPos + i * 18, this.externalBackpack));
            }
        }
    }

    @NotNull
    public class_1799 method_7601(@NotNull class_1657 player, int index) {
        class_1799 returnStack = class_1799.field_8037;
        class_1735 slot = (class_1735)this.field_7761.get(index);
        if (slot.method_7681()) {
            class_1799 stack = slot.method_7677();
            returnStack = stack.method_7972();
            if (index < this.backpackInventory.method_5439() ? !this.method_7616(stack, this.backpackInventory.method_5439(), this.field_7761.size(), true) : !this.method_7616(stack, 0, this.backpackInventory.method_5439(), false)) {
                return class_1799.field_8037;
            }
            if (stack.method_7960()) {
                slot.method_53512(class_1799.field_8037);
            } else {
                slot.method_7668();
            }
        }
        return returnStack;
    }

    public boolean method_7597(@NotNull class_1657 player) {
        return this.backpackInventory.method_5443(player);
    }

    public void method_7595(@NotNull class_1657 player) {
        super.method_7595(player);
        this.backpackInventory.method_5432(player);
    }

    public BackpackLevel getBackpackLevel() {
        return this.backpackLevel;
    }

    private static class BackpackInventorySlot
    extends class_1735 {
        private final boolean externalBackpack;

        public BackpackInventorySlot(class_1263 inventory, int index, int x, int y, boolean externalBackpack) {
            super(inventory, index, x, y);
            this.externalBackpack = externalBackpack;
        }

        public boolean method_7674(class_1657 player) {
            class_1799 handItem = player.method_6047();
            class_1799 slotItem = this.method_7677();
            if (handItem.method_7909() instanceof BackpackItem && !this.externalBackpack) {
                return !Objects.equals(handItem, slotItem);
            }
            return true;
        }

        public boolean method_7680(@NotNull class_1799 stack) {
            return BackpackConfig.allowBackpacksInsideBackpacks || this.canMoveStack(stack);
        }

        public boolean canMoveStack(class_1799 stack) {
            if (this.field_7871 instanceof class_1661) {
                return true;
            }
            return stack.method_7909().method_31568();
        }
    }
}

