/*
 * Decompiled with CFR 0.152.
 */
package net.xstopho.resource_backpacks.backpack.api;

import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public interface ImplementedInventory
extends WorldlyContainer {
    public NonNullList<ItemStack> getItems();

    default public int @NotNull [] getSlotsForFace(@NotNull Direction side) {
        int size = this.getItems().size();
        int[] result = new int[size];
        for (int i = 0; i < result.length; ++i) {
            result[i] = i;
        }
        return result;
    }

    default public boolean canPlaceItemThroughFace(int slot, ItemStack stack, Direction side) {
        return true;
    }

    default public boolean canTakeItemThroughFace(int slot, ItemStack stack, Direction side) {
        return true;
    }

    default public int getContainerSize() {
        return this.getItems().size();
    }

    default public boolean isEmpty() {
        for (int i = 0; i < this.getContainerSize(); ++i) {
            ItemStack stack = this.getItem(i);
            if (stack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    default public ItemStack getItem(int slot) {
        return (ItemStack)this.getItems().get(slot);
    }

    @NotNull
    default public ItemStack removeItem(int slot, int count) {
        ItemStack result = ContainerHelper.removeItem(this.getItems(), (int)slot, (int)count);
        if (!result.isEmpty()) {
            this.setChanged();
        }
        return result;
    }

    @NotNull
    default public ItemStack removeItemNoUpdate(int slot) {
        return ContainerHelper.takeItem(this.getItems(), (int)slot);
    }

    default public void setItem(int slot, @NotNull ItemStack stack) {
        this.getItems().set(slot, (Object)stack);
        if (stack.getCount() > this.getMaxStackSize()) {
            stack.setCount(this.getMaxStackSize());
        }
    }

    default public void clearContent() {
        this.getItems().clear();
    }

    default public void setChanged() {
    }

    default public boolean stillValid(@NotNull Player player) {
        return true;
    }
}

