/*
 * Decompiled with CFR 0.152.
 */
package net.xstopho.resource_backpacks.client.model;

import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.xstopho.resource_backpacks.BackpackConstants;
import net.xstopho.resource_backpacks.backpack.BackpackItem;

public class BackpackModel<T extends LivingEntityRenderState>
extends EntityModel<T> {
    public static final ModelLayerLocation BACKPACK_LAYER = new ModelLayerLocation(ResourceLocation.withDefaultNamespace((String)"player"), "backpack");
    private final ModelPart backpack;

    public BackpackModel(ModelPart root) {
        super(root);
        this.backpack = root.getChild("backpack");
    }

    public static LayerDefinition createLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("backpack", CubeListBuilder.create().texOffs(0, 6).addBox("base", 0.0f, 1.0f, 0.0f, 8.0f, 9.0f, 4.0f).texOffs(25, 11).addBox("middle_pouch", 1.0f, 3.0f, 4.0f, 6.0f, 7.0f, 1.0f).texOffs(0, 0).addBox("bottom", 1.0f, 10.0f, 0.0f, 6.0f, 1.0f, 4.0f).texOffs(30, 3).addBox("decorator", 2.5f, 6.5f, 4.5f, 3.0f, 3.0f, 1.0f).texOffs(21, 0).addBox("left_pouch", 8.0f, 6.0f, 0.5f, 1.0f, 4.0f, 3.0f).texOffs(21, 0).addBox("right_pouch", -1.0f, 6.0f, 0.5f, 1.0f, 4.0f, 3.0f), PartPose.offset((float)-4.0f, (float)0.0f, (float)2.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)39, (int)19);
    }

    public static ResourceLocation getTexture(ItemStack stack) {
        String type = "default";
        Item item = stack.getItem();
        if (item instanceof BackpackItem) {
            BackpackItem backpackItem = (BackpackItem)item;
            type = backpackItem.getBackpackLevel().name().toLowerCase();
        }
        return BackpackConstants.of("textures/entity/backpack_" + type + ".png");
    }

    public void setupAngles(HumanoidModel<?> model) {
        this.backpack.copyFrom(model.body);
    }
}

