/*
 * Decompiled with CFR 0.152.
 */
package net.xstopho.resource_backpacks.handler;

import net.minecraft.client.model.ArmorStandArmorModel;
import net.minecraft.client.model.CreeperModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.ZombieModel;
import net.minecraft.client.renderer.entity.ArmorStandRenderer;
import net.minecraft.client.renderer.entity.CreeperRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.ZombieRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.entity.state.ArmorStandRenderState;
import net.minecraft.client.renderer.entity.state.CreeperRenderState;
import net.minecraft.client.renderer.entity.state.PlayerRenderState;
import net.minecraft.client.renderer.entity.state.ZombieRenderState;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.xstopho.resource_backpacks.BackpackConstants;
import net.xstopho.resource_backpacks.client.model.BackpackModel;
import net.xstopho.resource_backpacks.client.renderer.ArmorStandBackpackLayer;
import net.xstopho.resource_backpacks.client.renderer.CreeperBackpackLayer;
import net.xstopho.resource_backpacks.client.renderer.PlayerBackpackLayer;
import net.xstopho.resource_backpacks.client.renderer.ZombieBackpackLayer;
import net.xstopho.resource_backpacks.registries.KeyMappingRegistry;

@Mod.EventBusSubscriber(modid="resource_backpacks", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModClientHandler {
    @SubscribeEvent
    public static void registerKeyMapping(RegisterKeyMappingsEvent event) {
        event.register(KeyMappingRegistry.OPEN_BACKPACK);
        event.register(KeyMappingRegistry.SHOW_COMPACT_PREVIEW);
        event.register(KeyMappingRegistry.SHOW_INVENTORY_PREVIEW);
    }

    @SubscribeEvent
    public static void setupClient(FMLClientSetupEvent event) {
        BackpackConstants.clientInit();
    }

    @SubscribeEvent
    public static void registerRenderLayer(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(BackpackModel.BACKPACK_LAYER, BackpackModel::createLayer);
    }

    @SubscribeEvent
    public static void addRenderLayer(EntityRenderersEvent.AddLayers event) {
        ArmorStandRenderer armorStand;
        CreeperRenderer creeper;
        ZombieRenderer zombie;
        PlayerRenderer widePlayer;
        PlayerRenderer slimPlayer = (PlayerRenderer)event.getPlayerSkin(PlayerSkin.Model.SLIM);
        if (slimPlayer != null) {
            slimPlayer.addLayer((RenderLayer)new PlayerBackpackLayer((RenderLayerParent<PlayerRenderState, PlayerModel>)slimPlayer, event.getContext().getModelSet()));
        }
        if ((widePlayer = (PlayerRenderer)event.getPlayerSkin(PlayerSkin.Model.WIDE)) != null) {
            widePlayer.addLayer((RenderLayer)new PlayerBackpackLayer((RenderLayerParent<PlayerRenderState, PlayerModel>)widePlayer, event.getContext().getModelSet()));
        }
        if ((zombie = (ZombieRenderer)event.getEntityRenderer(EntityType.ZOMBIE)) != null) {
            zombie.addLayer((RenderLayer)new ZombieBackpackLayer((RenderLayerParent<ZombieRenderState, ZombieModel<ZombieRenderState>>)zombie, event.getContext().getModelSet()));
        }
        if ((creeper = (CreeperRenderer)event.getEntityRenderer(EntityType.CREEPER)) != null) {
            creeper.addLayer((RenderLayer)new CreeperBackpackLayer((RenderLayerParent<CreeperRenderState, CreeperModel>)creeper, event.getContext().getModelSet()));
        }
        if ((armorStand = (ArmorStandRenderer)event.getEntityRenderer(EntityType.ARMOR_STAND)) != null) {
            armorStand.addLayer((RenderLayer)new ArmorStandBackpackLayer((RenderLayerParent<ArmorStandRenderState, ArmorStandArmorModel>)armorStand, event.getContext().getModelSet()));
        }
    }
}

