/*
 * Decompiled with CFR 0.152.
 */
package net.xstopho.resource_backpacks.backpack;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.xstopho.resource_backpacks.backpack.BackpackBlockEntity;
import net.xstopho.resource_backpacks.backpack.util.BackpackBlockShapes;
import net.xstopho.resource_backpacks.backpack.util.BackpackLevel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BackpackBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final MapCodec<BackpackBlock> CODEC = BackpackBlock.simpleCodec(BackpackBlock::new);
    public static final BooleanProperty PLACED_ON_WALL = BooleanProperty.create((String)"placed_on_wall");
    private final BackpackLevel backpackLevel;

    public BackpackBlock(BlockBehaviour.Properties properties, BackpackLevel backpackLevel) {
        super(properties);
        this.backpackLevel = backpackLevel;
    }

    private BackpackBlock(BlockBehaviour.Properties properties) {
        this(properties, BackpackLevel.LEATHER);
    }

    @NotNull
    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!level.isClientSide() && blockEntity instanceof BackpackBlockEntity) {
            BackpackBlockEntity entity = (BackpackBlockEntity)blockEntity;
            player.openMenu((MenuProvider)entity);
        }
        return InteractionResult.SUCCESS;
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof BackpackBlockEntity) {
            BackpackBlockEntity entity = (BackpackBlockEntity)blockEntity;
            entity.spawnFreshItemEntity(level, pos, this.asItem());
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    protected BlockState updateShape(BlockState state, LevelReader level, ScheduledTickAccess scheduledTickAccess, BlockPos pos, Direction direction, BlockPos neighborPos, BlockState neighborState, RandomSource random) {
        if (((Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
            scheduledTickAccess.createTick(pos, (Object)Fluids.WATER, Fluids.WATER.getTickDelay(level));
        }
        return super.updateShape(state, level, scheduledTickAccess, pos, direction, neighborPos, neighborState, random);
    }

    protected FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        boolean onWall = (Boolean)state.getValue((Property)PLACED_ON_WALL);
        return BackpackBlockShapes.getVoxelShape(direction, onWall);
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState fluidState = context.getLevel().getFluidState(context.getClickedPos());
        return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)PLACED_ON_WALL, (Comparable)Boolean.valueOf(switch (context.getClickedFace()) {
            case Direction.NORTH, Direction.EAST, Direction.WEST, Direction.SOUTH -> true;
            default -> false;
        }))).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.is((Fluid)Fluids.WATER)));
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BlockStateProperties.HORIZONTAL_FACING}).add(new Property[]{BlockStateProperties.WATERLOGGED}).add(new Property[]{PLACED_ON_WALL});
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new BackpackBlockEntity(blockPos, blockState);
    }

    public BackpackLevel getBackpackLevel() {
        return this.backpackLevel;
    }

    public static BackpackLevel getLevelFromBlock(Block block) {
        return block instanceof BackpackBlock ? ((BackpackBlock)block).getBackpackLevel() : null;
    }
}

