/*
 * Decompiled with CFR 0.152.
 */
package net.xstopho.resource_backpacks.backpack;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.xstopho.resource_backpacks.backpack.BackpackBlock;
import net.xstopho.resource_backpacks.backpack.api.ImplementedInventory;
import net.xstopho.resource_backpacks.backpack.component.BackpackContainerContents;
import net.xstopho.resource_backpacks.backpack.util.BackpackLevel;
import net.xstopho.resource_backpacks.client.screen.BackpackMenu;
import net.xstopho.resource_backpacks.registries.BlockEntityRegistry;
import net.xstopho.resource_backpacks.registries.DataComponentRegistry;

public class BackpackBlockEntity
extends BlockEntity
implements Nameable,
ImplementedInventory,
MenuProvider {
    private final BackpackLevel level;
    private NonNullList<ItemStack> items;
    private Component displayName;

    public BackpackBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)BlockEntityRegistry.BACKPACK_ENTITY.get(), pos, blockState);
        this.level = BackpackBlock.getLevelFromBlock(blockState.getBlock());
        this.items = NonNullList.withSize((int)this.level.getSize(), (Object)ItemStack.EMPTY);
    }

    @Override
    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    public Component getName() {
        return this.displayName != null ? this.displayName : this.level.getDefaultName();
    }

    public Component getDisplayName() {
        return this.getName();
    }

    protected void saveAdditional(ValueOutput valueOutput) {
        super.saveAdditional(valueOutput);
        ContainerHelper.saveAllItems((ValueOutput)valueOutput, this.items, (boolean)true);
    }

    protected void loadAdditional(ValueInput valueInput) {
        super.loadAdditional(valueInput);
        this.items = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((ValueInput)valueInput, this.items);
    }

    public AbstractContainerMenu createMenu(int i, Inventory inventory, Player player) {
        return switch (this.level) {
            default -> throw new MatchException(null, null);
            case BackpackLevel.LEATHER -> BackpackMenu.leatherMenu(i, inventory, (Container)this, true);
            case BackpackLevel.COPPER -> BackpackMenu.copperMenu(i, inventory, (Container)this, true);
            case BackpackLevel.GOLD -> BackpackMenu.goldMenu(i, inventory, (Container)this, true);
            case BackpackLevel.IRON -> BackpackMenu.ironMenu(i, inventory, (Container)this, true);
            case BackpackLevel.DIAMOND -> BackpackMenu.diamondMenu(i, inventory, (Container)this, true);
            case BackpackLevel.NETHERITE -> BackpackMenu.netheriteMenu(i, inventory, (Container)this, true);
            case BackpackLevel.END -> BackpackMenu.endMenu(i, inventory, (Container)inventory.player.getEnderChestInventory(), true);
        };
    }

    protected void applyImplicitComponents(DataComponentGetter getter) {
        super.applyImplicitComponents(getter);
        this.displayName = (Component)getter.get(DataComponents.CUSTOM_NAME);
        ((BackpackContainerContents)getter.getOrDefault((DataComponentType)DataComponentRegistry.BACKPACK_CONTAINER.get(), (Object)BackpackContainerContents.EMPTY)).copyInto(this.getItems());
    }

    protected void collectImplicitComponents(DataComponentMap.Builder builder) {
        super.collectImplicitComponents(builder);
        builder.set(DataComponents.CUSTOM_NAME, (Object)this.displayName);
        builder.set((DataComponentType)DataComponentRegistry.BACKPACK_CONTAINER.get(), (Object)new BackpackContainerContents((List<ItemStack>)this.getItems()));
    }

    public void spawnFreshItemEntity(Level level, BlockPos pos, Item item) {
        if (!level.isClientSide()) {
            ItemStack itemStack = new ItemStack((ItemLike)item);
            itemStack.applyComponents(this.collectComponents());
            ItemEntity itemEntity = new ItemEntity(level, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, itemStack);
            itemEntity.setDefaultPickUpDelay();
            level.addFreshEntity((Entity)itemEntity);
            this.clearContent();
        }
    }
}

