/*
 * Decompiled with CFR 0.152.
 */
package net.xstopho.resource_backpacks.backpack.api;

import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.xstopho.resource_backpacks.client.slot.BackpackSlot;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public interface BackpackHolder {
    public static final String tagId = "resource_backpacks$backpack";

    public ItemStack getBackpack();

    public void setBackpack(ItemStack var1);

    public static void restorePlayerBackpack(Player oldPlayer, Player newPlayer) {
        ItemStack itemStack = ((BackpackHolder)oldPlayer).getBackpack();
        for (Slot slot : newPlayer.inventoryMenu.slots) {
            if (!(slot instanceof BackpackSlot)) continue;
            slot.set(itemStack);
        }
    }

    default public void dropBackpack(Level level, BlockPos pos) {
        ItemStack itemStack = this.getBackpack();
        if (!itemStack.isEmpty() && !level.isClientSide()) {
            ItemEntity entity = new ItemEntity(level, (double)pos.getX(), (double)(pos.getY() + 1), (double)pos.getZ(), itemStack);
            entity.setDefaultPickUpDelay();
            level.addFreshEntity((Entity)entity);
        }
    }

    default public void readBackpackFromValueInput(ValueInput valueInput) {
        ItemStack backpack = valueInput.read(tagId, ItemStack.CODEC).orElse(ItemStack.EMPTY);
        this.setBackpack(backpack);
    }

    default public void saveBackpackToValueOutput(ValueOutput valueOutput) {
        if (this.getBackpack() != ItemStack.EMPTY) {
            valueOutput.store(tagId, ItemStack.CODEC, (Object)this.getBackpack());
        }
    }
}

