/*
 * Decompiled with CFR 0.152.
 */
package net.xstopho.resource_backpacks.backpack.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.OptionalInt;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipProvider;
import net.xstopho.resource_backpacks.client.util.BackpackClientUtils;
import net.xstopho.resource_backpacks.registries.KeyMappingRegistry;

public final class BackpackContainerContents
implements TooltipProvider {
    public static final Codec<BackpackContainerContents> CODEC = BackpackSlot.CODEC.sizeLimitedListOf(256).xmap(BackpackContainerContents::fromSlots, BackpackContainerContents::asSlots);
    public static final StreamCodec<RegistryFriendlyByteBuf, BackpackContainerContents> STREAM_CODEC = ItemStack.OPTIONAL_STREAM_CODEC.apply(ByteBufCodecs.list((int)256)).map(BackpackContainerContents::new, BackpackContainerContents::toList);
    public static final BackpackContainerContents EMPTY = new BackpackContainerContents((List<ItemStack>)NonNullList.create());
    private final NonNullList<ItemStack> items;
    private final int hashCode;

    public BackpackContainerContents(List<ItemStack> items) {
        if (items.size() > 256) {
            throw new IllegalArgumentException("Too many items, max is 256");
        }
        this.items = NonNullList.withSize((int)items.size(), (Object)ItemStack.EMPTY);
        this.hashCode = ItemStack.hashStackList(items);
        for (int index = 0; index < items.size(); ++index) {
            this.items.set(index, (Object)items.get(index));
        }
    }

    private static BackpackContainerContents fromSlots(List<BackpackSlot> slots) {
        OptionalInt optional = slots.stream().mapToInt(BackpackSlot::index).max();
        BackpackContainerContents component = EMPTY;
        if (optional.isPresent()) {
            component = new BackpackContainerContents((List<ItemStack>)NonNullList.withSize((int)(optional.getAsInt() + 1), (Object)ItemStack.EMPTY));
            for (BackpackSlot slot : slots) {
                component.items.set(slot.index(), (Object)slot.stack());
            }
        }
        return component;
    }

    private List<BackpackSlot> asSlots() {
        ArrayList<BackpackSlot> slots = new ArrayList<BackpackSlot>();
        for (int i = 0; i < this.items.size(); ++i) {
            if (((ItemStack)this.items.get(i)).isEmpty()) continue;
            slots.add(new BackpackSlot(i, (ItemStack)this.items.get(i)));
        }
        return slots;
    }

    public List<ItemStack> toList() {
        return this.items.stream().map(ItemStack::copy).toList();
    }

    public void copyInto(NonNullList<ItemStack> list) {
        for (int i = 0; i < list.size(); ++i) {
            ItemStack stack = ItemStack.EMPTY;
            if (i < this.items.size()) {
                stack = (ItemStack)this.items.get(i);
            }
            list.set(i, (Object)stack.copy());
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof BackpackContainerContents) {
            BackpackContainerContents container = (BackpackContainerContents)other;
            return ItemStack.listMatches(this.items, container.items);
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public void addToTooltip(Item.TooltipContext tooltipContext, Consumer<Component> consumer, TooltipFlag tooltipFlag, DataComponentGetter dataComponentGetter) {
        if (!BackpackClientUtils.enableCompactPreview() && !BackpackClientUtils.enableInventoryPreview()) {
            if (!KeyMappingRegistry.SHOW_COMPACT_PREVIEW.isUnbound()) {
                consumer.accept((Component)KeyMappingRegistry.SHOW_COMPACT_PREVIEW.getTranslatedKeyMessage().copy().withStyle(ChatFormatting.GOLD).append((Component)Component.literal((String)": ")).append((Component)Component.translatable((String)"tooltip.resource_backpacks.info.compact_preview").withStyle(ChatFormatting.WHITE)));
            }
            if (!KeyMappingRegistry.SHOW_INVENTORY_PREVIEW.isUnbound()) {
                consumer.accept((Component)KeyMappingRegistry.SHOW_INVENTORY_PREVIEW.getTranslatedKeyMessage().copy().withStyle(ChatFormatting.GOLD).append((Component)Component.literal((String)": ")).append((Component)Component.translatable((String)"tooltip.resource_backpacks.info.inventory_preview").withStyle(ChatFormatting.WHITE)));
            }
        }
    }

    record BackpackSlot(int index, ItemStack stack) {
        public static final Codec<BackpackSlot> CODEC = RecordCodecBuilder.create(slot -> slot.group((App)Codec.intRange((int)0, (int)256).fieldOf("slot").forGetter(BackpackSlot::index), (App)ItemStack.CODEC.fieldOf("item").forGetter(BackpackSlot::stack)).apply((Applicative)slot, BackpackSlot::new));
    }
}

