/*
 * Decompiled with CFR 0.152.
 */
package net.xstopho.resource_backpacks.client.screen;

import java.util.LinkedList;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.xstopho.resource_backpacks.BackpackConstants;
import net.xstopho.resource_backpacks.client.metadata.BackpackColorMetadata;
import net.xstopho.resource_backpacks.client.screen.BackpackMenu;
import net.xstopho.resource_backpacks.registries.KeyMappingRegistry;
import net.xstopho.resourcelibrary.util.ResourcePackUtils;

public class BackpackMenuScreen
extends AbstractContainerScreen<BackpackMenu> {
    private final ResourceLocation SLOT = this.texture("slot");
    private final ResourceLocation CORNER = this.texture("corner");
    private final ResourceLocation SIDE_VERTICAL = this.texture("side_vertical");
    private final ResourceLocation SIDE_HORIZONTAL = this.texture("side_horizontal");
    private final ResourceLocation INVENTORY_NORMAL = this.texture("inventory_normal");
    private final ResourceLocation INVENTORY_EXTENDED = this.texture("inventory_extended");
    private final int rows;
    private final int columns;

    public BackpackMenuScreen(BackpackMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.rows = menu.getBackpackLevel().getRows();
        this.columns = menu.getBackpackLevel().getColumns();
        this.imageWidth = this.getWidth();
        this.imageHeight = this.getHeight() + 107;
    }

    protected void renderBg(GuiGraphics guiGraphics, float v, int mouseX, int mouseY) {
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        this.renderBackpackMenu(guiGraphics, x, y);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        LinkedList data = ResourcePackUtils.readAllMetaData(BackpackColorMetadata.TYPE);
        int titleColor = data.isEmpty() ? -12566464 : ((BackpackColorMetadata)data.getLast()).getColor();
        guiGraphics.drawString(this.font, this.title, this.titleLabelX, this.titleLabelY, titleColor, false);
    }

    private void renderBackpackMenu(GuiGraphics guiGraphics, int xPos, int yPos) {
        this.renderCorner(guiGraphics, xPos, yPos, 0.0f, 0.0f);
        this.renderCorner(guiGraphics, xPos, yPos + this.getHeight(), 0.0f, 11.0f);
        this.renderCorner(guiGraphics, xPos + this.getWidth() - 11, yPos, 11.0f, 0.0f);
        this.renderCorner(guiGraphics, xPos + this.getWidth() - 11, yPos + this.getHeight(), 11.0f, 11.0f);
        this.renderHorizontalSide(guiGraphics, xPos + 11, yPos, 4.0f, 0.0f, this.getWidth() - 22, 18);
        this.renderHorizontalSide(guiGraphics, xPos + 11, yPos + this.getHeight() - 7, 4.0f, 4.0f, this.getWidth() - 22, 18);
        this.renderVerticalSide(guiGraphics, xPos, yPos + 11, 0.0f, 4.0f, 18, this.getHeight() - 11);
        this.renderVerticalSide(guiGraphics, xPos + this.getWidth() - 18, yPos + 11, 4.0f, 4.0f, 18, this.getHeight() - 11);
        this.renderSlots(guiGraphics, xPos + 7, yPos + 17, this.columns * 18, this.rows * 18);
        this.renderPlayerInventory(guiGraphics, xPos, yPos);
    }

    private void renderCorner(GuiGraphics guiGraphics, int xPos, int yPos, float xOffset, float yOffset) {
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, this.CORNER, xPos, yPos, xOffset, yOffset, 11, 11, 22, 22);
    }

    private void renderHorizontalSide(GuiGraphics guiGraphics, int xPos, int yPos, float xOffset, float yOffset, int width, int height) {
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, this.SIDE_HORIZONTAL, xPos, yPos, xOffset, yOffset, width, height, 22, 22);
    }

    private void renderVerticalSide(GuiGraphics guiGraphics, int xPos, int yPos, float xOffset, float yOffset, int width, int height) {
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, this.SIDE_VERTICAL, xPos, yPos, xOffset, yOffset, width, height, 22, 22);
    }

    private void renderSlots(GuiGraphics guiGraphics, int xPos, int yPos, int width, int height) {
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, this.SLOT, xPos, yPos, 0.0f, 0.0f, width, height, 18, 18);
    }

    private void renderPlayerInventory(GuiGraphics guiGraphics, int xPos, int yPos) {
        ResourceLocation inventory = this.columns < 10 ? this.INVENTORY_NORMAL : this.INVENTORY_EXTENDED;
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, inventory, xPos + (this.getWidth() - 175) / 2, yPos + this.getHeight() + 7, 0.0f, 0.0f, 176, 87, 176, 87);
    }

    private int getWidth() {
        return this.columns * 18 + 14;
    }

    private int getHeight() {
        return this.rows * 18 + 18;
    }

    public boolean keyPressed(KeyEvent keyEvent) {
        if (KeyMappingRegistry.OPEN_BACKPACK.matches(keyEvent)) {
            this.onClose();
            return true;
        }
        return super.keyPressed(keyEvent);
    }

    private ResourceLocation texture(String texture) {
        return BackpackConstants.of(String.format("textures/gui/container/backpack/%s.png", texture));
    }
}

